/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class NavFileDecoder
extends XParser {
    static Map<String, CacheItem> cache = new HashMap<String, CacheItem>();
    BOrd baseOrd;

    public static BNavFileSpace load(BOrd ord) throws Exception {
        BObject file = ord.get();
        if (file instanceof BIFile) {
            return NavFileDecoder.load((BIFile)((Object)file));
        }
        throw new ClassCastException("Not IFile: " + ord + " -> " + file.getType());
    }

    public static BNavFileSpace load(BIFile navFile) throws Exception {
        String key = navFile.getAbsoluteOrd().toString();
        CacheItem c = cache.get(key);
        if (c == null || c.isOutOfDate()) {
            c = new CacheItem();
            c.file = navFile;
            c.lastModified = navFile.getLastModified().getMillis();
            c.space = new NavFileDecoder(navFile).decodeDocument();
            cache.put(key, c);
        }
        return c.space;
    }

    public NavFileDecoder(BIFile file) throws Exception {
        this(file.getSession().getAbsoluteOrd(), new BufferedInputStream(file.getInputStream()));
    }

    public NavFileDecoder(BOrd baseOrd, InputStream in) throws Exception {
        super(in);
        this.baseOrd = baseOrd;
    }

    public BNavFileSpace decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BNavFileSpace decodeDocument(boolean close) throws Exception {
        try {
            XElem root = this.parse();
            if (!root.name().equals("nav")) {
                throw this.err("Root element must be \"nav\"", root);
            }
            String ver = root.get("version");
            if (!ver.equals("1.0")) {
                throw this.err("Only version 1.0 is supported", root);
            }
            XElem node = root.elem("node");
            if (node == null) {
                throw this.err("Missing root <node>", root);
            }
            BNavFileSpace bNavFileSpace = new BNavFileSpace(this.decodeNode(node));
            return bNavFileSpace;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    private BNavFileNode decodeNode(XElem xml) throws Exception {
        String name = null;
        String ordStr = null;
        String iconStr = null;
        for (int i = 0; i < xml.attrSize(); ++i) {
            String attrName = xml.attrName(i);
            String attrValue = xml.attrValue(i);
            if (attrName.equals("name")) {
                name = attrValue;
                continue;
            }
            if (attrName.equals("ord")) {
                ordStr = attrValue;
                continue;
            }
            if (!attrName.equals("icon")) continue;
            iconStr = attrValue;
        }
        BOrd ord = BOrd.make(this.baseOrd, ordStr);
        ord = ord.normalize();
        BIcon icon = null;
        if (iconStr != null) {
            icon = iconStr.startsWith("module:") ? BIcon.make(iconStr) : BIcon.make(BOrd.make(this.baseOrd, iconStr).normalize());
        }
        BNavFileNode node = new BNavFileNode(name, ord, icon);
        XElem[] kids = xml.elems("node");
        for (int i = 0; i < kids.length; ++i) {
            node.addNavChild(this.decodeNode(kids[i]));
        }
        return node;
    }

    XException err(String msg, XElem elem, Throwable cause) {
        return new XException(msg, elem, cause);
    }

    XException err(String msg, XElem elem) {
        return new XException(msg, elem);
    }

    static class CacheItem {
        BIFile file;
        long lastModified;
        BNavFileSpace space;

        CacheItem() {
        }

        boolean isOutOfDate() {
            return this.lastModified != this.file.getLastModified().getMillis();
        }
    }
}

