/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
public class BNavFolder
extends BNavContainer {
    @Generated
    public static final Type TYPE = Sys.loadType(BNavFolder.class);
    private BIcon icon;
    private String navDisplayNameFormat = "";
    private String navDescriptionFormat = "";
    private static final BIcon defaultIcon = BIcon.std("folder.png");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNavFolder(String name) {
        this(name, null, null, null);
    }

    public BNavFolder(String name, String navDescriptionFormat, BIcon icon, String navDisplayNameFormat) {
        super(name);
        if (navDescriptionFormat != null && !navDescriptionFormat.isEmpty()) {
            this.navDescriptionFormat = navDescriptionFormat;
        }
        if (icon == null || icon.isNull()) {
            icon = defaultIcon;
        }
        this.icon = icon;
        if (navDisplayNameFormat != null && !navDisplayNameFormat.isEmpty()) {
            this.navDisplayNameFormat = navDisplayNameFormat;
        }
    }

    @Override
    public BOrd getNavOrd() {
        BINavNode parent = this.getNavParent();
        if (parent == null) {
            return null;
        }
        BOrd ord = parent.getNavOrd();
        if (ord == null) {
            return null;
        }
        return BOrd.make(ord, "nav:" + this.getNavName()).normalize();
    }

    @Override
    public String getNavDisplayName(Context cx) {
        if (this.navDisplayNameFormat != null && !this.navDisplayNameFormat.equals("")) {
            BFormat navDisplayFormat = BFormat.make(this.navDisplayNameFormat);
            return navDisplayFormat.format(this, cx);
        }
        return super.getNavDisplayName(cx);
    }

    @Override
    public String getNavDescription(Context cx) {
        if (this.navDescriptionFormat != null && !this.navDescriptionFormat.equals("")) {
            BFormat format = BFormat.make(this.navDescriptionFormat);
            return format.format(this, cx);
        }
        return "";
    }

    @Override
    public BIcon getIcon() {
        return this.icon;
    }

    public String getNavDisplayFormat() {
        return this.navDisplayNameFormat;
    }

    public void setNavDisplayName(String navDisplayName) {
        this.navDisplayNameFormat = navDisplayName == null || navDisplayName.trim().isEmpty() ? "" : navDisplayName;
    }

    public String getNavDescriptionFormat() {
        return this.navDescriptionFormat;
    }

    public void setNavDescription(String navDescription) {
        this.navDescriptionFormat = navDescription == null || navDescription.trim().isEmpty() ? "" : navDescription;
    }

    public void setIcon(BIcon icon) {
        this.icon = icon == null ? defaultIcon : icon;
    }

    public void rename(String newName) {
        BINavNode[] originalOrder;
        if (newName.equals(this.name)) {
            return;
        }
        BNavContainer parent = (BNavContainer)this.getNavParent();
        if (parent == null) {
            this.name = newName;
            return;
        }
        for (BINavNode child : originalOrder = parent.getNavChildren()) {
            if (!child.getNavName().equals(newName)) continue;
            throw new IllegalArgumentException("duplicate name " + newName);
        }
        parent.removeNavChild(this);
        this.name = newName;
        parent.addNavChild(this);
        parent.reorderNavChildren(originalOrder);
    }
}

