/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.util.IFoxSession;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.SocketFactory;

@NiagaraType
public class BIpHost
extends BHost {
    @Generated
    public static final Type TYPE = Sys.loadType(BIpHost.class);
    BOrd ord;
    InetAddress inetAddress;
    String navDisplayName;
    boolean isNumericAddr;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIpHost(String hostname) {
        super(hostname);
        this.ord = BOrd.make("ip:" + hostname);
        this.isNumericAddr = IPAddressUtil.isNumericAddr((String)hostname);
    }

    public boolean isNumericAddress() {
        return this.isNumericAddr;
    }

    public String getNumericAddress(boolean resolve) throws IOException {
        if (this.isNumericAddr) {
            return this.hostname;
        }
        if (!resolve) {
            if (this.inetAddress != null) {
                return this.inetAddress.getHostAddress();
            }
            return null;
        }
        return this.getInetAddress().getHostAddress();
    }

    public InetAddress getInetAddress() throws IOException {
        InetAddress newInetAddress = InetAddress.getByName(this.getHostname());
        if (!newInetAddress.equals(this.inetAddress)) {
            this.inetAddress = newInetAddress;
            this.navDisplayName = null;
        }
        return this.inetAddress;
    }

    @Override
    public BOrd getAbsoluteOrd() {
        return this.ord;
    }

    @Override
    public Socket openSocket(int port) throws IOException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        return socketFactory.createSocket(this.getInetAddress(), port);
    }

    @Override
    public Socket openSocket(int port, int timeout) throws IOException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        Socket socket = socketFactory.createSocket();
        try {
            socket.connect(new InetSocketAddress(this.getInetAddress(), port), timeout);
        }
        catch (Exception e) {
            socket.close();
            throw e;
        }
        return socket;
    }

    @Override
    public Socket openSocket(int port, SocketFactory socketFactory) throws IOException {
        return socketFactory.createSocket(this.getInetAddress(), port);
    }

    @Override
    public Socket openSocket(int port, SocketFactory socketFactory, int timeout) throws IOException {
        Socket socket = socketFactory.createSocket();
        try {
            socket.connect(new InetSocketAddress(this.getInetAddress(), port), timeout);
        }
        catch (Exception e) {
            socket.close();
            throw e;
        }
        return socket;
    }

    @Override
    public DatagramSocket openDatagramSocket(int port) throws IOException {
        return new DatagramSocket(port, this.getInetAddress());
    }

    @Override
    public String getDefaultNavDisplayName(Context cx) {
        if (this.navDisplayName != null) {
            return this.appendStationName(this.navDisplayName);
        }
        if (this.inetAddress == null) {
            return this.appendStationName(this.hostname);
        }
        try {
            String ip;
            String host;
            this.navDisplayName = this.isNumericAddr ? this.hostname : ((host = this.inetAddress.getHostName()).equals(ip = this.inetAddress.getHostAddress()) ? host : host + " : " + ip);
        }
        catch (Exception e) {
            this.navDisplayName = this.hostname;
        }
        return this.appendStationName(this.navDisplayName);
    }

    String appendStationName(String name) {
        try {
            BINavNode[] kids = this.getNavChildren();
            for (int i = 0; i < kids.length; ++i) {
                String stationName;
                if (!(kids[i] instanceof IFoxSession) || (stationName = ((IFoxSession)((Object)kids[i])).getStationName()) == null) continue;
                return name + " (" + stationName + ")";
            }
            return name;
        }
        catch (Exception e) {
            return name;
        }
    }
}

