/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.util.IFoxSession;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.net.SocketFactory;

@NiagaraType
public abstract class BHost
extends BNavContainer {
    @Generated
    public static final Type TYPE = Sys.loadType(BHost.class);
    static final BIcon iconConnected = BIcon.std("host.png");
    static final BIcon iconDisconnected = BIcon.std("hostDisconnected.png");
    static final Map<String, BHost> cache = new ConcurrentHashMap<String, BHost>();
    static int cachedLocalHostCount = 0;
    String hostname;
    String navDisplayNameFormat = "";
    public static final String DEFAULT_NAVDISPLAY_FORMAT = "%getDefaultNavDisplayName%";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BHost getHost(String hostname) {
        if (hostname.isEmpty()) {
            return BLocalHost.INSTANCE;
        }
        String key = TextUtil.toLowerCase((String)hostname);
        return cache.get(key);
    }

    public static BHost[] getAllHosts() {
        BHost[] remote = BHost.getRemoteHosts();
        BHost[] all = new BHost[remote.length + 1];
        all[0] = BLocalHost.INSTANCE;
        System.arraycopy(remote, 0, all, 1, remote.length);
        return all;
    }

    public static BHost[] getRemoteHosts() {
        Object[] remote = new BHost[cache.size() - cachedLocalHostCount];
        Object[] keys = new String[remote.length];
        Iterator<BHost> it = cache.values().iterator();
        int n = 0;
        while (it.hasNext()) {
            BHost host = it.next();
            if (host == BLocalHost.INSTANCE) continue;
            remote[n] = host;
            keys[n] = host.hostname;
            ++n;
        }
        SortUtil.sort((Object[])keys, (Object[])remote);
        return remote;
    }

    public static void mount(BHost host) {
        String key = TextUtil.toLowerCase((String)host.getHostname());
        if (cache.get(key) != null) {
            throw new IllegalArgumentException("Already mounted " + key);
        }
        String localhost = TextUtil.toLowerCase((String)Sys.getHostName());
        if ("localhost".equals(key) || localhost.equals(key)) {
            ++cachedLocalHostCount;
            cache.put("localhost", BLocalHost.INSTANCE);
            if (!localhost.equals("localhost")) {
                cache.put(localhost, BLocalHost.INSTANCE);
                ++cachedLocalHostCount;
            }
            BNavRoot.INSTANCE.addNavChild(BLocalHost.INSTANCE);
        } else {
            cache.put(key, host);
            BNavRoot.INSTANCE.addNavChild(host);
        }
    }

    public static void unmount(BHost host) {
        String key = TextUtil.toLowerCase((String)host.getHostname());
        String localhost = TextUtil.toLowerCase((String)Sys.getHostName());
        if ("localhost".equals(key) || localhost.equals(key)) {
            --cachedLocalHostCount;
            cache.remove(key, BLocalHost.INSTANCE);
            if (!localhost.equals("localhost")) {
                cache.remove(localhost, BLocalHost.INSTANCE);
                --cachedLocalHostCount;
            }
            ((BNavContainer)host.getNavParent()).removeNavChild(BLocalHost.INSTANCE);
        } else {
            cache.remove(key);
            ((BNavContainer)host.getNavParent()).removeNavChild(host);
        }
    }

    public static void move(BHost host, BNavContainer newParent) {
        BNavContainer navParent = (BNavContainer)host.getNavParent();
        if (newParent == navParent || navParent == null) {
            return;
        }
        navParent.removeNavChild(host);
        newParent.addNavChild(host);
    }

    protected BHost(String hostname) {
        super(hostname);
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setNavDisplayName(String navDisplayName) {
        this.navDisplayNameFormat = navDisplayName == null || navDisplayName.equals("null") || navDisplayName.trim().isEmpty() ? DEFAULT_NAVDISPLAY_FORMAT : navDisplayName;
    }

    @Override
    public String getNavDisplayName(Context cx) {
        if (this.navDisplayNameFormat != null && !this.navDisplayNameFormat.equals("")) {
            BFormat navDisplayFormat = BFormat.make(this.navDisplayNameFormat);
            return navDisplayFormat.format(this, cx);
        }
        return this.getDefaultNavDisplayName(cx);
    }

    public String getDefaultNavDisplayName(Context cx) {
        return super.getNavDisplayName(cx);
    }

    public String getNavDisplayFormat() {
        return this.navDisplayNameFormat;
    }

    public String getStationName() {
        try {
            return Arrays.stream(this.getNavChildren()).filter(navChild -> navChild instanceof IFoxSession && ((IFoxSession)((Object)navChild)).getStationName() != null).findFirst().map(navNode -> ((IFoxSession)((Object)navNode)).getStationName()).orElse(null);
        }
        catch (Exception nx) {
            return null;
        }
    }

    public BISession[] getChildSessions() {
        ArrayList<BISession> v = new ArrayList<BISession>();
        BINavNode[] children = this.getNavChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof BISession)) continue;
            v.add((BISession)children[i]);
        }
        return v.toArray(new BISession[0]);
    }

    public abstract Socket openSocket(int var1) throws IOException;

    public Socket openSocket(int port, int timeout) throws IOException {
        return this.openSocket(port);
    }

    public abstract Socket openSocket(int var1, SocketFactory var2) throws IOException;

    public abstract Socket openSocket(int var1, SocketFactory var2, int var3) throws IOException;

    public abstract DatagramSocket openDatagramSocket(int var1) throws IOException;

    @Override
    public String toString(Context cx) {
        return this.hostname;
    }

    public boolean isConnected() {
        return this.getConnectedSessionCount() > 0;
    }

    public int getConnectedSessionCount() {
        return (int)Stream.of(this.getNavChildren()).filter(session -> session instanceof BISession && ((BISession)session).isConnected()).count();
    }

    public final void disconnect() {
        this.disconnectAllSessions();
        this.doDisconnect();
    }

    protected void doDisconnect() {
    }

    public void disconnectAllSessions() {
        BISession[] sessions = this.getChildSessions();
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i].disconnect();
        }
    }

    public final void close() {
        this.closeAllSessions();
        this.doClose();
        BHost.unmount(this);
    }

    protected void doClose() {
    }

    public void closeAllSessions() {
        BISession[] sessions = this.getChildSessions();
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i].close();
        }
    }

    public abstract BOrd getAbsoluteOrd();

    @Override
    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    @Override
    public void addNavChild(BINavNode child) {
        super.addNavChild(child);
        this.sortNavChildren();
    }

    @Override
    public void removeNavChild(BINavNode child) {
        super.removeNavChild(child);
        this.sortNavChildren();
    }

    void sortNavChildren() {
        Object[] kids = this.getNavChildren();
        Object[] keys = new String[kids.length];
        for (int i = 0; i < kids.length; ++i) {
            BINavNode kid = kids[i];
            keys[i] = kid instanceof BISession ? kid.getType().getTypeName() : "";
        }
        SortUtil.sort((Object[])keys, (Object[])kids);
        this.reorderNavChildren((BINavNode[])kids);
    }

    @Override
    public BIcon getIcon() {
        return this.isConnected() ? iconConnected : iconDisconnected;
    }
}

