/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.job;

import com.tridium.nre.util.NreForkJoinWorkerThreadFactory;
import com.tridium.sys.service.ServiceManager;
import com.tridium.sys.station.BStationSaveJob;
import java.security.AccessController;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BIJobService;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BNotification;

@NiagaraType
@NiagaraAction(name="submitAction", parameterType="BJob", defaultValue="new BStationSaveJob()", returnType="BOrd", flags=4)
@NiagaraTopic(name="notification", eventType="BNotification", flags=4)
public class BJobService
extends BComponent
implements BIService,
BIJobService,
BIRestrictedComponent {
    @Generated
    public static final Action submitAction = BJobService.newAction(4, new BStationSaveJob(), null);
    @Generated
    public static final Topic notification = BJobService.newTopic(4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJobService.class);
    protected ForkJoinPool executor;
    protected MonitorWorker monitorWorker;
    protected UncaughtJobExceptionHandler exceptionHandler = new UncaughtJobExceptionHandler();
    protected static final long DEFAULT_THREAD_MONITOR_INTERVAL_MS = 2000L;
    private static final Logger LOGGER = Logger.getLogger("job.thread.monitor");
    private static final BIcon ICON = BIcon.std("jobService.png");

    @Generated
    public BOrd submitAction(BJob parameter) {
        return (BOrd)this.invoke(submitAction, parameter, null);
    }

    @Generated
    public void fireNotification(BNotification event) {
        this.fire(notification, event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BIJobService getService() {
        try {
            return (BIJobService)((Object)Sys.getService(TYPE));
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            try {
                BOrd ord = BOrd.make("tool:workbench:WbJobService|slot:/");
                return (BIJobService)((Object)ord.resolve().get());
            }
            catch (Exception exception) {
                throw new ServiceNotFoundException("IJobService", exception);
            }
        }
    }

    @Override
    public final BJob[] getJobs() {
        return this.getChildren(BJob.class);
    }

    @Override
    public BOrd submit(BJob job, Context cx) {
        return (BOrd)this.invoke(submitAction, job, cx);
    }

    public BOrd doSubmitAction(BJob job, Context cx) {
        return AccessController.doPrivileged(() -> {
            this.add(job.getType().getTypeName() + '?', (BValue)job, 2);
            job.doSubmit(cx);
            ServiceManager.houseKeeping(this);
            return job.getSlotPathOrd();
        });
    }

    @Override
    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public void serviceStarted() {
        int threadsPerCPU = AccessController.doPrivileged(() -> Integer.getInteger("niagara.job.threadsPerCPU", 2));
        int defaultThreads = Runtime.getRuntime().availableProcessors() * threadsPerCPU;
        int threads = AccessController.doPrivileged(() -> Integer.getInteger("niagara.job.threads", defaultThreads));
        this.startThreadPool(threads);
    }

    @Override
    public void serviceStopped() {
        this.stopThreadPool();
    }

    @Override
    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent(parent, this);
    }

    @Override
    public BIcon getIcon() {
        return ICON;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        BJob[] jobs = this.getJobs();
        out.startTable(true);
        out.trTitle("Jobs", 6);
        out.w("<tr>").th("Name").th("State").th("Progress").th("Start").th("Heartbeat").th("End").w("</tr>").nl();
        for (BJob j : jobs) {
            out.tr(j.getName(), j.getJobState(), String.valueOf(j.getProgress()), j.getStartTime(), j.getHeartbeatTime(), j.getEndTime());
        }
        out.endTable();
        if (this.getExecutor() != null) {
            out.w("<p>");
            out.startTable(true);
            out.trTitle("Thread Pool", 7);
            out.w("<tr>").th("Current Pool Size").th("Max Pool Size").th("Active").th("Running").th("Submitted").th("Queued").th("Steals").w("</tr>").nl();
            out.tr(this.getExecutor().getPoolSize(), this.getExecutor().getParallelism(), this.getExecutor().getActiveThreadCount(), this.getExecutor().getRunningThreadCount(), this.getExecutor().getQueuedSubmissionCount(), this.getExecutor().getQueuedTaskCount(), this.getExecutor().getStealCount());
            out.endTable();
        }
        super.spy(out);
    }

    public ForkJoinPool getExecutor() {
        return this.executor;
    }

    protected void startThreadPool(int threads) {
        this.executor = new ForkJoinPool(threads, NreForkJoinWorkerThreadFactory.DEFAULT_INSTANCE, this.exceptionHandler, true);
        long monitorIntervalMs = AccessController.doPrivileged(() -> Long.getLong("niagara.job.thread.monitor.intervalMs", 2000L));
        if (monitorIntervalMs <= 0L) {
            return;
        }
        this.monitorWorker = new MonitorWorker(this.executor, monitorIntervalMs);
        this.monitorWorker.setPriority(4);
        this.monitorWorker.setDaemon(true);
        this.monitorWorker.start();
    }

    protected void stopThreadPool() {
        block4: {
            if (this.executor == null) {
                return;
            }
            this.executor.shutdownNow();
            if (this.monitorWorker == null) {
                return;
            }
            this.monitorWorker.requestStop();
            try {
                this.monitorWorker.join(2000L);
            }
            catch (InterruptedException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block4;
                LOGGER.log(Level.FINE, "Monitor join interrupted on stop", e);
            }
        }
    }

    protected static class MonitorWorker
    extends Thread {
        private final ForkJoinPool executor;
        private final long monitorIntervalMs;
        private volatile boolean run = true;

        public MonitorWorker(ForkJoinPool executor, long monitorIntervalMs) {
            super("JobService:MonitorWorker");
            this.executor = executor;
            this.monitorIntervalMs = monitorIntervalMs;
        }

        public void requestStop() {
            this.run = false;
            this.interrupt();
        }

        @Override
        public void run() {
            if (this.monitorIntervalMs <= 0L) {
                return;
            }
            while (this.run) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    String traceMessage = String.format("[%d/%d] Active: %d, Running: %d, Submitted: %d, Queued: %d, Steals: %d", this.executor.getPoolSize(), this.executor.getParallelism(), this.executor.getActiveThreadCount(), this.executor.getRunningThreadCount(), this.executor.getQueuedSubmissionCount(), this.executor.getQueuedTaskCount(), this.executor.getStealCount());
                    LOGGER.log(Level.FINE, traceMessage);
                }
                try {
                    Thread.sleep(this.monitorIntervalMs);
                }
                catch (InterruptedException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "MonitorWorker sleep interrupted", e);
                }
            }
        }
    }

    protected static class UncaughtJobExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected UncaughtJobExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOGGER.log(Level.SEVERE, "Uncaught exception from thread " + t + "\n" + e);
        }
    }
}

