/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.io.BogPasswordObjectEncoder;
import com.tridium.sys.schema.ComponentSlotMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.category.BCategoryMask;
import javax.baja.io.BIContextEncodable;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Version;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.xml.XWriter;

public class ValueDocEncoder
implements AutoCloseable {
    public static final Version BOG_VERSION_1 = new Version("1.0");
    public static final Version BOG_VERSION_4 = new Version("4.0");
    private static final int SECURITY_INACCESSIBLE = 1;
    private static final int SECURITY_READONLY = 2;
    private static final Logger log = Logger.getLogger("sys.xml");
    private List<Exception> unhandledEncodingExceptions = new ArrayList<Exception>();
    private static TypeInfo nullProxyExt = null;
    private boolean encodeTransients;
    private boolean encodeComments = true;
    private Context context;
    private HashMap<BComponent, BPermissions> permissionsCache;
    protected final IEncoderPlugin plugin;

    public static String marshal(BValue value) throws IOException {
        return BogEncoderPlugin.marshal(value);
    }

    public static String marshal(BValue value, Context cx) throws IOException {
        return BogEncoderPlugin.marshal(value, cx);
    }

    public ValueDocEncoder(IEncoderPlugin plugin) throws IOException {
        this(plugin, null);
    }

    public ValueDocEncoder(IEncoderPlugin plugin, Context context) throws IOException {
        this.plugin = plugin;
        this.context = context;
    }

    public ValueDocEncoder(File file) throws IOException {
        this(new BogEncoderPlugin(file), null);
    }

    public ValueDocEncoder(OutputStream out) throws IOException {
        this(new BogEncoderPlugin(out), null);
    }

    public ValueDocEncoder(File file, Context context) throws IOException {
        this(new BogEncoderPlugin(file, context), context);
    }

    public ValueDocEncoder(OutputStream out, Context context) throws IOException {
        this(new BogEncoderPlugin(out, context), context);
    }

    public Context getContext() {
        return this.context;
    }

    public static Context getMergedContext(BComplex parent, Slot slot, Context cx) {
        if (parent == null || slot == null) {
            return cx;
        }
        BFacets facets = parent.getSlotFacets(slot);
        if (cx == null) {
            cx = facets;
        } else if (facets != null && !facets.isNull()) {
            if (facets.getPickle() == null) {
                facets = BFacets.makePickle(facets, BFacets.SKIP_INTERN_PICKLE);
            }
            cx = new BasicContext(cx, facets);
        }
        if (parent.isStruct() && parent.getParent() != null) {
            return ValueDocEncoder.getMergedContext(parent.getParent(), parent.getPropertyInParent(), cx);
        }
        return cx;
    }

    public boolean isSyncEncoder() {
        return false;
    }

    public boolean isEncodeTransients() {
        return this.encodeTransients;
    }

    public boolean setEncodeTransients(boolean encodeTransients) {
        boolean old = this.encodeTransients;
        this.encodeTransients = encodeTransients;
        return old;
    }

    public boolean isEncodeComments() {
        return this.encodeComments;
    }

    public boolean setEncodeComments(boolean encodeComments) {
        boolean old = this.encodeComments;
        this.encodeComments = encodeComments;
        return old;
    }

    public final IEncoderPlugin getPlugin() {
        return this.plugin;
    }

    public Stream<Exception> getUnhandledEncodingExceptions() {
        return this.unhandledEncodingExceptions.stream();
    }

    public void encodeDocument(BValue value) throws IOException {
        this.unhandledEncodingExceptions.clear();
        this.plugin.encodeDocument(this, value);
        this.plugin.flush();
    }

    public void encode(BValue value) throws IOException {
        this.encode(null, value, Integer.MAX_VALUE);
    }

    public void encode(String name, BValue value, int depth) throws IOException {
        BPermissions permissions = BPermissions.all;
        if (this.context != null && this.context.getUser() != null && value instanceof BComponent && !(permissions = this.getPermissionsFor(value.asComponent())).hasOperatorRead()) {
            throw new SecurityException("Missing op read permission on value");
        }
        this.plugin.start("p");
        if (name != null) {
            this.wname(name);
        }
        if (value instanceof BComponent) {
            BCategoryMask cats;
            BComponent comp = (BComponent)value;
            Object handle = comp.getHandle();
            if (handle != null) {
                this.whandle(handle);
            }
            if (!(cats = comp.getCategoryMask()).isNull()) {
                this.wcategories(cats);
            }
            if (comp.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded()) {
                this.plugin.attr("stub", true);
            }
        }
        this.wtype(value);
        Context cx = this.getContext();
        if (value.isComplex() && value.asComplex().getParent() != null) {
            BComplex complex = value.asComplex();
            cx = ValueDocEncoder.getMergedContext(complex.getParent(), complex.getPropertyInParent(), this.getContext());
        }
        this.encodeValue(value, depth, permissions, cx);
    }

    public final void flush() throws IOException {
        this.plugin.flush();
    }

    @Override
    public final void close() throws IOException {
        this.plugin.close();
        this.doClose();
    }

    public final IEncoderPlugin start(String name) throws IOException {
        return this.plugin.start(name);
    }

    public final IEncoderPlugin startArray(String name) throws IOException {
        return this.plugin.startArray(name);
    }

    public final IEncoderPlugin endArray() throws IOException {
        return this.plugin.endArray();
    }

    public final IEncoderPlugin end() throws IOException {
        return this.plugin.end();
    }

    public final IEncoderPlugin end(String name) throws IOException {
        return this.plugin.end(name);
    }

    public final IEncoderPlugin endAttr() throws IOException {
        return this.plugin.endAttr();
    }

    public final IEncoderPlugin key(String key) throws IOException {
        return this.plugin.key(key);
    }

    public final IEncoderPlugin attr(String key, boolean val) throws IOException {
        return this.plugin.attr(key, val);
    }

    public final IEncoderPlugin attr(String key, double val) throws IOException {
        return this.plugin.attr(key, val);
    }

    public final IEncoderPlugin attr(String key, String str) throws IOException {
        return this.plugin.attr(key, str);
    }

    public final IEncoderPlugin attrSafe(String key, String str) throws IOException {
        return this.plugin.attrSafe(key, str);
    }

    public final IEncoderPlugin comment(String text) throws IOException {
        return this.plugin.comment(text);
    }

    public final IEncoderPlugin incrementIndent() throws IOException {
        return this.plugin.incrementIndent();
    }

    public final IEncoderPlugin decrementIndent() throws IOException {
        return this.plugin.decrementIndent();
    }

    public final IEncoderPlugin indent() throws IOException {
        return this.plugin.indent();
    }

    public final int getIndent() {
        return this.plugin.getIndent();
    }

    public final IEncoderPlugin newLine() throws IOException {
        return this.plugin.newLine();
    }

    public boolean isZipped() {
        return this.plugin.isZipped();
    }

    public void setZipped(boolean zipped) throws IOException {
        this.plugin.setZipped(zipped);
    }

    protected void encodingComponent(BComponent c) throws IOException {
    }

    protected void encodingComponentStub(BComponent c) throws IOException {
    }

    protected void encodingValue(BValue val, Context cx) throws IOException {
    }

    protected void encodingSlot(BComplex parent, Slot slot) throws IOException {
    }

    protected void encodingFacets(BFacets facets) throws IOException {
    }

    protected boolean encodePropertyValue(BComplex parent, Property prop, int depth, BPermissions permissions, Context context) throws IOException {
        return false;
    }

    protected void doClose() throws IOException {
    }

    private void encodeSlot(BComplex parent, Slot slot, int depth, BPermissions permissions) throws IOException {
        SlotPath path;
        boolean skipValue;
        if (slot == null) {
            return;
        }
        int flags = parent.getFlags(slot);
        boolean flagsOnly = false;
        if (!this.encodeTransients && (flags & 2) != 0) {
            if (slot.isProperty() && slot.isFrozen() && flags != slot.getDefaultFlags()) {
                flagsOnly = true;
            } else {
                return;
            }
        }
        Property prop = null;
        BValue value = null;
        if (slot.isProperty() && !flagsOnly) {
            prop = (Property)slot;
            if (this.encodePrimitive(parent, prop, flags)) {
                return;
            }
            value = parent.get(prop);
            skipValue = this.canSkipEncodingProperty(parent, prop, value, permissions);
        } else {
            if (slot instanceof Property) {
                value = parent.get((Property)slot);
            }
            skipValue = true;
        }
        if (this.context != null && this.context.getUser() != null) {
            int security = this.getSecurityMask(permissions, slot, value, flags);
            if ((security & 1) != 0) {
                if (slot.isFrozen()) {
                    flags |= 4;
                } else {
                    return;
                }
            }
            if ((security & 2) != 0) {
                flags |= 1;
            }
        }
        if (flags == slot.getDefaultFlags() && skipValue) {
            return;
        }
        boolean isDynamicComponent = slot.isDynamic() && value instanceof BComponent;
        this.plugin.indent();
        if (isDynamicComponent && this.encodeComments && (path = ((BComponent)value).getSlotPath()) != null) {
            this.plugin.comment(path.getBody());
            this.plugin.indent();
        }
        if (slot.isProperty()) {
            this.plugin.start("p");
        } else if (slot.isAction()) {
            this.plugin.start("a");
        } else if (slot.isTopic()) {
            this.plugin.start("t");
        } else {
            throw new IllegalStateException();
        }
        this.wname(slot.getName());
        this.encodingSlot(parent, slot);
        if ((slot.isDynamic() && flags != 0 || flags != slot.getDefaultFlags()) && parent.isComponent()) {
            this.wflags(flags);
        }
        BFacets facets = slot.getFacets();
        if (slot.isDynamic() && !facets.isNull()) {
            this.wfacets(facets);
        }
        if (value instanceof BComponent) {
            BCategoryMask cats;
            BComponent comp = (BComponent)value;
            Object handle = comp.getHandle();
            if (handle != null) {
                this.whandle(handle);
            }
            if (!(cats = comp.getCategoryMask()).isNull()) {
                this.wcategories(cats);
            }
            if (depth == 0 || comp.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded()) {
                this.plugin.attr("stub", true);
            }
        }
        if (prop != null && !skipValue) {
            this.wtype(value);
            Context mergedContext = ValueDocEncoder.getMergedContext(parent, prop, this.getContext());
            int encodeDepth = depth - 1;
            boolean handledBySubclass = this.encodePropertyValue(parent, prop, encodeDepth, permissions, mergedContext);
            if (!handledBySubclass) {
                this.encodeValue(value, encodeDepth, permissions, mergedContext);
            }
        } else {
            this.plugin.end().newLine();
        }
    }

    private boolean encodePrimitive(BComplex parent, Property prop, int flags) throws IOException {
        String s;
        if (prop.isDynamic() || flags != prop.getDefaultFlags()) {
            return false;
        }
        if (prop.getTypeAccess() == 7) {
            return false;
        }
        if (this.isSyncEncoder()) {
            return false;
        }
        boolean safe = false;
        switch (prop.getTypeAccess()) {
            case 0: {
                boolean b = parent.getBoolean(prop);
                if (b == ((BBoolean)prop.getDefaultValue()).getBoolean()) {
                    return true;
                }
                s = BBoolean.encode(b);
                break;
            }
            case 2: {
                int i = parent.getInt(prop);
                if (i == ((BInteger)prop.getDefaultValue()).getInt()) {
                    return true;
                }
                s = BInteger.encode(i);
                break;
            }
            case 3: {
                long l = parent.getLong(prop);
                if (l == ((BLong)prop.getDefaultValue()).getLong()) {
                    return true;
                }
                s = BLong.encode(l);
                break;
            }
            case 4: {
                float f = parent.getFloat(prop);
                if (f == ((BFloat)prop.getDefaultValue()).getFloat()) {
                    return true;
                }
                s = BFloat.encode(f);
                break;
            }
            case 5: {
                double d = parent.getDouble(prop);
                if (d == ((BDouble)prop.getDefaultValue()).getDouble()) {
                    return true;
                }
                s = BDouble.encode(d);
                break;
            }
            case 6: {
                s = parent.getString(prop);
                safe = true;
                if (!Objects.equals(s, ((BString)prop.getDefaultValue()).getString())) break;
                return true;
            }
            default: {
                throw new IllegalStateException("" + prop.getTypeAccess());
            }
        }
        this.plugin.indent().start("p");
        this.wname(prop.getName());
        if (safe) {
            this.plugin.attrSafe("v", s);
        } else {
            this.plugin.attr("v", s);
        }
        this.encodingValue(parent.get(prop), ValueDocEncoder.getMergedContext(parent, prop, this.getContext()));
        this.plugin.end().newLine();
        return true;
    }

    private void encodeValue(BValue value, int depth, BPermissions permissions, Context cx) throws IOException {
        this.encodingValue(value, cx);
        if (this.isTypeBlackListed(value.getType()) && value.isSimple()) {
            value = (BValue)value.getType().getInstance();
        }
        if (value.isSimple()) {
            this.wvalue((BSimple)value);
            this.plugin.end().newLine();
        } else if (value.isComponent() && depth < 0) {
            this.plugin.endAttr();
            this.encodingComponentStub((BComponent)value);
            this.plugin.end("p").newLine();
        } else {
            if (value.isComponent()) {
                permissions = this.getPermissionsFor(value.asComponent());
            }
            if (this.encodeStructValue(value)) {
                return;
            }
            this.plugin.endAttr().newLine().incrementIndent();
            BComplex complex = (BComplex)value;
            SlotCursor<Slot> c = complex.getSlots();
            boolean first = true;
            while (c.next()) {
                if (first) {
                    this.plugin.startArray("s");
                    first = false;
                }
                this.encodeSlot(complex, c.slot(), depth, permissions);
            }
            if (!first) {
                this.plugin.endArray();
            }
            if (complex.isComponent()) {
                this.encodingComponent(complex.asComponent());
            }
            this.plugin.decrementIndent().indent().end("p").newLine();
        }
    }

    protected boolean canSkipEncodingProperty(BComplex complex, Property prop, BValue value, BPermissions permissions) {
        if (!prop.isFrozen()) {
            return false;
        }
        if (value.isComponent()) {
            return !this.isSyncEncoder() && value.getType().getTypeInfo() == nullProxyExt;
        }
        return prop.isEquivalentToDefaultValue(value);
    }

    private boolean encodeStructValue(BValue value) throws IOException {
        if (value instanceof BStatusValue) {
            return this.encodeStatusValue(value);
        }
        if (value instanceof BLink) {
            return this.encodeLink(value);
        }
        return value instanceof BRelation && this.encodeRelation(value);
    }

    private boolean encodeLink(BValue value) throws IOException {
        if (value.getType() != BLink.TYPE) {
            return false;
        }
        BLink link = (BLink)value;
        this.plugin.endAttr().startArray("s");
        this.plugin.start("p").attr("n", "sourceOrd").attrSafe("v", link.getEndpointOrd().encodeToString());
        this.encodingSlot(link, BRelation.sourceOrd);
        this.encodingValue(link.getEndpointOrd(), ValueDocEncoder.getMergedContext(link, BRelation.sourceOrd, this.getContext()));
        this.plugin.end();
        this.plugin.start("p").attr("n", "relationTags").attrSafe("v", link.getRelationTags().encodeToString());
        this.encodingSlot(link, BRelation.relationTags);
        this.encodingValue(link.get(BRelation.relationTags), ValueDocEncoder.getMergedContext(link, BRelation.relationTags, this.getContext()));
        this.plugin.end();
        this.plugin.start("p").attr("n", "relationId").attrSafe("v", link.getRelationId());
        this.encodingSlot(link, BRelation.relationId);
        this.encodingValue(link.get(BRelation.relationId), ValueDocEncoder.getMergedContext(link, BRelation.relationId, this.getContext()));
        this.plugin.end();
        this.plugin.start("p").attr("n", "sourceSlotName").attrSafe("v", link.getSourceSlotName());
        this.encodingSlot(link, BLink.sourceSlotName);
        this.encodingValue(link.get(BLink.sourceSlotName), ValueDocEncoder.getMergedContext(link, BLink.sourceSlotName, this.getContext()));
        this.plugin.end();
        this.plugin.start("p").attr("n", "targetSlotName").attrSafe("v", link.getTargetSlotName());
        this.encodingSlot(link, BLink.targetSlotName);
        this.encodingValue(link.get(BLink.targetSlotName), ValueDocEncoder.getMergedContext(link, BLink.targetSlotName, this.getContext()));
        this.plugin.end();
        if (!link.getEnabled()) {
            this.plugin.start("p").attr("n", "enabled").attr("v", false);
            this.encodingSlot(link, BLink.enabled);
            this.encodingValue(link.get(BLink.enabled), ValueDocEncoder.getMergedContext(link, BLink.enabled, this.getContext()));
            this.plugin.end();
        }
        this.plugin.endArray().end("p").newLine();
        return true;
    }

    private boolean encodeRelation(BValue value) throws IOException {
        if (value.getType() != BRelation.TYPE) {
            return false;
        }
        BRelation bRelation = (BRelation)value;
        this.plugin.endAttr().startArray("s");
        this.plugin.start("p").attr("n", "sourceOrd").attrSafe("v", bRelation.getEndpointOrd().encodeToString());
        this.encodingSlot(bRelation, BRelation.sourceOrd);
        this.encodingValue(bRelation.getEndpointOrd(), ValueDocEncoder.getMergedContext(bRelation, BRelation.sourceOrd, this.getContext()));
        this.plugin.end();
        this.plugin.start("p").attr("n", "relationTags").attrSafe("v", bRelation.getRelationTags().encodeToString());
        this.encodingSlot(bRelation, BRelation.relationTags);
        this.encodingValue(bRelation.get(BRelation.relationTags), ValueDocEncoder.getMergedContext(bRelation, BRelation.relationTags, this.getContext()));
        this.plugin.end();
        this.plugin.start("p").attr("n", "relationId").attrSafe("v", bRelation.getRelationId());
        this.encodingSlot(bRelation, BRelation.relationId);
        this.encodingValue(bRelation.get(BRelation.relationId), ValueDocEncoder.getMergedContext(bRelation, BRelation.relationId, this.getContext()));
        this.plugin.end();
        this.plugin.endArray().end("p").newLine();
        return true;
    }

    private boolean encodeStatusValue(BValue value) throws IOException {
        BStatus status;
        if (value.getType() == BStatusNumeric.TYPE) {
            BStatusNumeric x = (BStatusNumeric)value;
            this.plugin.endAttr().startArray("s").start("p").attr("n", "value").attr("v", BDouble.encode(x.getValue()));
            this.encodingSlot(x, BStatusNumeric.value);
            this.encodingValue(x.get(BStatusNumeric.value), ValueDocEncoder.getMergedContext(x, BStatusNumeric.value, this.getContext()));
            this.plugin.end();
            status = x.getStatus();
        } else if (value.getType() == BStatusBoolean.TYPE) {
            BStatusBoolean x = (BStatusBoolean)value;
            this.plugin.endAttr().startArray("s").start("p").attr("n", "value").attr("v", BBoolean.encode(x.getValue()));
            this.encodingSlot(x, BStatusBoolean.value);
            this.encodingValue(x.get(BStatusBoolean.value), ValueDocEncoder.getMergedContext(x, BStatusBoolean.value, this.getContext()));
            this.plugin.end();
            status = x.getStatus();
        } else if (value.getType() == BStatusEnum.TYPE) {
            BStatusEnum x = (BStatusEnum)value;
            this.plugin.endAttr().startArray("s").start("p").attr("n", "value").attr("v", x.getValue().encodeToString());
            this.encodingSlot(x, BStatusEnum.value);
            this.encodingValue(x.get(BStatusEnum.value), ValueDocEncoder.getMergedContext(x, BStatusEnum.value, this.getContext()));
            this.plugin.end();
            status = x.getStatus();
        } else if (value.getType() == BStatusString.TYPE) {
            BStatusString x = (BStatusString)value;
            this.plugin.endAttr().startArray("s").start("p").attr("n", "value").attrSafe("v", x.getValue());
            this.encodingSlot(x, BStatusString.value);
            this.encodingValue(x.get(BStatusString.value), ValueDocEncoder.getMergedContext(x, BStatusString.value, this.getContext()));
            this.plugin.end();
            status = x.getStatus();
        } else {
            return false;
        }
        if (!status.equals(BStatus.DEFAULT)) {
            this.plugin.start("p").attr("n", "status").attrSafe("v", status.encodeToString());
            this.encodingSlot(value.asComplex(), BStatusValue.status);
            this.encodingValue(status, ValueDocEncoder.getMergedContext(value.asComplex(), BStatusValue.status, this.getContext()));
            this.plugin.end();
        }
        this.plugin.endArray().end("p").newLine();
        return true;
    }

    public BPermissions getPermissionsFor(BComponent c) {
        BPermissions p;
        if (this.context == null) {
            return BPermissions.all;
        }
        BUser user = this.context.getUser();
        if (user == null) {
            return BPermissions.all;
        }
        if (this.permissionsCache == null) {
            this.permissionsCache = new HashMap();
        }
        if ((p = this.permissionsCache.get(c)) == null) {
            p = c.getPermissions(this.context);
            this.permissionsCache.put(c, p);
        }
        return p;
    }

    private int getSecurityMask(BPermissions permissions, Slot slot, BValue value, int flags) {
        boolean inaccessible = false;
        boolean readonly = false;
        if (slot.isProperty() && value.isComponent()) {
            if (!this.getPermissionsFor(value.asComponent()).has(BPermissions.operatorRead)) {
                inaccessible = true;
            }
        } else if (slot.isAction()) {
            if ((flags & 0x100) != 0) {
                if (!permissions.has(BPermissions.operatorInvoke)) {
                    inaccessible = true;
                }
            } else if (!permissions.has(BPermissions.adminInvoke)) {
                inaccessible = true;
            }
        } else if ((flags & 0x100) != 0) {
            if (!permissions.has(BPermissions.operatorRead)) {
                inaccessible = true;
            } else if (!permissions.has(BPermissions.operatorWrite)) {
                readonly = true;
            }
        } else if (!permissions.has(BPermissions.adminRead)) {
            inaccessible = true;
        } else if (!permissions.has(BPermissions.adminWrite)) {
            readonly = true;
        }
        int mask = 0;
        if (inaccessible) {
            mask |= 1;
        }
        if (readonly) {
            mask |= 2;
        }
        return mask;
    }

    private ValueDocEncoder wname(String name) throws IOException {
        this.plugin.attr("n", name);
        return this;
    }

    private ValueDocEncoder wtype(BObject object) throws IOException {
        this.plugin.encodeType(object.getType());
        return this;
    }

    private ValueDocEncoder wflags(int flags) throws IOException {
        this.plugin.attr("f", Flags.encodeToString(flags));
        return this;
    }

    private ValueDocEncoder whandle(Object handle) throws IOException {
        this.plugin.attr("h", handle.toString());
        return this;
    }

    private ValueDocEncoder wcategories(BCategoryMask cats) throws IOException {
        this.plugin.attr("c", cats.encodeToString());
        return this;
    }

    private ValueDocEncoder wfacets(BFacets facets) throws IOException {
        this.encodingFacets(facets);
        this.plugin.attrSafe("x", facets.encodeToString());
        return this;
    }

    private ValueDocEncoder wvalue(BSimple simple) throws IOException {
        block4: {
            try {
                String s = this.encodeSimple(simple);
                this.plugin.attrSafe("v", s);
            }
            catch (Exception e) {
                if (this.plugin.processEncodingException(simple, e)) break block4;
                this.unhandledEncodingExceptions.add(e);
                String s = "?";
                try {
                    s = simple.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.log(Level.SEVERE, "Encoding " + simple.getType() + " \"" + s + "\"", e);
                this.attr("err", simple.getType() + ".encodeToString()");
            }
        }
        return this;
    }

    protected String encodeSimple(BSimple simple) throws IOException {
        return this.plugin.encodeSimple(this, simple, this.context);
    }

    public boolean isTypeBlackListed(Type type) {
        return false;
    }

    static {
        try {
            nullProxyExt = Sys.getRegistry().getType("control:NullProxyExt");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class BogEncoderPlugin
    implements IEncoderPlugin {
        protected int indent = 0;
        private final XWriter w;
        private final HashMap<String, String> modules = new HashMap(33);
        private final HashMap<String, String> keys = new HashMap(33);
        private BogPasswordObjectEncoder bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeNone();
        private Optional<BPassword> passPhrase = Optional.empty();
        private boolean failOnEncodingExceptions = true;
        protected Version version = BOG_VERSION_4;

        public BogEncoderPlugin(File file) throws IOException {
            this(file, null);
        }

        public BogEncoderPlugin(OutputStream out) throws IOException {
            this(out, null);
        }

        public BogEncoderPlugin(File file, Context pluginContext) throws IOException {
            this.w = new XWriter(file);
            this.initPasswordHandling(pluginContext);
        }

        public BogEncoderPlugin(OutputStream out, Context pluginContext) throws IOException {
            this.w = new XWriter(out);
            this.initPasswordHandling(pluginContext);
        }

        private void initPasswordHandling(Context pluginContext) throws IOException {
            if (pluginContext != null) {
                try {
                    PasswordEncodingContext pContext = PasswordEncodingContext.find(pluginContext).orElse(null);
                    if (pContext != null && pContext.hasEncryptionKey()) {
                        this.bogPasswordObjectEncoder = AccessController.doPrivileged(() -> BogPasswordObjectEncoder.make((ISecretBytesSupplier)pContext.getEncryptionKey().get()));
                    }
                }
                catch (PrivilegedActionException pae) {
                    if (pae.getCause() instanceof IOException) {
                        throw (IOException)pae.getCause();
                    }
                    throw new IOException(pae.getCause());
                }
            }
        }

        @Override
        public IEncoderPlugin encodeDocument(ValueDocEncoder encoder, BValue value) throws IOException {
            this.w.w((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            if (!this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring)) {
                PasswordEncodingContext pContext = PasswordEncodingContext.from(encoder.context);
                if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.none)) {
                    try {
                        AccessController.doPrivileged(() -> {
                            pContext.setEncryptionKey(EncryptionKeySource.none, Optional.empty());
                            return null;
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        if (pae.getCause() instanceof IOException) {
                            throw (IOException)pae.getCause();
                        }
                        throw new IOException(pae.getCause());
                    }
                }
                if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.shared)) {
                    try {
                        AccessController.doPrivileged(() -> {
                            pContext.setEncryptionKey(EncryptionKeySource.external, Optional.of(this.bogPasswordObjectEncoder.passPhraseToKey(null)));
                            return null;
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        if (pae.getCause() instanceof IOException) {
                            throw (IOException)pae.getCause();
                        }
                        throw new IOException(pae.getCause());
                    }
                }
                if (this.passPhrase.isPresent()) {
                    try {
                        AccessController.doPrivileged(() -> {
                            try (SecretChars secretChars = this.passPhrase.get().getSecretChars();){
                                this.bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeExternal((SecretChars)secretChars);
                                pContext.setEncryptionKey(EncryptionKeySource.external, Optional.of(this.bogPasswordObjectEncoder.getPassPhraseEncodingKey()));
                                Void void_ = null;
                                return void_;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        if (pae.getCause() instanceof IOException) {
                            throw (IOException)pae.getCause();
                        }
                        throw new IOException(pae.getCause());
                    }
                }
                if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.external)) {
                    try {
                        AccessController.doPrivileged(() -> {
                            if (this.bogPasswordObjectEncoder.getPassPhraseEncodingKey() == null) {
                                pContext.setEncryptionKey(EncryptionKeySource.external, Optional.empty());
                            } else {
                                pContext.setEncryptionKey(EncryptionKeySource.external, Optional.of(this.bogPasswordObjectEncoder.getPassPhraseEncodingKey()));
                            }
                            return null;
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        if (pae.getCause() instanceof IOException) {
                            throw (IOException)pae.getCause();
                        }
                        throw new IOException(pae.getCause());
                    }
                }
                if (encoder.context == null) {
                    encoder.context = pContext;
                }
            }
            this.getBogPasswordObjectEncoder().writeBogHeader(this.w, this.version.toString());
            encoder.encode(value);
            this.w.w((Object)"</bajaObjectGraph>\n");
            return this;
        }

        @Override
        public IEncoderPlugin start(String name) throws IOException {
            this.w.w((Object)"<").w((Object)name);
            return this;
        }

        @Override
        public IEncoderPlugin startArray(String name) throws IOException {
            return this;
        }

        @Override
        public IEncoderPlugin endArray() throws IOException {
            return this;
        }

        @Override
        public IEncoderPlugin end() throws IOException {
            this.w.w((Object)"/>");
            return this;
        }

        @Override
        public IEncoderPlugin end(String name) throws IOException {
            this.w.w((Object)"</").w((Object)name).w((Object)">");
            return this;
        }

        @Override
        public IEncoderPlugin endAttr() throws IOException {
            this.w.w((Object)">");
            return this;
        }

        @Override
        public IEncoderPlugin newLine() throws IOException {
            this.w.w((Object)"\n");
            return this;
        }

        @Override
        public IEncoderPlugin key(String key) throws IOException {
            return this;
        }

        @Override
        public IEncoderPlugin attr(String key, boolean val) throws IOException {
            this.attr(key, String.valueOf(val));
            return this;
        }

        @Override
        public IEncoderPlugin attr(String key, double val) throws IOException {
            this.attr(key, String.valueOf(val));
            return this;
        }

        @Override
        public IEncoderPlugin attr(String key, String str) throws IOException {
            this.w.w((Object)" ").w((Object)key).w((Object)"=\"").w((Object)str).w((Object)"\"");
            return this;
        }

        @Override
        public IEncoderPlugin attrSafe(String key, String str) throws IOException {
            this.w.w((Object)" ").w((Object)key).w((Object)"=\"").safe(str).w((Object)"\"");
            return this;
        }

        public boolean failOnEncodingExceptions() {
            return this.failOnEncodingExceptions;
        }

        public void setFailOnEncodingExceptions(boolean value) {
            this.failOnEncodingExceptions = value;
        }

        @Override
        public boolean processEncodingException(BObject object, Exception e) throws IOException {
            if (this.failOnEncodingExceptions()) {
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
            return false;
        }

        @Override
        public IEncoderPlugin value(String str) throws IOException {
            return this;
        }

        @Override
        public IEncoderPlugin comment(String text) throws IOException {
            this.w.w((Object)"<!-- ").w((Object)text).w((Object)" -->\n");
            return this;
        }

        @Override
        public IEncoderPlugin incrementIndent() throws IOException {
            ++this.indent;
            return this;
        }

        @Override
        public IEncoderPlugin decrementIndent() throws IOException {
            --this.indent;
            return this;
        }

        @Override
        public IEncoderPlugin indent() throws IOException {
            this.w.indent(this.indent);
            return this;
        }

        @Override
        public int getIndent() {
            return this.indent;
        }

        @Override
        public IEncoderPlugin encodeType(Type type) throws IOException {
            BModule module = type.getModule();
            String key = this.modules.get(module.getModuleName());
            if (key == null) {
                key = this.newModuleKey(module);
                this.attr("m", key + "=" + module.getModuleName());
            }
            this.attr("t", key + ":" + type.getTypeName());
            return this;
        }

        @Override
        public void flush() throws IOException {
            this.w.flush();
        }

        @Override
        public void close() throws IOException {
            this.w.close();
            this.bogPasswordObjectEncoder.close();
        }

        @Override
        public boolean isZipped() {
            return this.w.isZipped();
        }

        @Override
        public void setZipped(boolean zipped) throws IOException {
            this.w.setZipped(zipped);
        }

        @Override
        public Version version() {
            return this.version;
        }

        @Override
        public void setVersion(Version version) throws IOException {
            this.version = new Version(version.toString());
        }

        private String newModuleKey(BModule module) {
            String key = module.getPreferredSymbol();
            int i = 0;
            while (this.keys.get(key) != null) {
                key = "" + key.charAt(0) + i;
                ++i;
            }
            this.keys.put(key, key);
            this.modules.put(module.getModuleName(), key);
            return key;
        }

        public void setBogPasswordObjectEncoder(BogPasswordObjectEncoder value) {
            this.bogPasswordObjectEncoder = value;
        }

        public BogPasswordObjectEncoder getBogPasswordObjectEncoder() {
            return this.bogPasswordObjectEncoder;
        }

        public void setPassPhrase(Optional<BPassword> value) {
            this.passPhrase = value;
        }

        public static String marshal(BValue value) throws IOException {
            return BogEncoderPlugin.marshal(value, PasswordEncodingContext.makeNone());
        }

        public static String marshal(BValue value, Context cx) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ValueDocEncoder encoder = new ValueDocEncoder(new BogEncoderPlugin(out, cx), cx);
            encoder.encode(value);
            encoder.close();
            return new String(out.toByteArray());
        }

        public XWriter getWriter() {
            return this.w;
        }
    }

    public static interface IEncoderPlugin
    extends AutoCloseable {
        public IEncoderPlugin encodeDocument(ValueDocEncoder var1, BValue var2) throws IOException;

        public IEncoderPlugin start(String var1) throws IOException;

        public IEncoderPlugin startArray(String var1) throws IOException;

        public IEncoderPlugin endArray() throws IOException;

        public IEncoderPlugin end() throws IOException;

        public IEncoderPlugin end(String var1) throws IOException;

        public IEncoderPlugin endAttr() throws IOException;

        public IEncoderPlugin key(String var1) throws IOException;

        public IEncoderPlugin attr(String var1, boolean var2) throws IOException;

        public IEncoderPlugin attr(String var1, double var2) throws IOException;

        public IEncoderPlugin attr(String var1, String var2) throws IOException;

        public IEncoderPlugin attrSafe(String var1, String var2) throws IOException;

        default public boolean processEncodingException(BObject object, Exception e) throws IOException {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }

        public IEncoderPlugin value(String var1) throws IOException;

        public IEncoderPlugin comment(String var1) throws IOException;

        public IEncoderPlugin incrementIndent() throws IOException;

        public IEncoderPlugin decrementIndent() throws IOException;

        public IEncoderPlugin indent() throws IOException;

        public int getIndent();

        public IEncoderPlugin newLine() throws IOException;

        public IEncoderPlugin encodeType(Type var1) throws IOException;

        public void flush() throws IOException;

        @Override
        public void close() throws IOException;

        public boolean isZipped();

        public void setZipped(boolean var1) throws IOException;

        default public Version version() {
            return Version.NULL;
        }

        default public void setVersion(Version version) throws IOException {
            throw new UnsupportedOperationException();
        }

        default public String encodeSimple(ValueDocEncoder encoder, BSimple simple, Context cx) throws IOException {
            if (simple instanceof BIContextEncodable) {
                return ((BIContextEncodable)((Object)simple)).encodeToString(cx);
            }
            return simple.encodeToString();
        }
    }
}

