/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private RandomAccessFile in;
    private long fp;

    public RandomAccessFileInputStream(RandomAccessFile in) {
        this(in, 0L);
    }

    public RandomAccessFileInputStream(RandomAccessFile in, long initFp) {
        this.in = in;
        this.fp = initFp;
    }

    @Override
    public int available() throws IOException {
        long remainder = this.in.length() - this.fp;
        if (remainder > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remainder;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public void seek(long fp) {
        this.fp = fp;
    }

    @Override
    public int read() throws IOException {
        this.in.seek(this.fp);
        int b = this.in.read();
        ++this.fp;
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.in.seek(this.fp);
        int result = this.in.read(b);
        this.fp = result != -1 ? (this.fp += (long)result) : this.in.length();
        return result;
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        this.in.seek(this.fp);
        int result = this.in.read(b, offset, len);
        this.fp = result != -1 ? (this.fp += (long)result) : this.in.length();
        return result;
    }
}

