/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.firewall;

import com.tridium.firewall.ConcurrentFirewallProcessor;
import com.tridium.firewall.FirewallRulesPage;
import com.tridium.nre.firewall.FirewallProcessor;
import com.tridium.nre.firewall.FirewallRule;
import com.tridium.nre.firewall.InputRule;
import com.tridium.nre.firewall.InvalidRuleException;
import com.tridium.nre.firewall.IpProtocol;
import com.tridium.nre.firewall.NoOpRule;
import com.tridium.nre.firewall.NullFirewallProcessor;
import com.tridium.nre.firewall.RedirectRule;
import com.tridium.nre.firewall.nft.NftablesFirewallProcessor;
import com.tridium.nre.firewall.pf.PfFirewallProcessor;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.firewall.BIpProtocolEnum;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.Spy;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIUnlinkableSlotsContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="publicServerPort", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="65535"), @Facet(name="BFacets.RADIX", value="10")}), @NiagaraProperty(name="localServerPort", type="int", defaultValue="0", flags=4, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="65535"), @Facet(name="BFacets.RADIX", value="10")}), @NiagaraProperty(name="ipProtocol", type="BIpProtocolEnum", defaultValue="BIpProtocolEnum.tcp", flags=1), @NiagaraProperty(name="adapter", type="String", defaultValue="any", flags=5), @NiagaraProperty(name="ruleHintOverride", type="String", defaultValue="", flags=4)})
public class BServerPort
extends BComponent
implements BIUnlinkableSlotsContainer,
IPropertyValidator {
    @Generated
    public static final Property publicServerPort = BServerPort.newProperty(0, 0, BFacets.make(BFacets.make(BFacets.make("min", 1), BFacets.make("max", 65535)), BFacets.make("radix", 10)));
    @Generated
    public static final Property localServerPort = BServerPort.newProperty(4, 0, BFacets.make(BFacets.make(BFacets.make("min", 0), BFacets.make("max", 65535)), BFacets.make("radix", 10)));
    @Generated
    public static final Property ipProtocol = BServerPort.newProperty(1, BIpProtocolEnum.tcp, null);
    @Generated
    public static final Property adapter = BServerPort.newProperty(5, "any", null);
    @Generated
    public static final Property ruleHintOverride = BServerPort.newProperty(4, "", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BServerPort.class);
    private FirewallRule lastRule = null;
    private final Object mutex = new Object();
    protected static Logger firewallLog = Logger.getLogger("firewall");
    private static final Set<Slot> UNLINKABLE_TARGET_SLOTS = Collections.unmodifiableSet(Stream.of(publicServerPort, localServerPort).collect(Collectors.toSet()));
    private boolean bindToLoopback = false;
    private int bindingPort = 0;
    public static final String LOCALHOST_INTERFACE = "127.0.0.1";
    private static final String BSERVER_PORT_FACET_KEY = "BServerPort";
    private static final String BSERVER_PORT_FACET_VALUE = "alreadyProcessed";

    @Generated
    public int getPublicServerPort() {
        return this.getInt(publicServerPort);
    }

    @Generated
    public void setPublicServerPort(int v) {
        this.setInt(publicServerPort, v, null);
    }

    @Generated
    public int getLocalServerPort() {
        return this.getInt(localServerPort);
    }

    @Generated
    public void setLocalServerPort(int v) {
        this.setInt(localServerPort, v, null);
    }

    @Generated
    public BIpProtocolEnum getIpProtocol() {
        return (BIpProtocolEnum)this.get(ipProtocol);
    }

    @Generated
    public void setIpProtocol(BIpProtocolEnum v) {
        this.set(ipProtocol, (BValue)v, null);
    }

    @Generated
    public String getAdapter() {
        return this.getString(adapter);
    }

    @Generated
    public void setAdapter(String v) {
        this.setString(adapter, v, null);
    }

    @Generated
    public String getRuleHintOverride() {
        return this.getString(ruleHintOverride);
    }

    @Generated
    public void setRuleHintOverride(String v) {
        this.setString(ruleHintOverride, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BServerPort() {
    }

    public BServerPort(int publicServerPort) {
        this.setPublicServerPort(publicServerPort);
    }

    public BServerPort(int publicServerPort, IpProtocol protocol) {
        this(publicServerPort);
        this.setIpProtocol(BIpProtocolEnum.make(protocol.ordinal()));
    }

    public BServerPort(int publicServerPort, int localServerPort, IpProtocol protocol) {
        this(publicServerPort);
        this.setLocalServerPort(localServerPort);
        this.setIpProtocol(BIpProtocolEnum.make(protocol.ordinal()));
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.updateFirewallRules();
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.removeFirewallRules();
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning()) {
            BObject processedStateFacet = null;
            if (context != null) {
                processedStateFacet = context.getFacet(BSERVER_PORT_FACET_KEY);
            }
            if (!(processedStateFacet != null && processedStateFacet instanceof BString && ((BString)processedStateFacet).getString().equals(BSERVER_PORT_FACET_VALUE) || property != publicServerPort && property != localServerPort && property != adapter && property != ipProtocol && property != ruleHintOverride)) {
                this.updateFirewallRules();
                BasicContext newContext = new BasicContext(context, BFacets.make(BSERVER_PORT_FACET_KEY, BSERVER_PORT_FACET_VALUE));
                Property prop = this.getPropertyInParent();
                this.getParent().getParentComponent().changed(prop, newContext);
            }
        }
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    @Override
    public void validateSet(Validatable validatable, Context context) {
        BString proposedValue;
        if (Arrays.asList(validatable.getModifiedProperties()).contains(ruleHintOverride) && !BServerPort.isAlphanumeric((proposedValue = (BString)validatable.getProposedValue(ruleHintOverride)).getString())) {
            throw new LocalizableRuntimeException("baja", "firewall.ruleHint.invalidCharacters");
        }
    }

    @Override
    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (property.equals(ruleHintOverride) && !BServerPort.isAlphanumeric(((BString)newValue).getString())) {
            throw new LocalizableRuntimeException("baja", "firewall.ruleHint.invalidCharacters");
        }
    }

    private static boolean isAlphanumeric(String string) {
        for (char character : string.toCharArray()) {
            if (Character.isLetterOrDigit(character)) continue;
            return false;
        }
        return true;
    }

    public boolean getBindToLoopback() {
        return this.bindToLoopback;
    }

    public int getBindingPort() {
        this.updateFirewallRules();
        return this.bindingPort;
    }

    protected String getRuleHint() {
        if (!this.getRuleHintOverride().isEmpty()) {
            return this.getRuleHintOverride();
        }
        String prefix = null;
        if (this.getParent() != null) {
            prefix = this.getParent().getName();
        }
        return prefix == null ? this.getName() : prefix + "." + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFirewallRules() {
        RedirectRule newRule;
        if (BServerPort.isUseQnxPfctl()) {
            newRule = new RedirectRule(this.getPublicServerPort(), this.getLocalServerPort(), BIpProtocolEnum.make(this.getIpProtocol()), this.getAdapter());
        } else if (BServerPort.isUseFirewall()) {
            newRule = new InputRule(this.getPublicServerPort(), BIpProtocolEnum.make(this.getIpProtocol()), this.getAdapter(), this.getBindToLoopback(), this.getRuleHint());
        } else {
            firewallLog.fine("Firewall not defined");
            newRule = new NoOpRule(this.getPublicServerPort(), BIpProtocolEnum.make(this.getIpProtocol()), this.getAdapter(), this.getBindToLoopback(), this.getRuleHint());
        }
        Object object = this.mutex;
        synchronized (object) {
            try {
                newRule = BServerPort.fw().validateRule((FirewallRule)newRule);
                if (newRule.equivalentTo(this.lastRule)) {
                    return;
                }
            }
            catch (InvalidRuleException e) {
                firewallLog.severe("invalid rule provided, rule ignored: " + e.getLocalizedMessage() + ", " + this.getSlotPath());
                return;
            }
            if (this.lastRule != null) {
                BServerPort.fw().removeRule(this.lastRule);
            }
            try {
                this.lastRule = BServerPort.fw().addRule((FirewallRule)newRule);
                this.bindingPort = this.lastRule.getLocalServerPort();
                this.bindToLoopback = this.lastRule.getBindToLoopback();
            }
            catch (InvalidRuleException e) {
                this.lastRule = null;
            }
            if (BServerPort.isUseQnxPfctl()) {
                if (firewallLog.isLoggable(Level.FINE)) {
                    firewallLog.fine("Adding pf rule: port:" + this.getPublicServerPort() + " prot:" + this.getIpProtocol().toString() + " adapter:" + this.getAdapter() + " bindToLoopback:" + this.getBindToLoopback());
                }
                BServerPort.fw().processRules();
            } else if (BServerPort.isUseFirewall()) {
                if (firewallLog.isLoggable(Level.FINE)) {
                    firewallLog.fine(newRule.toString());
                }
                BServerPort.fw().processRule((FirewallRule)newRule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFirewallRules() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.lastRule != null) {
                BServerPort.fw().removeRule(this.lastRule);
                this.lastRule = null;
                BServerPort.fw().processRules();
            }
        }
    }

    @Override
    public String toString(Context context) {
        return String.format("ServerPort:%d %s %s %b", this.getPublicServerPort(), this.getIpProtocol().getTag(), this.getAdapter(), this.getBindToLoopback());
    }

    public static FirewallRule[] getRuleList() {
        return BServerPort.fw().getRulesList();
    }

    public static String getFirewallName() {
        return BServerPort.fw().getFirewallName();
    }

    public static String getFirewallDescription() {
        return BServerPort.fw().getDescription();
    }

    private static FirewallProcessor fw() {
        return FirewallHolder.fw;
    }

    private static boolean isUseQnxPfctl() {
        return FirewallHolder.useQnxPfctl;
    }

    private static boolean isUseFirewall() {
        return FirewallHolder.useFirewall;
    }

    @Override
    public Set<Slot> getUnlinkableTargetSlots(Context context) {
        return UNLINKABLE_TARGET_SLOTS;
    }

    private static final class FirewallHolder {
        private static final FirewallProcessor fw;
        private static final boolean useQnxPfctl;
        private static final boolean useFirewall;

        private FirewallHolder() {
        }

        static {
            useQnxPfctl = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.qnx.pfctl.enabled"));
            useFirewall = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.firewall.enabled"));
            if (useQnxPfctl) {
                firewallLog.finer("Setting firewall implementation to PfFirewallProcessor");
                fw = new ConcurrentFirewallProcessor((FirewallProcessor)new PfFirewallProcessor());
            } else if (useFirewall) {
                String firewallFrontEnd = AccessController.doPrivileged(() -> System.getProperty("niagara.firewall.frontend"));
                if ("nft".equals(firewallFrontEnd)) {
                    firewallLog.finer("Setting firewall implementation to NftablesFirewallProcessor");
                    fw = new NftablesFirewallProcessor();
                } else {
                    firewallLog.finer("Setting firewall implementation to NullFirewallProcessor");
                    fw = new ConcurrentFirewallProcessor((FirewallProcessor)new NullFirewallProcessor());
                }
            } else {
                fw = new ConcurrentFirewallProcessor((FirewallProcessor)new NullFirewallProcessor());
                firewallLog.finer("Setting firewall implementation to NullFirewallProcessor");
            }
            Spy.ROOT.add("Firewall Rules", new FirewallRulesPage());
        }
    }
}

