/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
public abstract class BFileSpace
extends BSpace
implements BIFileSpace,
BIDirectory,
BICategorizable,
BIProtected {
    @Generated
    public static final Type TYPE = Sys.loadType(BFileSpace.class);
    private static final BIcon icon = BIcon.std("drive.png");
    static final BIFile[] NO_FILES = new BIFile[0];

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFileSpace(String name, LexiconText lexText) {
        super(name, lexText);
    }

    public BFileSpace(String name) {
        super(name);
    }

    public abstract BDirectory makeDir(FilePath var1, Context var2) throws IOException;

    @Override
    public final BDirectory makeDir(FilePath path) throws IOException {
        return this.makeDir(path, null);
    }

    public abstract BIFile makeFile(FilePath var1, Context var2) throws IOException;

    @Override
    public final BIFile makeFile(FilePath path) throws IOException {
        return this.makeFile(path, null);
    }

    public abstract void move(FilePath var1, FilePath var2, Context var3) throws IOException;

    @Override
    public final void move(FilePath from, FilePath to) throws IOException {
        this.move(from, to, null);
    }

    public abstract void delete(FilePath var1, Context var2) throws IOException;

    @Override
    public final void delete(FilePath path) throws IOException {
        this.delete(path, null);
    }

    @Override
    public BOrd getAbsoluteOrd(FilePath filePath) {
        return this.appendFilePathToOrd(this.getAbsoluteOrd(), filePath);
    }

    @Override
    public BOrd getOrdInHost(FilePath filePath) {
        return this.appendFilePathToOrd(this.getOrdInHost(), filePath);
    }

    @Override
    public BOrd getOrdInSession(FilePath filePath) {
        return this.appendFilePathToOrd(this.getOrdInSession(), filePath);
    }

    protected BOrd appendFilePathToOrd(BOrd baseOrd, FilePath filePath) {
        if (baseOrd == null) {
            return null;
        }
        if (baseOrd.toString().length() == 0) {
            return BOrd.make(filePath);
        }
        return BOrd.make(baseOrd.toString() + filePath.getBody());
    }

    @Override
    public BIFile findFile(FilePath path) {
        BIFileStore store = this.findStore(path);
        if (store != null) {
            return this.makeFile(store);
        }
        return null;
    }

    public abstract BIFileStore findStore(FilePath var1);

    @Override
    public BIFile resolveFile(FilePath path) {
        BIFile file = this.findFile(path);
        if (file == null) {
            throw new UnresolvedException("" + path);
        }
        return file;
    }

    public abstract BIFile getChild(BIFile var1, String var2);

    public abstract BIFile[] getChildren(BIFile var1);

    @Override
    public BIFile makeFile(BIFileStore store) {
        if (store.isDirectory()) {
            return new BDirectory(store);
        }
        String ext = store.getExtension();
        if (ext != null && ext.length() > 0) {
            TypeInfo type = Sys.getRegistry().getFileTypeForExtension(ext);
            try {
                BIFile file = (BIFile)((Object)type.getInstance());
                file.setStore(store);
                return file;
            }
            catch (Throwable e) {
                BajaFileUtil.log.log(Level.SEVERE, "Cannot create file " + type + " for ext " + ext, e);
            }
        }
        return new BDataFile(store);
    }

    @Override
    public BPermissions getPermissionsFor(FilePath path, Context cx) {
        BPermissions defaultPermissions = BPermissions.all;
        if (cx == null || cx.getUser() == null) {
            return defaultPermissions;
        }
        try {
            BLocalFileStore store = new BLocalFileStore(this, path, new File("dummy"));
            BDataFile file = new BDataFile(store);
            return cx.getUser().getPermissionsFor(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultPermissions;
        }
    }

    @Override
    public void checkReadPermission(FilePath path, Context cx) {
        if (!this.getPermissionsFor(path, cx).hasOperatorRead()) {
            throw new PermissionException("Missing operator read");
        }
    }

    @Override
    public void checkWritePermission(FilePath path, Context cx) {
        if (!this.getPermissionsFor(path, cx).hasOperatorWrite()) {
            throw new PermissionException("Missing operator write");
        }
    }

    @Override
    public BCategoryMask getCategoryMask() {
        return BCategoryService.getService().getCategoryMask(this.getNavOrd());
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        return BCategoryService.getService().getAppliedCategoryMask(this.getNavOrd());
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null) {
            return cx.getUser().getPermissionsFor(this);
        }
        return BPermissions.all;
    }

    @Override
    public boolean canRead(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorRead();
    }

    @Override
    public boolean canWrite(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorWrite();
    }

    @Override
    public boolean canInvoke(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorInvoke();
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("workbench:DirectoryList");
        agents.toTop("hx:HxDirectoryView");
        agents.toBottom("web:FileUploadView");
        return agents;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

