/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.collection;

import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.BInMemoryTable;
import javax.baja.collection.Column;
import javax.baja.sys.BIObject;
import javax.baja.sys.IterableCursor;

public final class Tables {
    private Tables() {
    }

    public static boolean hasRows(BITable<?> table) {
        if (table instanceof BIRandomAccessTable) {
            return ((BIRandomAccessTable)table).size() > 0;
        }
        try (IterableCursor c = table.cursor();){
            boolean bl = c.next();
            return bl;
        }
    }

    public static <T extends BIObject> BIRandomAccessTable<T> slurp(BITable<T> table) {
        if (table instanceof BIRandomAccessTable) {
            return (BIRandomAccessTable)table;
        }
        return new BInMemoryTable<T>(table);
    }

    public static BIObject get(BITable<?> table, int row, Column col) {
        if (table instanceof BIRandomAccessTable) {
            return table.as(BIRandomAccessTable.class).get(row).cell(col);
        }
        try (IterableCursor cursor = table.cursor();){
            do {
                if (cursor.next()) continue;
                throw new IndexOutOfBoundsException();
            } while (--row >= 0);
            BIObject bIObject = cursor.cell(col);
            return bIObject;
        }
    }
}

