/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BInMemoryTable<T extends BIObject>
extends BObject
implements BIRandomAccessTable<T> {
    @Generated
    public static final Type TYPE = Sys.loadType(BInMemoryTable.class);
    private final BITable<T> table;
    private final List<Row<T>> rows;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInMemoryTable(BITable<T> table) {
        this.table = table;
        this.rows = new ArrayList<Row<T>>(16);
        try (IterableCursor cursor = table.cursor();){
            while (cursor.next()) {
                this.rows.add(cursor.row().safeCopy());
            }
        }
    }

    private BInMemoryTable(BITable<T> table, List<Row<T>> sorted) {
        this.table = table;
        this.rows = sorted;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public Row<T> get(int row) {
        return this.rows.get(row);
    }

    @Override
    public TableCursor<T> cursor() {
        return this.table.cursor();
    }

    @Override
    public ColumnList getColumns() {
        return this.table.getColumns();
    }

    @Override
    public BFacets getTableFacets() {
        return this.table.getTableFacets();
    }

    @Override
    public BIRandomAccessTable<T> sort(final Column col, final boolean ascending) {
        ArrayList<Row<T>> sorted = new ArrayList<Row<T>>(this.rows);
        Collections.sort(sorted, new Comparator<Row<T>>(){

            @Override
            public int compare(Row<T> r1, Row<T> r2) {
                BIObject o1 = r1.cell(col);
                BIObject o2 = r2.cell(col);
                int mult = ascending ? 1 : -1;
                try {
                    if (o1 instanceof Comparable) {
                        return mult * ((Comparable)((Object)o1)).compareTo(o2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return mult * o1.toString(r1.getCellFacets(col)).compareTo(o2.toString(r2.getCellFacets(col)));
            }
        });
        return new BInMemoryTable<T>(this.table, sorted);
    }
}

