/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.naming.SlotPath;
import javax.baja.security.BAbstractAes256PasswordEncoder;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BAes256Pbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BAliasedAes256PasswordEncoder;
import javax.baja.security.BIDeferOwnership;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BReversiblePasswordEncoder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;

public class PasswordUtil {
    public static final BPassword SUBSTITUTE_PASSWORD = BPassword.make("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "plain.1");
    public static final String SKIP_ENCODING_SENSITIVE_KEY = "skipEncodingSensitive";
    private static final ThreadLocal<Boolean> allowSubstitutePasswordPersistence = new ThreadLocal();
    private static volatile boolean checkForSubstitutePasswords;
    static final Logger log;

    public static List<SlotPath> forceClearReversiblePasswords(BComponent root) {
        ReplaceWithDefaultPasswordPropertyUpdate function = new ReplaceWithDefaultPasswordPropertyUpdate();
        PasswordUtil.updatePasswords(root, function);
        Optional<RuntimeException> exception = function.exceptions().findFirst();
        if (exception.isPresent()) {
            throw exception.get();
        }
        return function.updatedSlots();
    }

    public static List<SlotPath> removeEncryptionFromUserPasswords(BComponent root) {
        ReplaceWithUnencryptedPBKDF2PasswordPropertyUpdate function = new ReplaceWithUnencryptedPBKDF2PasswordPropertyUpdate();
        PasswordUtil.updatePasswords(root, function);
        Optional<RuntimeException> exception = function.exceptions().findFirst();
        if (exception.isPresent()) {
            throw exception.get();
        }
        return function.updatedSlots();
    }

    public static List<SlotPath> addEncryptionToUserPasswords(BComponent root) {
        EncryptUserPBKDF2PasswordPropertyUpdate function = new EncryptUserPBKDF2PasswordPropertyUpdate();
        PasswordUtil.updatePasswords(root, function);
        Optional<RuntimeException> exception = function.exceptions().findFirst();
        if (exception.isPresent()) {
            throw exception.get();
        }
        return function.updatedSlots();
    }

    public static void updatePasswords(BComponent root, PasswordPropertyUpdate updater) {
        PasswordUtil.updatePasswords(root, root.getSlotPath(), updater);
    }

    public static void updatePasswords(BComplex c, SlotPath cPath, PasswordPropertyUpdate updater) {
        for (Property p : c.getProperties()) {
            if (p.getType().is(BComplex.TYPE)) {
                PasswordUtil.updatePasswords((BComplex)c.get(p), cPath.merge(new SlotPath(p.getName())), updater);
                continue;
            }
            if (p.getType().is(BPassword.TYPE)) {
                c.set(p, (BValue)updater.apply((BPassword)c.get(p), cPath.merge(new SlotPath(p.getName())), c), updater.context());
                continue;
            }
            if (!BComplex.TYPE.is(p.getType()) && !BPassword.TYPE.is(p.getType())) continue;
            BValue propertyValue = c.get(p);
            if (propertyValue instanceof BComplex) {
                PasswordUtil.updatePasswords((BComplex)propertyValue, cPath.merge(new SlotPath(p.getName())), updater);
                continue;
            }
            if (!(propertyValue instanceof BPassword)) continue;
            c.set(p, (BValue)updater.apply((BPassword)propertyValue, cPath.merge(new SlotPath(p.getName())), c), updater.context());
        }
    }

    public static void setAllowSubstitutePasswordValuesOnThread(boolean allow) {
        if (Sys.isStation()) {
            checkForSubstitutePasswords = true;
            if (allow) {
                allowSubstitutePasswordPersistence.set(Boolean.TRUE);
            } else {
                allowSubstitutePasswordPersistence.remove();
            }
        }
    }

    public static boolean isSubstitutePasswordValueAllowedOnThread() {
        return !Sys.isStation() || checkForSubstitutePasswords && allowSubstitutePasswordPersistence.get() == Boolean.TRUE;
    }

    public static BPassword toAcceptableForm(BPassword password, BPassword defaultPassword) {
        if (!PasswordUtil.isSubstitutePasswordValueAllowedOnThread() && SUBSTITUTE_PASSWORD.validate(password)) {
            return defaultPassword;
        }
        return password;
    }

    public static BPassword assignPasswordOwner(BPassword password, BComplex owner, Property property) {
        while (owner instanceof BIDeferOwnership) {
            property = owner.getPropertyInParent();
            owner = owner.getParent();
        }
        BAbstractPasswordEncoder encoder = password.getPasswordEncoder();
        if (owner != null && encoder instanceof BAbstractAes256PasswordEncoder && !(encoder instanceof BAes256Pbkdf2HmacSha256PasswordEncoder)) {
            String newAlternateOwner;
            String oldAlias = ((BAbstractAes256PasswordEncoder)encoder).getKeyAlias();
            String oldAlternateOwner = encoder instanceof BAliasedAes256PasswordEncoder ? ((BAliasedAes256PasswordEncoder)encoder).getAlternateOwner() : null;
            String newAlias = owner.getType().getModule().getModuleName();
            String newDeclaringModule = property == null ? null : property.getDeclaringType().getModule().getModuleName();
            String string = newAlternateOwner = newDeclaringModule == newAlias ? null : newDeclaringModule;
            if (!oldAlias.equals(newAlias) || !Objects.equals(oldAlternateOwner, newAlternateOwner)) {
                if (!oldAlias.equals(newAlias) && !oldAlias.equals("javax.baja.security.BAes256PasswordEncoder.key")) {
                    throw new SecurityException("Cannot set password that is owned by another module.");
                }
                try {
                    BAliasedAes256PasswordEncoder newEncoder = new BAliasedAes256PasswordEncoder(newAlias);
                    newEncoder.encode(encoder.getSecretChars());
                    newEncoder.setAlternateOwner(newAlternateOwner);
                    password = BPassword.make(newEncoder);
                }
                catch (Exception e) {
                    log.warning("Failed to own password: " + e.getMessage());
                    return password;
                }
            }
        }
        return password;
    }

    public static void assignChildPasswordOwner(BIDeferOwnership defer, BComplex owner) {
        Property alternateOwnerProperty = ((BComplex)((Object)defer)).getPropertyInParent();
        while (owner instanceof BIDeferOwnership) {
            alternateOwnerProperty = owner.getPropertyInParent();
            owner = owner.getParent();
        }
        if (owner != null && defer instanceof BComplex) {
            for (Property property : ((BComplex)((Object)defer)).getProperties()) {
                BValue value = ((BComplex)((Object)defer)).get(property);
                if (value instanceof BPassword) {
                    ((BComplex)((Object)defer)).set(property, (BValue)PasswordUtil.assignPasswordOwner((BPassword)value, owner, alternateOwnerProperty));
                    continue;
                }
                if (!(value instanceof BIDeferOwnership)) continue;
                PasswordUtil.assignChildPasswordOwner((BIDeferOwnership)((Object)value), owner);
            }
        }
    }

    static {
        log = Logger.getLogger("baja");
    }

    private static class EncryptUserPBKDF2PasswordPropertyUpdate
    extends PasswordPropertyUpdate {
        private EncryptUserPBKDF2PasswordPropertyUpdate() {
        }

        @Override
        public BPassword apply(BPassword password, SlotPath slotPath, BComplex parent) {
            try {
                if (password.getPasswordEncoder() instanceof BPbkdf2HmacSha256PasswordEncoder && CompUtil.closestAncestor(parent, BUser.class).isPresent()) {
                    BAes256Pbkdf2HmacSha256PasswordEncoder aesPbkdf2Encoder = new BAes256Pbkdf2HmacSha256PasswordEncoder();
                    aesPbkdf2Encoder.encode(password.encodeToString());
                    this.slotUpdated(slotPath);
                    return BPassword.make(aesPbkdf2Encoder);
                }
                return password;
            }
            catch (RuntimeException e) {
                this.exceptions.add(e);
                return password;
            }
            catch (Exception e) {
                this.exceptions.add(new RuntimeException("Could not encrypt hashed password", e));
                return password;
            }
        }

        @Override
        public BPassword apply(BPassword password) {
            throw new UnsupportedOperationException("apply() must be called with BComplex parent argument");
        }
    }

    private static class ReplaceWithUnencryptedPBKDF2PasswordPropertyUpdate
    extends PasswordPropertyUpdate {
        private ReplaceWithUnencryptedPBKDF2PasswordPropertyUpdate() {
        }

        @Override
        public BPassword apply(BPassword password, SlotPath slotPath, BComplex parent) {
            try {
                if (password.getPasswordEncoder() instanceof BAes256Pbkdf2HmacSha256PasswordEncoder) {
                    BPassword pbkdf2Password = BPassword.make(BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE);
                    pbkdf2Password = (BPassword)pbkdf2Password.decodeFromString(password.getPasswordEncoder().getValue());
                    this.slotUpdated(slotPath);
                    return pbkdf2Password;
                }
                return password;
            }
            catch (RuntimeException e) {
                this.exceptions.add(e);
                return password;
            }
            catch (Exception e) {
                this.exceptions.add(new RuntimeException("Could not decrypt hashed password", e));
                return password;
            }
        }

        @Override
        public BPassword apply(BPassword password) {
            try {
                if (password.getPasswordEncoder() instanceof BAes256Pbkdf2HmacSha256PasswordEncoder) {
                    BPassword pbkdf2Password = BPassword.make(BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE);
                    return (BPassword)pbkdf2Password.decodeFromString(password.getPasswordEncoder().getValue());
                }
                return password;
            }
            catch (RuntimeException e) {
                this.exceptions.add(e);
                return password;
            }
            catch (Exception e) {
                this.exceptions.add(new RuntimeException("Could not decrypt hashed password", e));
                return password;
            }
        }

        @Override
        public Context context() {
            return BPasswordAuthenticator.pwConverted;
        }
    }

    public static class ReplaceWithDefaultPasswordPropertyUpdate
    extends PasswordPropertyUpdate {
        @Override
        public BPassword apply(BPassword password, SlotPath slotPath, BComplex parent) {
            try {
                if (password.getPasswordEncoder() instanceof BReversiblePasswordEncoder) {
                    this.slotUpdated(slotPath);
                    return BPassword.DEFAULT;
                }
                return password;
            }
            catch (RuntimeException e) {
                this.exceptions.add(e);
                return this.exceptionalValue();
            }
        }

        @Override
        public BPassword apply(BPassword password) {
            if (password.getPasswordEncoder() instanceof BReversiblePasswordEncoder) {
                return BPassword.DEFAULT;
            }
            return password;
        }
    }

    public static abstract class PasswordPropertyUpdate
    implements UnaryOperator<BPassword> {
        List<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        List<SlotPath> updatedSlots = new ArrayList<SlotPath>();

        protected BPassword apply(BPassword password, SlotPath slotPath, BComplex parent) {
            try {
                return (BPassword)this.apply(password);
            }
            catch (RuntimeException e) {
                this.exceptions.add(e);
                return this.exceptionalValue();
            }
        }

        protected BPassword exceptionalValue() {
            return BPassword.DEFAULT;
        }

        public Stream<RuntimeException> exceptions() {
            return this.exceptions.stream();
        }

        public List<SlotPath> updatedSlots() {
            return Collections.unmodifiableList(this.updatedSlots);
        }

        protected void slotUpdated(SlotPath path) {
            this.updatedSlots.add(path);
        }

        protected Context context() {
            return null;
        }
    }
}

