/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import javax.baja.nre.util.TextUtil;

public abstract class EscUtil {
    public static final EscUtil slot;
    public static final EscUtil ord;
    protected static final int CM_LENGTH = 128;
    protected static final int CM_HEX = 1;
    protected static final int CM_START = 2;
    protected static final int CM_PART = 4;
    private static final int CM_ORD = 8;
    protected static final byte[] charMap;

    public boolean isValid(String s) {
        try {
            int len = s.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char c1;
                char c = s.charAt(i);
                if (i != 0 ? this.isPart(c) : this.isStart(c)) continue;
                if (c != this.getEscChar()) {
                    return false;
                }
                byte[] cMap = this.getCharMap();
                if (!((c1 = s.charAt(++i)) != 'u' ? (cMap[c1] & 1) == 0 || (cMap[s.charAt(++i)] & 1) == 0 : (cMap[s.charAt(++i)] & 1) == 0 || (cMap[s.charAt(++i)] & 1) == 0 || (cMap[s.charAt(++i)] & 1) == 0 || (cMap[s.charAt(++i)] & 1) == 0)) continue;
                return false;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    public String escape(String s) {
        int len = s.length();
        if (len == 0) {
            return s;
        }
        char[] buf = null;
        int pos = 0;
        int maxLen = len * 6;
        char c = s.charAt(0);
        if (!this.isStart(c)) {
            buf = new char[maxLen];
            pos = EscUtil.escape(this.getEscChar(), c, buf, pos);
        }
        for (int i = 1; i < len; ++i) {
            c = s.charAt(i);
            if (this.isPart(c)) {
                if (buf == null) continue;
                buf[pos++] = c;
                continue;
            }
            if (buf == null) {
                buf = new char[maxLen];
                s.getChars(0, i, buf, 0);
                pos = i;
            }
            pos = EscUtil.escape(this.getEscChar(), c, buf, pos);
        }
        if (buf == null) {
            return s;
        }
        return new String(buf, 0, pos);
    }

    public String unescape(String s) {
        char[] buf = null;
        int pos = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c1;
            char c = s.charAt(i);
            if (c != this.getEscChar()) {
                if (buf == null) continue;
                buf[pos++] = c;
                continue;
            }
            if (buf == null) {
                buf = new char[len];
                s.getChars(0, i, buf, 0);
                pos = i;
            }
            if ((c1 = s.charAt(++i)) != 'u') {
                buf[pos++] = (char)(TextUtil.hexCharToInt((char)c1) << 4 | TextUtil.hexCharToInt((char)s.charAt(++i)));
                continue;
            }
            buf[pos++] = (char)(TextUtil.hexCharToInt((char)s.charAt(++i)) << 12 | TextUtil.hexCharToInt((char)s.charAt(++i)) << 8 | TextUtil.hexCharToInt((char)s.charAt(++i)) << 4 | TextUtil.hexCharToInt((char)s.charAt(++i)));
        }
        if (buf == null) {
            return s;
        }
        return new String(buf, 0, pos);
    }

    public abstract boolean isStart(int var1);

    public abstract boolean isPart(int var1);

    protected char getEscChar() {
        return '$';
    }

    protected byte[] getCharMap() {
        return charMap;
    }

    public static int escape(char c, char[] buf, int pos) {
        return EscUtil.escape('$', c, buf, pos);
    }

    private static int escape(char escChar, char c, char[] buf, int pos) {
        String s = Integer.toHexString(c);
        buf[pos++] = escChar;
        if (c < '\u0010') {
            buf[pos++] = 48;
            buf[pos++] = s.charAt(0);
        } else if (c < '\u0100') {
            buf[pos++] = s.charAt(0);
            buf[pos++] = s.charAt(1);
        } else if (c < '\u1000') {
            buf[pos++] = 117;
            buf[pos++] = 48;
            buf[pos++] = s.charAt(0);
            buf[pos++] = s.charAt(1);
            buf[pos++] = s.charAt(2);
        } else {
            buf[pos++] = 117;
            buf[pos++] = s.charAt(0);
            buf[pos++] = s.charAt(1);
            buf[pos++] = s.charAt(2);
            buf[pos++] = s.charAt(3);
        }
        return pos;
    }

    public static void main(String[] args) {
        String s = args[0];
        System.out.println("raw:  " + s);
        System.out.println("slot: " + slot.escape(s) + " [" + slot.isValid(s) + "]");
        System.out.println("ord:  " + ord.escape(s) + " [" + ord.isValid(s) + "]");
    }

    static {
        int i;
        slot = new SlotEsc();
        ord = new OrdEsc();
        charMap = new byte[128];
        for (i = 97; i <= 122; ++i) {
            EscUtil.charMap[i] = 6;
        }
        for (i = 65; i <= 90; ++i) {
            EscUtil.charMap[i] = 6;
        }
        for (i = 48; i <= 57; ++i) {
            EscUtil.charMap[i] = 5;
        }
        i = 97;
        while (i <= 102) {
            int n = i++;
            charMap[n] = (byte)(charMap[n] | 1);
        }
        i = 65;
        while (i <= 70) {
            int n = i++;
            charMap[n] = (byte)(charMap[n] | 1);
        }
        EscUtil.charMap[95] = 4;
        for (i = 32; i < 128; ++i) {
            if (i == 36 || i == 124) continue;
            int n = i;
            charMap[n] = (byte)(charMap[n] | 8);
        }
    }

    static class OrdEsc
    extends EscUtil {
        OrdEsc() {
        }

        @Override
        public boolean isStart(int c) {
            return c < 128 && (charMap[c] & 8) != 0;
        }

        @Override
        public boolean isPart(int c) {
            return c < 128 && (charMap[c] & 8) != 0;
        }
    }

    static class SlotEsc
    extends EscUtil {
        SlotEsc() {
        }

        @Override
        public boolean isStart(int c) {
            return c < 128 && (charMap[c] & 2) != 0;
        }

        @Override
        public boolean isPart(int c) {
            return c < 128 && (charMap[c] & 4) != 0;
        }
    }
}

