/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.util.BIStationTheme;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;

public class CustomThemeModuleManager {
    private static BEnumRange themeModules = CustomThemeModuleManager.initializeThemeModules();
    private static final String[] DEFAULT_THEMES = new String[]{"Zebra", "Lucid"};

    private static BEnumRange initializeThemeModules() {
        String[] themeNames = Sys.getRegistry().getDefs("themeName");
        ArrayList<String> themes = new ArrayList<String>();
        for (int i = 0; i < themeNames.length; ++i) {
            String themeName = themeNames[i];
            BDirectory dir = CustomThemeModuleManager.getNSSDirectory(themeName);
            if (dir == null) continue;
            BIFile[] files = dir.listFiles();
            for (int j = 0; j < files.length; ++j) {
                String nssPath = CustomThemeModuleManager.getDisplayNSSPath(themeName, files[j]);
                if (nssPath == null) continue;
                themes.add(nssPath);
            }
        }
        Collections.sort(themes);
        return BEnumRange.make(themes.toArray(new String[0]));
    }

    private static BDirectory getNSSDirectory(String themeModuleName) {
        BOrd ord = BOrd.make("module://" + themeModuleName + "/nss");
        try {
            BObject obj = ord.get();
            if (obj instanceof BDirectory && !obj.isNull()) {
                return (BDirectory)obj;
            }
            return null;
        }
        catch (ModuleNotFoundException mnfe) {
            mnfe.printStackTrace();
            return null;
        }
    }

    private static String getDisplayNSSPath(String themeModuleName, BIFile file) {
        String nssPath = file.getFileName();
        if (!nssPath.endsWith(".nss")) {
            return null;
        }
        if ((nssPath = (nssPath = nssPath.substring(0, nssPath.indexOf(".nss"))).equals("theme") ? themeModuleName : themeModuleName + "/" + nssPath).startsWith("theme")) {
            nssPath = nssPath.substring(5);
        }
        nssPath = SlotPath.escape(nssPath);
        return nssPath;
    }

    public static BDynamicEnum getModuleEnumForTag(String tag) {
        try {
            BEnum e = themeModules.get(tag);
            return BDynamicEnum.make(e);
        }
        catch (InvalidEnumException e) {
            return CustomThemeModuleManager.getDefaultThemeEnum();
        }
    }

    public static BDynamicEnum getDefaultThemeEnum() {
        int[] ordinals;
        BEnum defaultThemeEnum = null;
        for (int i = 0; i < DEFAULT_THEMES.length; ++i) {
            String themeName = DEFAULT_THEMES[i];
            try {
                defaultThemeEnum = themeModules.get(SlotPath.escape(themeName));
                return BDynamicEnum.make(defaultThemeEnum);
            }
            catch (InvalidEnumException invalidEnumException) {
                continue;
            }
        }
        if (defaultThemeEnum == null && (ordinals = themeModules.getOrdinals()).length > 0) {
            return BDynamicEnum.make(themeModules.get(ordinals[0]));
        }
        return BDynamicEnum.DEFAULT;
    }

    public static void setStationTheme(BDynamicEnum stationThemeValue) {
        for (TypeInfo typeInfo : Sys.getRegistry().getConcreteTypes(BIStationTheme.TYPE.getTypeInfo())) {
            BIStationTheme stationTheme = (BIStationTheme)((Object)typeInfo.getInstance());
            stationTheme.setStationTheme(stationThemeValue);
        }
    }
}

