/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.nre.security.UserLoginEntry;
import com.tridium.nre.security.UserLoginHistory;
import java.net.Socket;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BSessionInfo
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSessionInfo.class);
    private static final Lexicon lex = Lexicon.make("baja");
    protected BAbsTime connected = BAbsTime.NULL;
    protected String name = null;
    protected String username = null;
    protected String hostname = null;
    protected boolean isFips = false;
    protected UserLoginHistory loginHistory = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BSessionInfo make(String name, BAbsTime connected, Socket socket, String username, String hostName, boolean isFips) {
        return new BSessionInfo(name, connected, username, hostName, isFips);
    }

    public static BSessionInfo make(String name, BAbsTime connected, Socket socket, UserLoginHistory loginHistory, String hostName, boolean isFips) {
        return new BSessionInfo(name, connected, loginHistory, hostName, isFips);
    }

    public BSessionInfo() {
    }

    protected BSessionInfo(String name, BAbsTime connected, String username, String hostname, boolean isFips) {
        this.name = name;
        this.connected = connected;
        this.username = username;
        this.hostname = hostname;
        this.isFips = isFips;
    }

    protected BSessionInfo(String name, BAbsTime connected, UserLoginHistory loginHistory, String hostname, boolean isFips) {
        this.name = name;
        this.connected = connected;
        if (loginHistory != null) {
            this.username = loginHistory.getUserName();
        }
        this.hostname = hostname;
        this.isFips = isFips;
        this.loginHistory = loginHistory;
    }

    public String getHostname() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getConnectedAsMessage(String userName) {
        return lex.getText("session.info.connectedAs", userName);
    }

    public BIcon getConnectedAsIcon() {
        return BIcon.make(lex.getText("session.info.connectedAs.icon"));
    }

    public BIcon getLastConnectedIcon() {
        return BIcon.make(lex.getText("session.info.lastConnected.icon"));
    }

    public String getLastConnectedMessage() {
        return lex.getText("session.info.lastConnected", this.connected.toString());
    }

    public String getPreviousLoginMessage() {
        if (this.loginHistory != null && this.loginHistory.getPreviousLoginEntry() != null) {
            UserLoginEntry entry = this.loginHistory.getPreviousLoginEntry();
            String friendlyClient = entry.getFriendlyClient();
            if (friendlyClient == null || friendlyClient.isEmpty() || friendlyClient.equals("UNKNOWN_PRODUCT")) {
                friendlyClient = lex.get("session.info.unknown.client");
            }
            return lex.getText("session.info.previousLogin", BAbsTime.make(entry.getTimestamp().getTime()), entry.getLocation(), friendlyClient);
        }
        return null;
    }

    public String getFirstLoginMessage() {
        if (this.loginHistory != null && this.loginHistory.getLastLoginEntry() != null) {
            UserLoginEntry entry = this.loginHistory.getLastLoginEntry();
            String friendlyClient = entry.getFriendlyClient();
            if (friendlyClient == null || friendlyClient.isEmpty() || friendlyClient.equals("UNKNOWN_PRODUCT")) {
                friendlyClient = lex.get("session.info.unknown.client");
            }
            return lex.getText("session.info.firstLogin", BAbsTime.make(entry.getTimestamp().getTime()), entry.getLocation(), friendlyClient);
        }
        return null;
    }

    public BIcon getLoginHistoryIcon() {
        return BIcon.make(lex.getText("session.info.login.history.icon"));
    }

    public UserLoginHistory getUserLoginHistory() {
        return this.loginHistory;
    }

    public BIcon getIdentityVerifiedIcon() {
        return BIcon.make(lex.getText("session.info.identityVerified.icon"));
    }

    public String getIdentityVerifiedMessage() {
        return lex.getText("session.info.identityVerified");
    }

    public BIcon getHostnameIcon() {
        return BIcon.make(lex.getText("session.info.hostname.icon"));
    }

    public String getHostnameMessage() {
        return lex.getText("session.info.hostname", this.hostname);
    }

    public BIcon getSessionEncryptedIcon() {
        return BIcon.make(lex.getText("session.info.sessionEncrypted.icon"));
    }

    public String getSessionEncryptedMessage() {
        return lex.getText("session.info.sessionEncrypted", this.name);
    }

    public boolean isFips() {
        return this.isFips;
    }

    public BIcon getFipsIcon() {
        if (this.isFips) {
            return BIcon.make(lex.getText("session.info.fips.icon"));
        }
        return BIcon.make(lex.getText("session.info.notFips.icon"));
    }

    public String getFipsMessage() {
        if (this.isFips) {
            return lex.getText("session.info.fips");
        }
        return lex.getText("session.info.notFips");
    }
}

