/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.asm.Assembler;
import com.tridium.asm.Code;
import com.tridium.asm.ConstantPool;
import com.tridium.asm.MethodInfo;
import com.tridium.asm.OpCodes;
import com.tridium.sys.module.AutoClassLoader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.baja.sys.BObject;

public class AbstractStubGen
implements OpCodes {
    public static final HashMap<Class<?>, Class<?>> cache = new HashMap();
    Class<?> cls;
    Assembler asm;
    ConstantPool cp;
    int init;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getConcreteClass(Class<?> cls) throws Exception {
        Class<?> stub;
        if (!AbstractStubGen.isAbstract(cls) && !cls.isInterface()) {
            return cls;
        }
        HashMap<Class<?>, Class<?>> hashMap = cache;
        synchronized (hashMap) {
            stub = cache.get(cls);
            if (stub == null) {
                stub = new AbstractStubGen(cls).generate();
                cache.put(cls, stub);
            }
        }
        return stub;
    }

    public AbstractStubGen(Class<?> cls) {
        this.cls = cls;
    }

    public Class<?> generate() throws Exception {
        String thisClass;
        if (!this.cls.isInterface()) {
            String superClass = this.cls.getName().replace('.', '/');
            thisClass = "auto/" + superClass + "Stub";
            int flags = 33;
            this.asm = new Assembler(thisClass, superClass, flags, null);
            this.cp = this.asm.cp;
        } else {
            String superClass = BObject.class.getName().replace('.', '/');
            thisClass = "auto/" + this.cls.getName().replace('.', '/') + "BObjectStub";
            String[] interfaces = new String[]{this.cls.getName().replace('.', '/')};
            int flags = 33;
            this.asm = new Assembler(thisClass, superClass, flags, interfaces);
            this.cp = this.asm.cp;
        }
        this.genConstants();
        this.genConstructor();
        return AutoClassLoader.load(this.cls, thisClass.replace('/', '.'), this.asm.compile());
    }

    private void genConstants() {
        this.init = this.cp.utf("<init>");
    }

    private void genConstructor() {
        Code c = new Code(this.asm);
        c.add(42);
        c.add(183, c.cp.method(this.asm.superClass, this.init, "()V"));
        c.add(177);
        this.asm.addMethod(new MethodInfo(this.asm, this.init, "()V", 1, c));
    }

    public static boolean isAbstract(Class<?> cls) {
        return Modifier.isAbstract(cls.getModifiers());
    }

    public static boolean isAbstract(Method m) {
        return Modifier.isAbstract(m.getModifiers());
    }
}

