/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.user;

import com.tridium.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.role.BIRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototype;
import javax.baja.user.BUserService;

@NiagaraType(agent={@AgentOn(types={"baja:UserService"})})
public class BUserServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BUserServiceSecurityDashboardProviderAgent.class);
    private BUserService service;
    private SecurityDashboardItemBuilder builder;
    private static final String SECTION_HEADER = "securityDashboard.userService.sectionHeader";
    private static final String NUMBER_OF_USERS_SUMMARY = "securityDashboard.numberOfUsers.summary";
    private static final String NUMBER_OF_USERS_DESCRIPTION = "securityDashboard.numberOfUsers.description";
    private static final String ALL_SUPER_USERS_SUMMARY = "securityDashboard.allUsersAreSuperUsers.summary";
    private static final String ALL_SUPER_USERS_DESCRIPTION = "securityDashboard.allUsersAreSuperUsers.description";
    private static final String NUMBER_OF_SUPER_USERS_SUMMARY = "securityDashboard.numberOfSuperUsers.summary";
    private static final String NUMBER_OF_SUPER_USERS_DESCRIPTION = "securityDashboard.numberOfSuperUsers.description";
    private static final String NUMBER_OF_HIDDEN_USERS_SUMMARY = "securityDashboard.numberOfHiddenUsers.summary";
    private static final String NUMBER_OF_HIDDEN_USERS_DESCRIPTION = "securityDashboard.numberOfHiddenUsers.description";
    private static final String NO_HIDDEN_USERS_SUMMARY = "securityDashboard.noHiddenUsers.summary";
    private static final String SUPER_USER_WITH_DEFAULT_NAME_SUMMARY = "securityDashboard.superUserWithDefaultName.summary";
    private static final String SUPER_USER_WITH_DEFAULT_NAME_DESCRIPTION = "securityDashboard.superUserWithDefaultName.description";
    private static final String AUTO_LOGOFF_DISABLED_SUMMARY = "securityDashboard.autoLogoffDisabled.summary";
    private static final String AUTO_LOGOFF_DISABLED_DESCRIPTION = "securityDashboard.autoLogoffDisabled.description";
    private static final String LOCKOUT_ENABLED_SUMMARY = "securityDashboard.lockOutEnabled.summary";
    private static final String LOCKOUT_DISABLED_SUMMARY = "securityDashboard.lockOutDisabled.summary";
    private static final String LOCKOUT_DESCRIPTION = "securityDashboard.lockOut.description";
    private static final String USER_PROTOTYPES_SUMMARY = "securityDashboard.userPrototypes.summary";
    private static final String USER_PROTOTYPES_DESCRIPTION = "securityDashboard.userPrototypes.description";
    private static final String ALL_USERS_EXPIRATION_ENABLED_SUMMARY = "securityDashboard.allUsersExpirationEnabled.summary";
    private static final String ALL_USERS_EXPIRATION_DISABLED_SUMMARY = "securityDashboard.allUsersExpirationDisabled.summary";
    private static final String NUMBER_OF_USERS_EXPIRATION_ENABLED_SUMMARY = "securityDashboard.numberOfUsersExpirationEnabled.summary";
    private static final String NUMBER_OF_USERS_EXPIRATION_DISABLED_SUMMARY = "securityDashboard.numberOfUsersExpirationDisabled.summary";
    private static final String PASSWORD_EXPIRATION_DESCRIPTION = "securityDashboard.passwordExpiration.description";
    private static final String CONCURRENT_SESSION_ENABLED_SUMMARY = "securityDashboard.concurrentSessionEnabled.summary";
    private static final String CONCURRENT_SESSION_DISABLED_SUMMARY = "securityDashboard.concurrentSessionDisabled.summary";
    private static final String CONCURRENT_SESSION_DESCRIPTION = "securityDashboard.concurrentSession.description";
    private static final String SERVER_MIN_MAX_CHECKS_DISABLED_SUMMARY = "securityDashboard.serverMinMaxChecksDisabled.summary";
    private static final String SERVER_MIN_MAX_CHECKS_DISABLED_DESCRIPTION = "securityDashboard.serverMinMaxChecksDisabled.description";
    private static final String NON_DEFAULT_EXCLUSIONS_ON_SERVER_MIN_MAX_CHECKS_SUMMARY = "securityDashboard.nonDefaultExclusionsOnServerMinMaxChecks.summary";
    private static final String NON_DEFAULT_EXCLUSIONS_ON_SERVER_MIN_MAX_CHECKS_DESCRIPTION = "securityDashboard.nonDefaultExclusionsOnServerMinMaxChecks.description";
    private static final String ABSOLUTE_LOGOFF_ENABLED_SUMMARY = "securityDashboard.absoluteLogoffEnabled.summary";
    private static final String ABSOLUTE_LOGOFF_ENABLED_DESCRIPTION = "securityDashboard.absoluteLogoffEnabled.description";
    private static final String ABSOLUTE_LOGOFF_DISABLED_SUMMARY = "securityDashboard.absoluteLogoffDisabled.summary";
    private static final String ABSOLUTE_LOGOFF_USERS_DISABLED_SUMMARY = "securityDashboard.absoluteLogoffUsersDisabled.summary";
    private static final String ABSOLUTE_LOGOFF_USERS_DISABLED_DESCRIPTION = "securityDashboard.absoluteLogoffUsersDisabled.description";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void setSecurityDashboardItemsSource(BIObject object) {
        this.service = (BUserService)object;
        this.builder = new SecurityDashboardItemBuilder(this);
    }

    @Override
    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make(TYPE, SECTION_HEADER);
    }

    @Override
    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.service.getNavOrd().relativizeToSession();
    }

    @Override
    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    @Override
    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        items.addAll(this.getNumberOfActiveUsersItem());
        items.addAll(this.getNumberOfHiddenUsersItem());
        items.addAll(this.getNumberOfSuperUsersItem());
        items.addAll(this.getSuperUserWithDefaultNameAdminItem());
        items.addAll(this.getLockOutEnabledItem());
        items.addAll(this.getAutoLogoffDisabledItem());
        items.addAll(this.getAbsoluteLogoffItems());
        items.addAll(this.getUserPrototypesItem());
        items.addAll(this.getPasswordExpirationItems());
        items.addAll(this.getConcurrentSessionItems());
        items.addAll(this.getServerMinMaxChecksDisabledItem());
        items.addAll(this.getNonDefaultExclusionsOnServerMinMaxChecksItem());
        return items;
    }

    private List<SecurityDashboardItem> getNumberOfActiveUsersItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        items.add(this.builder.makeInfo().withSummary(NUMBER_OF_USERS_SUMMARY, this.service.getUsers().length).withDescription(NUMBER_OF_USERS_DESCRIPTION, new Object[0]));
        return items;
    }

    private List<SecurityDashboardItem> getNumberOfHiddenUsersItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BUser[] users = this.service.getUsers();
        long hiddenUserCount = 0L;
        for (BUser user : users) {
            if (!Flags.isHidden(this.service, user.getPropertyInParent())) continue;
            ++hiddenUserCount;
        }
        if (hiddenUserCount > 0L) {
            items.add(this.builder.makeWarning().withSummary(NUMBER_OF_HIDDEN_USERS_SUMMARY, hiddenUserCount).withDescription(NUMBER_OF_HIDDEN_USERS_DESCRIPTION, new Object[0]));
        } else {
            items.add(this.builder.makeOk().withSummary(NO_HIDDEN_USERS_SUMMARY, new Object[0]).withDescription(NUMBER_OF_HIDDEN_USERS_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private List<SecurityDashboardItem> getNumberOfSuperUsersItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        long superUserCount = Arrays.stream(this.service.getUsers()).filter(this.service::checkSuperuser).count();
        if (superUserCount == (long)this.service.getUsers().length) {
            items.add(this.builder.makeAlert(ALL_SUPER_USERS_SUMMARY, ALL_SUPER_USERS_DESCRIPTION));
        } else {
            items.add(this.builder.makeInfo().withSummary(NUMBER_OF_SUPER_USERS_SUMMARY, superUserCount).withDescription(NUMBER_OF_SUPER_USERS_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private List<SecurityDashboardItem> getSuperUserWithDefaultNameAdminItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BUser user = this.service.getAdmin();
        if (user != null && "admin".equalsIgnoreCase(user.getName())) {
            items.add(this.builder.makeWarning(SUPER_USER_WITH_DEFAULT_NAME_SUMMARY, SUPER_USER_WITH_DEFAULT_NAME_DESCRIPTION));
        }
        return items;
    }

    private List<SecurityDashboardItem> getLockOutEnabledItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (this.service.getLockOutEnabled()) {
            items.add(this.builder.makeOk(LOCKOUT_ENABLED_SUMMARY, LOCKOUT_DESCRIPTION));
        } else {
            items.add(this.builder.makeAlert(LOCKOUT_DISABLED_SUMMARY, LOCKOUT_DESCRIPTION));
        }
        return items;
    }

    private List<SecurityDashboardItem> getAutoLogoffDisabledItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        StringJoiner autoLogoffDisabledUsers = new StringJoiner(", ");
        Arrays.stream(this.service.getUsers()).filter(user -> !user.getAutoLogoffSettings().getAutoLogoffEnabled()).forEach(user -> autoLogoffDisabledUsers.add(user.getName()));
        if (autoLogoffDisabledUsers.length() > 0) {
            items.add(this.builder.makeAlert().withSummary(AUTO_LOGOFF_DISABLED_SUMMARY, autoLogoffDisabledUsers).withDescription(AUTO_LOGOFF_DISABLED_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private List<SecurityDashboardItem> getUserPrototypesItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        StringJoiner superUserPrototypes = new StringJoiner(", ");
        for (BComponent prototype : this.service.getUserPrototypes().getPrototypes()) {
            BUserPrototype userPrototype;
            if (prototype instanceof BUser) {
                BUser user = (BUser)prototype;
                if (!user.getPermissions().isSuperUser()) continue;
                superUserPrototypes.add(prototype.getName());
                continue;
            }
            if (!(prototype instanceof BUserPrototype) || !BUserServiceSecurityDashboardProviderAgent.hasSuperUserRole(userPrototype = (BUserPrototype)prototype)) continue;
            superUserPrototypes.add(prototype.getName());
        }
        if (superUserPrototypes.length() > 0) {
            items.add(this.builder.makeWarning().withSummary(USER_PROTOTYPES_SUMMARY, superUserPrototypes.toString()).withDescription(USER_PROTOTYPES_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private static boolean hasSuperUserRole(BUserPrototype userPrototype) {
        Optional<BIService> service = Sys.findService(BRoleService.TYPE);
        if (service.isPresent()) {
            String[] roles;
            BRoleService roleService = (BRoleService)service.get();
            for (String r : roles = userPrototype.getRoles().getValue().toString().split(",")) {
                BIRole role = roleService.getRole(r);
                if (role == null || !role.getEnabled() || !role.getPermissions().isSuperUser()) continue;
                return true;
            }
        }
        return false;
    }

    private List<SecurityDashboardItem> getPasswordExpirationItems() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        int numPasswordAuthenticatorUsers = 0;
        int numExpirationEnabledUsers = 0;
        for (BUser user : this.service.getUsers()) {
            BAbstractAuthenticator authenticator = user.getAuthenticator();
            if (!(authenticator instanceof BPasswordAuthenticator)) continue;
            ++numPasswordAuthenticatorUsers;
            if (((BPasswordAuthenticator)authenticator).getPasswordConfig().getExpiration().isNull()) continue;
            ++numExpirationEnabledUsers;
        }
        int numExpirationDisabledUsers = numPasswordAuthenticatorUsers - numExpirationEnabledUsers;
        if (numPasswordAuthenticatorUsers == 0) {
            return items;
        }
        if (numExpirationEnabledUsers == numPasswordAuthenticatorUsers) {
            items.add(this.builder.makeInfo(ALL_USERS_EXPIRATION_ENABLED_SUMMARY, PASSWORD_EXPIRATION_DESCRIPTION));
        } else if (numExpirationDisabledUsers == numPasswordAuthenticatorUsers) {
            items.add(this.builder.makeInfo(ALL_USERS_EXPIRATION_DISABLED_SUMMARY, PASSWORD_EXPIRATION_DESCRIPTION));
        } else {
            items.add(this.builder.makeInfo().withSummary(NUMBER_OF_USERS_EXPIRATION_DISABLED_SUMMARY, numExpirationDisabledUsers).withDescription(PASSWORD_EXPIRATION_DESCRIPTION, new Object[0]));
            items.add(this.builder.makeInfo().withSummary(NUMBER_OF_USERS_EXPIRATION_ENABLED_SUMMARY, numExpirationEnabledUsers).withDescription(PASSWORD_EXPIRATION_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private List<SecurityDashboardItem> getConcurrentSessionItems() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        StringJoiner concurrentSessionEnabledUsers = new StringJoiner(", ");
        StringJoiner concurrentSessionDisabledUsers = new StringJoiner(", ");
        Arrays.stream(this.service.getUsers()).filter(this.service::checkSuperuser).forEach(user -> {
            if (user.getAllowConcurrentSessions()) {
                concurrentSessionEnabledUsers.add(user.getName());
            } else {
                concurrentSessionDisabledUsers.add(user.getName());
            }
        });
        if (concurrentSessionEnabledUsers.length() > 0) {
            items.add(this.builder.makeInfo().withSummary(CONCURRENT_SESSION_ENABLED_SUMMARY, concurrentSessionEnabledUsers).withDescription(CONCURRENT_SESSION_DESCRIPTION, new Object[0]));
        }
        if (concurrentSessionDisabledUsers.length() > 0) {
            items.add(this.builder.makeInfo().withSummary(CONCURRENT_SESSION_DISABLED_SUMMARY, concurrentSessionDisabledUsers).withDescription(CONCURRENT_SESSION_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private List<SecurityDashboardItem> getServerMinMaxChecksDisabledItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (ObjectUtil.SERVER_MIN_MAX_CHECK_DISABLED) {
            items.add(this.builder.makeWarning(SERVER_MIN_MAX_CHECKS_DISABLED_SUMMARY, SERVER_MIN_MAX_CHECKS_DISABLED_DESCRIPTION));
        }
        return items;
    }

    private List<SecurityDashboardItem> getNonDefaultExclusionsOnServerMinMaxChecksItem() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (!(ObjectUtil.SERVER_MIN_MAX_CHECK_DISABLED || ObjectUtil.MIN_MAX_CHECK_EXCLUDED_TYPES.isEmpty() || ObjectUtil.DEFAULT_MIN_MAX_CHECK_EXCLUDED_TYPES.equals(ObjectUtil.MIN_MAX_CHECK_EXCLUDED_TYPES))) {
            items.add(this.builder.makeInfo().withSummary(NON_DEFAULT_EXCLUSIONS_ON_SERVER_MIN_MAX_CHECKS_SUMMARY, String.join((CharSequence)", ", ObjectUtil.MIN_MAX_CHECK_EXCLUDED_TYPES.stream().map(TypeInfo::toString).collect(Collectors.toSet()))).withDescription(NON_DEFAULT_EXCLUSIONS_ON_SERVER_MIN_MAX_CHECKS_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private List<SecurityDashboardItem> getAbsoluteLogoffItems() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (!this.service.getAbsoluteLogoffEnabled()) {
            items.add(this.builder.makeWarning(ABSOLUTE_LOGOFF_DISABLED_SUMMARY, ABSOLUTE_LOGOFF_ENABLED_DESCRIPTION));
        } else {
            items.add(this.builder.makeOk(ABSOLUTE_LOGOFF_ENABLED_SUMMARY, ABSOLUTE_LOGOFF_ENABLED_DESCRIPTION));
            ArrayList<String> disabledUsers = new ArrayList<String>();
            for (BUser user : this.service.getUsers()) {
                if (user.getAutoLogoffSettings().getAbsoluteLogoffEnabled()) continue;
                disabledUsers.add(user.getName());
            }
            if (!disabledUsers.isEmpty()) {
                items.add(this.builder.makeWarning().withSummary(ABSOLUTE_LOGOFF_USERS_DISABLED_SUMMARY, String.join((CharSequence)", ", disabledUsers)).withDescription(ABSOLUTE_LOGOFF_USERS_DISABLED_DESCRIPTION, new Object[0]));
            }
        }
        return items;
    }
}

