/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;

public class TzJarUtil {
    private static final Logger logger = Logger.getLogger("timezone.jarUtil");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Array<BTimeZone> getTimeZones(InputStream jarIn) {
        logger.fine("entered TzJarUtil::getTimeZoneIds()");
        Array tzs = new Array(BTimeZone.class);
        JarDataInputStream jdIn = null;
        try {
            JarEntry jEntry;
            jdIn = new JarDataInputStream(jarIn);
            while ((jEntry = jdIn.getNextJarEntry()) != null) {
                if (jEntry.getName().endsWith(".class") || jEntry.getName().endsWith(".properties") || jEntry.getName().startsWith("META-INF") || jEntry.getName().startsWith("meta-inf")) {
                    jdIn.closeEntry();
                    continue;
                }
                if (TimeZoneDatabase.isZoneIdSupported(jEntry.getName().replace('\\', '/'))) {
                    BTimeZone current = BTimeZone.getTimeZone(jEntry.getName().replace('\\', '/'));
                    tzs.add((Object)current);
                } else {
                    logger.warning("remote time zone \"" + jEntry.getName().replace('\\', '/') + "\" is not supported locally, ignoring");
                }
                jdIn.closeEntry();
            }
            Array array = tzs;
            return array;
        }
        catch (IOException ioe) {
            logger.severe("error occurred in TzJarUtil::getTimeZoneIds(): " + ioe.getMessage());
        }
        finally {
            try {
                jdIn.closeEntry();
            }
            catch (IOException iOException) {}
            try {
                jdIn.readFully();
            }
            catch (IOException iOException) {}
            try {
                jdIn.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static class JarDataInputStream
    extends JarInputStream {
        private static final int SIZE_OF_CHAR = 2;
        private static final int SIZE_OF_SHORT = 2;
        private static final int SIZE_OF_INT = 4;
        private static final int SIZE_OF_LONG = 8;
        private int entryBytesRead = 0;

        public JarDataInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public JarEntry getNextJarEntry() throws IOException {
            this.entryBytesRead = 0;
            return super.getNextJarEntry();
        }

        byte readByte() throws IOException {
            byte[] buf = new byte[1];
            this.entryBytesRead += super.read(buf, 0, 1);
            return buf[0];
        }

        char readChar() throws IOException {
            return new ByteBuffer(this.read(2)).readChar();
        }

        short readShort() throws IOException {
            return new ByteBuffer(this.read(2)).readShort();
        }

        int readInt() throws IOException {
            return new ByteBuffer(this.read(4)).readInt();
        }

        long readLong() throws IOException {
            return new ByteBuffer(this.read(8)).readLong();
        }

        byte[] read(int numberOfBytes) throws IOException {
            byte[] buf = new byte[numberOfBytes];
            for (int i = 0; i < numberOfBytes; ++i) {
                buf[i] = (byte)super.read();
            }
            this.entryBytesRead += numberOfBytes;
            return buf;
        }

        int getEntryBytesRead() {
            return this.entryBytesRead;
        }

        void readFully() throws IOException {
            byte[] buf = new byte[1024];
            while (this.in.read(buf, 0, 1024) > 0) {
            }
        }
    }
}

