/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.syslog;

import com.tridium.nre.syslog.Message;
import com.tridium.nre.syslog.SyslogManager;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.syslog.AuditAdapter;
import java.util.logging.Level;
import javax.baja.security.AuditEvent;

public class SyslogAuditHandler {
    private final AuditAdapter auditAdapter = new AuditAdapter();
    private final SyslogManager logManager;
    private final ThreadLocal<Boolean> ignoreMessages = ThreadLocal.withInitial(() -> false);

    public SyslogAuditHandler() {
        this.logManager = SyslogManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(AuditEvent event, boolean isSecurityAuditEvent) {
        if (!this.logManager.getEnabled()) {
            return;
        }
        if (this.ignoreMessages.get().booleanValue()) {
            return;
        }
        try {
            this.ignoreMessages.set(true);
            if (isSecurityAuditEvent ? !this.logManager.getSecurityAuditEnabled() : !this.logManager.getStationAuditEnabled()) {
                return;
            }
            SyslogManager.LOG.fine("Publishing audit record");
            try {
                StringBuilder msgString = new StringBuilder();
                String priority = this.auditAdapter.adaptPriority(event, this.logManager.getFacility());
                msgString.append(priority);
                String timestamp = this.auditAdapter.adaptTimeStamp(event);
                msgString.append(timestamp).append(' ');
                String host = IPAddressUtil.getHostName();
                msgString.append(host).append(' ');
                String tag = this.logManager.getEnvironmentTag();
                msgString.append(tag).append(": ");
                msgString.append(isSecurityAuditEvent ? "SECURITY_AUDIT " : "AUDIT ").append(event);
                Message message = new Message();
                message.print(msgString.toString());
                this.logManager.publish(message);
            }
            catch (Throwable t) {
                SyslogManager.LOG.log(Level.SEVERE, "Failed to publish audit record.", t);
            }
        }
        finally {
            this.ignoreMessages.set(false);
        }
    }
}

