/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.space.BGateway;
import com.tridium.sys.transfer.CompToBog;
import com.tridium.sys.transfer.CompToComp;
import com.tridium.sys.transfer.DeployToComp;
import com.tridium.sys.transfer.FileToComp;
import com.tridium.sys.transfer.FileToFile;
import com.tridium.sys.transfer.IntraFileSpaceMove;
import com.tridium.sys.transfer.RemoteIntraSpace;
import com.tridium.sys.transfer.RemoteTransferSpace;
import com.tridium.sys.transfer.ToNavFolder;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferResult;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDeployable;
import javax.baja.file.BIFile;
import javax.baja.file.BIScopedFileSpace;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavFolder;
import javax.baja.nav.BNavRoot;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.BVirtualGateway;

public abstract class TransferStrategy {
    public static final int ACTION_COPY = 16;
    public static final int ACTION_MOVE = 32;
    public static final String PARAM_EXACT = "exact";
    public static final String PARAM_EXACT_CONFIG = "exactConfig";
    public static final String PARAM_ORIGIN = "origin";
    public static final String PARAM_COPY_SOURCE = "copySource";
    public static final String PARAM_KEEP_ALL_LINKS = "keepAllLinks";
    public static final String PARAM_KEEP_ALL_RELATIONS = "keepAllRelations";
    public static final Logger log = Logger.getLogger("sys.transfer");
    int action;
    BObject target;
    Mark mark;
    Context context;
    BComponent params;
    TransferListener listener;
    static TypeInfo BOG_FILE_TYPE_INFO;

    public static TransferStrategy make(int action, Mark mark, BObject target, BComponent params, Context context) {
        TransferStrategy strategy;
        if (TransferStrategy.isDebugOn()) {
            TransferStrategy.debug("====== TransferStrategy.make ======");
            TransferStrategy.debug(" action  = " + action);
            TransferStrategy.debug(" mark    = " + mark);
            TransferStrategy.debug(" target  = " + target);
            TransferStrategy.debug(" params  = " + params);
            TransferStrategy.debug(" context = " + context);
        }
        target = TransferStrategy.toActualTarget(target);
        if (mark.getValues().length == 1) {
            String name = mark.getNames()[0];
            BObject value = mark.getValues()[0];
            if (value instanceof BComponentSpace) {
                BComponent comp = ((BComponentSpace)value).getRootComponent();
                mark = new Mark(comp, name);
            }
        }
        if ((strategy = TransferStrategy.makeImpl(action, mark, target, context)) == null) {
            return null;
        }
        if (TransferStrategy.isDebugOn()) {
            TransferStrategy.debug(" class   = " + strategy.getClass().getName());
        }
        strategy.action = action;
        strategy.mark = mark;
        strategy.target = target;
        strategy.params = params;
        strategy.context = context;
        return strategy;
    }

    public static BObject toActualTarget(BObject target) {
        BComponent root;
        BComponentSpace vSpace;
        if (target instanceof BGateway) {
            target = ((BGateway)target).getGatewaySpace();
        }
        if (target instanceof BComponentSpace) {
            return ((BComponentSpace)target).getRootComponent();
        }
        if (target.getType().getTypeName().equals("FoxLibraryFileSpace")) {
            return (BObject)((Object)((BFileSpace)target).resolveFile(new FilePath("")));
        }
        if (target.getType().getTypeName().equals("FoxFileSpace")) {
            return (BObject)((Object)((BFileSpace)target).resolveFile(new FilePath("^")));
        }
        try {
            if (BOG_FILE_TYPE_INFO == null) {
                BOG_FILE_TYPE_INFO = BTypeSpec.make("file", "BogFile").getTypeInfo();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (BOG_FILE_TYPE_INFO != null && target.getType().is(BOG_FILE_TYPE_INFO)) {
            return BOrd.make("bog:|slot:/").get(target);
        }
        if (target instanceof BVirtualGateway && (vSpace = ((BVirtualGateway)target).getVirtualSpace()) != null && (root = vSpace.getRootComponent()) != null) {
            root.loadSlots();
            return root;
        }
        return target;
    }

    static TransferStrategy makeImpl(int action, Mark mark, BObject target, Context cx) {
        if (target instanceof BComponent) {
            return TransferStrategy.toComp(action, mark, (BComponent)target, cx);
        }
        if (target instanceof BIFile) {
            return TransferStrategy.toFile(action, mark, (BIFile)((Object)target), cx);
        }
        if (target instanceof BIScopedFileSpace) {
            return TransferStrategy.toFile(action, mark, ((BIScopedFileSpace)((Object)target)).findFile(new FilePath("")), cx);
        }
        if (target instanceof BNavFolder || target instanceof BNavRoot) {
            return new ToNavFolder();
        }
        return null;
    }

    static TransferStrategy toComp(int action, Mark mark, BComponent target, Context cx) {
        BSpace sourceSpace = TransferStrategy.toSpace(mark);
        BComponentSpace targetSpace = target.getComponentSpace();
        if (mark.getValues()[0] instanceof BIDeployable && (action == 32 || action == 16)) {
            return new DeployToComp();
        }
        if (sourceSpace == targetSpace) {
            if (targetSpace instanceof RemoteTransferSpace) {
                return new RemoteIntraSpace();
            }
            if (action == 32) {
                return (TransferStrategy)sourceSpace.fw(113);
            }
        }
        TransferStrategy strategy = null;
        if (sourceSpace == null) {
            strategy = new CompToComp();
        } else if (sourceSpace instanceof BComponentSpace) {
            strategy = (TransferStrategy)sourceSpace.fw(114);
            if (strategy == null) {
                strategy = new CompToComp();
            }
        } else if (sourceSpace instanceof BFileSpace && (strategy = (TransferStrategy)sourceSpace.fw(115)) == null) {
            strategy = new FileToComp();
        }
        return strategy;
    }

    static TransferStrategy toFile(int action, Mark mark, BIFile target, Context cx) {
        BSpace srcSpace = TransferStrategy.toSpace(mark);
        if (srcSpace instanceof BFileSpace) {
            return TransferStrategy.fileToFile(action, mark, target, cx);
        }
        if (srcSpace instanceof BComponentSpace) {
            return TransferStrategy.componentToFile(action, mark, target, cx);
        }
        return null;
    }

    static TransferStrategy fileToFile(int action, Mark mark, BIFile target, Context cx) {
        BFileSpace targetSpace;
        BFileSpace sourceSpace = (BFileSpace)TransferStrategy.toSpace(mark);
        if (sourceSpace == (targetSpace = target.getFileSpace())) {
            if (targetSpace instanceof RemoteTransferSpace) {
                return new RemoteIntraSpace();
            }
            BObject[] values = mark.getValues();
            boolean directory = false;
            for (int i = 0; i < values.length && !directory; ++i) {
                if (!(values[i] instanceof BIFile) || !((BIFile)((Object)values[i])).isDirectory()) continue;
                directory = true;
            }
            if (action == 32 && !directory) {
                return new IntraFileSpaceMove();
            }
        }
        return new FileToFile();
    }

    static TransferStrategy componentToFile(int action, Mark mark, BIFile target, Context cx) {
        if (target instanceof BDirectory) {
            return new CompToBog();
        }
        return null;
    }

    public int getAction() {
        return this.action;
    }

    public boolean isCopy() {
        return this.action == 16;
    }

    public boolean isMove() {
        return this.action == 32;
    }

    public Mark getMark() {
        return this.mark;
    }

    public BObject getTarget() {
        return this.target;
    }

    public Context getContext() {
        return this.context;
    }

    public abstract TransferResult transfer() throws Exception;

    public BComponent getParameters() {
        return this.params;
    }

    public BObject getParameter(String name, BObject def) {
        if (this.params == null) {
            return def;
        }
        BValue r = this.params.get(name);
        if (r != null) {
            return r;
        }
        return def;
    }

    public boolean getParameter(String name, boolean def) {
        if (this.params == null) {
            return def;
        }
        BBoolean r = (BBoolean)this.params.get(name);
        if (r != null) {
            return r.getBoolean();
        }
        return def;
    }

    public int getParameter(String name, int def) {
        if (this.params == null) {
            return def;
        }
        BInteger r = (BInteger)this.params.get(name);
        if (r != null) {
            return r.getInt();
        }
        return def;
    }

    public String getParameter(String name, String def) {
        if (this.params == null) {
            return def;
        }
        BString r = (BString)this.params.get(name);
        if (r != null) {
            return r.getString();
        }
        return def;
    }

    public TransferListener getListener() {
        return this.listener;
    }

    public void setListener(TransferListener listener) {
        this.listener = listener;
    }

    public void updateStatus(String msg) {
        try {
            if (this.listener != null) {
                this.listener.updateStatus(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String toString(BObject object) {
        try {
            BComponent c;
            if (object instanceof BComponent && (c = (BComponent)object).isMounted()) {
                return c.toPathString();
            }
            return object.getType().toString();
        }
        catch (Exception e) {
            return "error";
        }
    }

    public static BSpace toSpace(Mark mark) {
        return TransferStrategy.toSpace(mark.getValues()[0]);
    }

    public static BSpace toSpace(BObject object) {
        if (object instanceof BISpaceNode) {
            return ((BISpaceNode)((Object)object)).getSpace();
        }
        return null;
    }

    public static boolean isDebugOn() {
        return log.isLoggable(Level.FINE);
    }

    public static void debug(String s) {
        System.out.print("> ");
        System.out.println(s);
    }

    public void dump() {
        TransferStrategy.debug("Transfer: " + this.getClass().getName());
        TransferStrategy.debug("  o action:   " + (this.isMove() ? "move" : "copy"));
        TransferStrategy.debug("  o target:   " + this.target);
        TransferStrategy.debug("  o mark:     " + this.mark);
        TransferStrategy.debug("  o context:  " + this.context);
        this.dumpExtra();
        if (this.params == null) {
            TransferStrategy.debug("  o params: null");
        } else {
            TransferStrategy.debug("  o params:");
            Property[] props = this.params.getPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                TransferStrategy.debug("      " + props[i].getName() + " = " + this.params.get(props[i]));
            }
        }
    }

    protected void dumpExtra() {
    }
}

