/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.TransferStrategy;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class DeleteOp {
    static final int MAGIC_1 = 7649;
    static final int MAGIC_2 = 11745;
    static final char MAGIC_3 = '\u2de2';
    static final BFacets noRemoveLinks = BFacets.make("niagaraRemoveLinks", BBoolean.FALSE);
    protected BComponentSpace space;
    protected Context context;
    protected int size;
    protected BOrd[] parentOrds;
    protected String[] propNames;
    protected BValue[] values;
    protected int[] flags;
    protected BFacets[] facets;
    protected ExternalLink[] extLinks;
    protected ExternalComposite[] extComposites;
    protected ExternalRelation[] extRelations;

    public static DeleteOp make(Mark mark, Context cx) {
        return new DeleteOp(mark, cx);
    }

    public static DeleteOp make(BComponentSpace space, Context cx, InputStream in) throws Exception {
        DeleteOp op = new DeleteOp();
        op.space = space;
        op.context = cx;
        op.read(in);
        return op;
    }

    protected DeleteOp() {
    }

    protected DeleteOp(Mark mark, Context cx) {
        this.space = (BComponentSpace)TransferStrategy.toSpace(mark);
        this.context = cx;
        this.size = mark.size();
        this.parentOrds = new BOrd[this.size];
        this.propNames = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            BComplex v = (BComplex)mark.getValue(i);
            BComponent parent = (BComponent)v.getParent();
            String propName = v.getPropertyInParent().getName();
            this.parentOrds[i] = parent.getHandleOrd();
            this.propNames[i] = propName;
        }
    }

    public DeleteOp delete() {
        return (DeleteOp)this.space.fw(106, this, null, null, null);
    }

    public DeleteOp undelete() {
        return (DeleteOp)this.space.fw(107, this, null, null, null);
    }

    public DeleteOp doDelete() {
        Process p = new Process();
        p.resolveParents();
        p.resolveProps();
        p.save();
        p.explode();
        p.saveAndRemoveExternalRelations();
        p.saveAndRemoveExternalLinks();
        p.remove();
        return this;
    }

    public DeleteOp doUndelete() {
        Process p = new Process();
        p.resolveParents();
        p.add();
        p.restoreExternalRelations();
        p.restoreExternalComposites();
        p.restoreExternalLinks();
        return this;
    }

    private void read(InputStream rawIn) throws Exception {
        int i;
        int flags;
        BOrd ord;
        String[] ordAndFlags;
        int i2;
        int extSize;
        DataInputStream in = new DataInputStream(rawIn);
        if (in.readInt() != 7649) {
            throw new IOException("Invalid magic 1");
        }
        if (in.readInt() != 1) {
            throw new IOException("Invalid version");
        }
        this.size = in.readInt();
        this.parentOrds = new BOrd[this.size];
        this.propNames = new String[this.size];
        for (int i3 = 0; i3 < this.size; ++i3) {
            this.parentOrds[i3] = BOrd.make(in.readUTF());
            this.propNames[i3] = in.readUTF();
        }
        if (in.readBoolean()) {
            extSize = in.readInt();
            this.extLinks = new ExternalLink[extSize];
            for (i2 = 0; i2 < extSize; ++i2) {
                ordAndFlags = TextUtil.split((String)in.readUTF(), (char)'\n');
                ord = BOrd.make(ordAndFlags[0]);
                flags = ordAndFlags.length < 2 ? 0 : Integer.parseInt(ordAndFlags[1], 16);
                BLink link = (BLink)ValueDocDecoder.unmarshal(in.readUTF());
                this.extLinks[i2] = new ExternalLink(ord, link, flags);
            }
        }
        if (in.readBoolean()) {
            extSize = in.readInt();
            this.extRelations = new ExternalRelation[extSize];
            for (i2 = 0; i2 < extSize; ++i2) {
                ordAndFlags = TextUtil.split((String)in.readUTF(), (char)'\n');
                ord = BOrd.make(ordAndFlags[0]);
                flags = ordAndFlags.length < 2 ? 0 : Integer.parseInt(ordAndFlags[1], 16);
                BRelation relation = (BRelation)ValueDocDecoder.unmarshal(in.readUTF());
                this.extRelations[i2] = new ExternalRelation(ord, relation, flags);
            }
        }
        in.readUTF();
        Array accExtComposites = new Array(ExternalComposite.class);
        int futureSize = in.readInt();
        for (i = 0; i < futureSize; ++i) {
            String future = in.readUTF();
            if (!future.startsWith("c")) continue;
            accExtComposites.add((Object)new ExternalComposite().decode(future));
        }
        this.extComposites = (ExternalComposite[])accExtComposites.trim();
        if (in.readInt() != 11745) {
            throw new IOException("Invalid magic 2");
        }
        if (in.readBoolean()) {
            this.flags = new int[this.size];
            this.facets = new BFacets[this.size];
            this.values = new BValue[this.size];
            for (i = 0; i < this.size; ++i) {
                this.flags[i] = in.readInt();
                this.facets[i] = BFacets.make(in.readUTF());
                in.readUTF();
            }
            if (in.readInt() != 11746) {
                throw new IOException("Invalid magic 3");
            }
            ValueDocDecoder decoder = new ValueDocDecoder(in);
            for (int i4 = 0; i4 < this.size; ++i4) {
                decoder.next();
                this.values[i4] = decoder.decode();
            }
        }
    }

    public void write(OutputStream rawOut) throws Exception {
        int i;
        DataOutputStream out = new DataOutputStream(rawOut);
        out.writeInt(7649);
        out.writeInt(1);
        out.writeInt(this.size);
        for (i = 0; i < this.size; ++i) {
            out.writeUTF(this.parentOrds[i].toString());
            out.writeUTF(this.propNames[i]);
        }
        if (this.extLinks == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.extLinks.length);
            for (i = 0; i < this.extLinks.length; ++i) {
                out.writeUTF(this.extLinks[i].target.toString() + "\n" + Integer.toHexString(this.extLinks[i].flags));
                out.writeUTF(ValueDocEncoder.marshal(this.extLinks[i].link));
            }
        }
        if (this.extRelations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.extRelations.length);
            for (i = 0; i < this.extRelations.length; ++i) {
                out.writeUTF(this.extRelations[i].source.toString() + "\n" + Integer.toHexString(this.extRelations[i].flags));
                out.writeUTF(ValueDocEncoder.marshal(this.extRelations[i].relation));
            }
        }
        out.writeUTF("");
        if (this.extComposites == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.extComposites.length);
            for (i = 0; i < this.extComposites.length; ++i) {
                out.writeUTF(this.extComposites[i].encode());
            }
        }
        out.writeInt(11745);
        if (this.values == null) {
            out.writeBoolean(false);
            out.flush();
        } else {
            out.writeBoolean(true);
            for (i = 0; i < this.size; ++i) {
                out.writeInt(this.flags[i]);
                out.writeUTF(this.facets[i].encodeToString());
                out.writeUTF("");
            }
            out.writeInt(11746);
            out.flush();
            ValueDocEncoder encoder = new ValueDocEncoder(out);
            encoder.setEncodeTransients(true);
            encoder.setEncodeComments(false);
            for (int i2 = 0; i2 < this.size; ++i2) {
                encoder.encode(this.values[i2]);
            }
            encoder.flush();
        }
    }

    public void dump() {
        PrintWriter out = new PrintWriter(System.out);
        this.dump(out);
        out.flush();
    }

    public void dump(PrintWriter out) {
        int i;
        out.println("DeleteOp");
        out.println("  size=" + this.size);
        out.println("  items=");
        for (i = 0; i < this.size; ++i) {
            out.println("    [" + i + "] " + this.parentOrds[i] + "/" + this.propNames[i]);
        }
        if (this.values != null) {
            out.println("  values=");
            for (i = 0; i < this.size; ++i) {
                out.println("    [" + i + "] " + this.values[i].toDebugString());
                BComponent[] kids = ((BComponent)this.values[i]).getChildComponents();
                for (int j = 0; j < kids.length; ++j) {
                    if (!kids[j].getPropertyInParent().isDynamic()) continue;
                    out.println("          " + kids[j].getName() + " " + kids[j].toDebugString());
                }
                BLink[] links = this.values[i].asComponent().getLinks();
                for (int j = 0; j < links.length; ++j) {
                    out.println("          " + links[j].getName() + " " + links[j]);
                }
            }
        }
        if (this.extLinks != null) {
            out.println("  extLinks=");
            for (i = 0; i < this.extLinks.length; ++i) {
                out.println("    [" + i + "] " + this.extLinks[i]);
            }
        }
        if (this.extComposites != null) {
            out.println("  extComposites=");
            for (i = 0; i < this.extComposites.length; ++i) {
                out.println("    [" + i + "] " + this.extComposites[i]);
            }
        }
    }

    static class ExternalComposite {
        BOrd composite;
        String name;
        int flags;
        BFacets facets;
        Type type;

        ExternalComposite() {
        }

        public String toString() {
            return this.composite + " " + this.name + " " + Integer.toHexString(this.flags) + " " + this.facets + " " + this.type;
        }

        String encode() throws IOException {
            return "c\n" + this.composite.encodeToString() + "\n" + this.name + "\n" + Integer.toHexString(this.flags) + "\n" + this.facets.encodeToString() + "\n" + this.type.toString();
        }

        ExternalComposite decode(String s) throws IOException {
            String[] toks = TextUtil.split((String)s, (char)'\n');
            this.composite = BOrd.make(toks[1]);
            this.name = toks[2];
            this.flags = Integer.parseInt(toks[3], 16);
            this.facets = BFacets.make(toks[4]);
            this.type = Sys.getType(toks[5]);
            return this;
        }
    }

    static class ExternalRelation {
        BOrd source;
        BRelation relation;
        int flags;

        ExternalRelation(BOrd source, BRelation relation, int flags) {
            this.source = source;
            this.relation = relation;
            this.flags = flags;
        }

        public String toString() {
            return this.source + " " + this.relation;
        }
    }

    static class ExternalLink {
        BOrd target;
        BLink link;
        int flags;

        ExternalLink(BOrd target, BLink link, int flags) {
            this.target = target;
            this.link = link;
            this.flags = flags;
        }

        public String toString() {
            return this.target + " " + this.link;
        }
    }

    public class Process {
        protected BComponent[] parents;
        protected Property[] props;
        protected Map<Object, BComponent> byHandle;

        public void resolveParents() {
            this.parents = new BComponent[DeleteOp.this.size];
            for (int i = 0; i < DeleteOp.this.size; ++i) {
                this.parents[i] = (BComponent)DeleteOp.this.parentOrds[i].get(DeleteOp.this.space);
            }
        }

        public void resolveProps() {
            this.props = new Property[DeleteOp.this.size];
            for (int i = 0; i < DeleteOp.this.size; ++i) {
                this.props[i] = this.parents[i].getProperty(DeleteOp.this.propNames[i]);
                if (this.props[i] != null) continue;
                throw new IllegalStateException("Missing prop to delete: " + DeleteOp.this.parentOrds[i] + "::" + DeleteOp.this.propNames[i]);
            }
        }

        public void save() {
            DeleteOp.this.values = new BValue[DeleteOp.this.size];
            DeleteOp.this.flags = new int[DeleteOp.this.size];
            DeleteOp.this.facets = new BFacets[DeleteOp.this.size];
            for (int i = 0; i < DeleteOp.this.size; ++i) {
                BComponent parent = this.parents[i];
                Property prop = this.props[i];
                DeleteOp.this.values[i] = parent.get(prop);
                DeleteOp.this.flags[i] = prop.getDefaultFlags();
                DeleteOp.this.facets[i] = prop.getFacets();
            }
        }

        public void explode() {
            this.byHandle = new HashMap<Object, BComponent>();
            for (int i = 0; i < DeleteOp.this.size; ++i) {
                if (!(DeleteOp.this.values[i] instanceof BComponent)) continue;
                this.explode((BComponent)DeleteOp.this.values[i]);
            }
        }

        private void explode(BComponent c) {
            this.byHandle.put(c.getHandle(), c);
            SlotCursor<Property> cur = c.getProperties();
            while (cur.nextComponent()) {
                this.explode((BComponent)cur.get());
            }
        }

        public void saveAndRemoveExternalLinks() {
            Array accExtLinks = new Array(ExternalLink.class);
            Array accExtComposites = new Array(ExternalComposite.class);
            Iterator<BComponent> it = this.byHandle.values().iterator();
            while (it.hasNext()) {
                this.saveAndRemoveExternalLinks(it.next(), null, (Array<ExternalLink>)accExtLinks, (Array<ExternalComposite>)accExtComposites);
            }
            DeleteOp.this.extLinks = (ExternalLink[])accExtLinks.trim();
            DeleteOp.this.extComposites = (ExternalComposite[])accExtComposites.trim();
        }

        public void saveAndRemoveExternalRelations() {
            Array accExtRelations = new Array(ExternalRelation.class);
            Iterator<BComponent> it = this.byHandle.values().iterator();
            while (it.hasNext()) {
                this.saveAndRemoveExternalRelations(it.next(), (Array<ExternalRelation>)accExtRelations);
            }
            DeleteOp.this.extRelations = (ExternalRelation[])accExtRelations.trim();
        }

        private void saveAndRemoveExternalLinks(BComponent c, Slot slot, Array<ExternalLink> accExtLinks, Array<ExternalComposite> accExtComposites) {
            Knob[] knobs = slot == null ? c.getKnobs() : c.getKnobs(slot);
            for (int i = 0; i < knobs.length; ++i) {
                Knob knob = knobs[i];
                BComponent target = knob.getTargetComponent();
                Slot targetSlot = knob.getTargetSlot();
                BLink link2 = knob.getLink();
                if (link2 == null) {
                    System.out.println("WARNING: Cannot save knob for undo: " + knob);
                    continue;
                }
                Property linkProp = link2.getPropertyInParent();
                if (slot == null && this.byHandle.get(target.getHandle()) != null) continue;
                boolean isComposite = targetSlot.isDynamic() && (linkProp.getDefaultFlags() & 0x1000) != 0 && (targetSlot.getDefaultFlags() & 0x1000) != 0;
                accExtLinks.add((Object)new ExternalLink(target.getHandleOrd(), (BLink)link2.newCopy(), linkProp.getDefaultFlags()));
                target.remove(linkProp, DeleteOp.this.context);
                if (!isComposite) continue;
                this.removeCompositeSlot(target, (Property)targetSlot, accExtLinks, accExtComposites);
            }
            BLink[] links = slot == null ? c.getLinks() : c.getLinks(slot);
            for (int i = 0; i < links.length; ++i) {
                boolean isComposite;
                BLink link = links[i];
                BComponent source = null;
                try {
                    source = link.getSourceComponent();
                }
                catch (Exception link2) {
                    // empty catch block
                }
                if (source == null) {
                    System.out.println("WARNING: Cannot save link for undo: " + link);
                    continue;
                }
                BComponent target = link.getTargetComponent();
                Slot sourceSlot = link.getSourceSlot();
                Property linkProp = link.getPropertyInParent();
                boolean bl = isComposite = sourceSlot.isDynamic() && (sourceSlot.getDefaultFlags() & 0x1000) != 0 && (linkProp.getDefaultFlags() & 0x1000) != 0;
                if (isComposite || slot != null) {
                    accExtLinks.add((Object)new ExternalLink(target.getHandleOrd(), (BLink)link.newCopy(), linkProp.getDefaultFlags()));
                    target.remove(linkProp, DeleteOp.this.context);
                }
                if (!isComposite) continue;
                this.removeCompositeSlot(source, (Property)sourceSlot, accExtLinks, accExtComposites);
            }
        }

        public void removeCompositeSlot(BComponent c, Property prop, Array<ExternalLink> accExtLinks, Array<ExternalComposite> accExtComposites) {
            ExternalComposite ext = new ExternalComposite();
            ext.composite = c.getHandleOrd();
            ext.name = prop.getName();
            ext.flags = prop.getDefaultFlags();
            ext.facets = prop.getFacets();
            ext.type = prop.getType();
            accExtComposites.add((Object)ext);
            this.saveAndRemoveExternalLinks(c, prop, accExtLinks, accExtComposites);
            c.remove(prop, DeleteOp.this.context);
        }

        private void saveAndRemoveExternalRelations(BComponent c, Array<ExternalRelation> accExtRelations) {
            RelationKnob[] knobs = c.getRelationKnobs();
            for (int i = 0; i < knobs.length; ++i) {
                RelationKnob knob = knobs[i];
                BComponent relationSource = knob.getRelationComponent();
                BRelation relation = knob.getRelation();
                if (relation == null) {
                    System.out.println("WARNING: Cannot save relationKnob for undo: " + knob);
                    continue;
                }
                Property relationProp = relation.getPropertyInParent();
                if (this.byHandle.get(relationSource.getHandle()) != null) continue;
                accExtRelations.add((Object)new ExternalRelation(relationSource.getHandleOrd(), (BRelation)relation.newCopy(), relationProp.getDefaultFlags()));
                relationSource.remove(relationProp, DeleteOp.this.context);
            }
        }

        public void remove() {
            BasicContext cx = new BasicContext(DeleteOp.this.context, noRemoveLinks);
            for (int i = 0; i < DeleteOp.this.size; ++i) {
                this.parents[i].remove(this.props[i], (Context)cx);
            }
        }

        public void add() {
            try {
                Transaction tx = DeleteOp.this.space.newTransaction(DeleteOp.this.context);
                for (int i = 0; i < DeleteOp.this.size; ++i) {
                    BComponent parent = this.parents[i];
                    String name = DeleteOp.this.propNames[i];
                    BValue value = DeleteOp.this.values[i];
                    int flags = DeleteOp.this.flags[i];
                    BFacets facets = DeleteOp.this.facets[i];
                    parent.add(name, value, flags, facets, tx);
                }
                tx.commit(DeleteOp.this.context);
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e);
            }
        }

        public void restoreExternalComposites() {
            for (int i = 0; i < DeleteOp.this.extComposites.length; ++i) {
                try {
                    ExternalComposite ext = DeleteOp.this.extComposites[i];
                    BComponent composite = (BComponent)ext.composite.get(DeleteOp.this.space);
                    BValue value = (BValue)ext.type.getInstance();
                    composite.add(ext.name, value, ext.flags, ext.facets);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void restoreExternalLinks() {
            for (int i = 0; i < DeleteOp.this.extLinks.length; ++i) {
                BOrd ord = DeleteOp.this.extLinks[i].target;
                BLink link = DeleteOp.this.extLinks[i].link;
                int flags = DeleteOp.this.extLinks[i].flags;
                try {
                    BComponent target = (BComponent)ord.get(DeleteOp.this.space);
                    target.add(null, (BValue)link, flags);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void restoreExternalRelations() {
            for (int i = 0; i < DeleteOp.this.extRelations.length; ++i) {
                BOrd ord = DeleteOp.this.extRelations[i].source;
                BRelation relation = DeleteOp.this.extRelations[i].relation;
                int flags = DeleteOp.this.extRelations[i].flags;
                try {
                    BComponent target = (BComponent)ord.get(DeleteOp.this.space);
                    target.add(null, (BValue)relation, flags);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

