/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.transfer.CompTransferResult;
import com.tridium.sys.transfer.ReplacingContext;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.util.ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BWsAnnotation;

public class CompToComp
extends TransferStrategy {
    protected boolean sameSpace;
    protected boolean sameParent;
    protected boolean exact;
    protected boolean exactConfig;
    protected boolean copySource;
    protected boolean keepAllLinks;
    protected boolean keepAllRelations;
    protected BComponent sourceParent;
    protected BObject[] sourceValues;
    protected String[] suggestedNames;
    protected int sourceCount;
    protected BWsAnnotation origin;
    protected BFormat[] insertDisplayNames;
    protected String[] insertNames;
    protected BValue[] insertValues;
    protected Map<Object, Object> handleMap;
    protected BNameMap originalTargetDisplayNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferResult transfer() throws Exception {
        this.init();
        this.load();
        this.name();
        this.annotate();
        this.remapHandles();
        this.relink();
        try {
            this.insert();
        }
        catch (Exception e) {
            String[] origSuggestedNames = this.suggestedNames;
            String[] origInsertNames = this.insertNames;
            int origAction = this.action;
            try {
                this.getTargetSpace().sync();
                if (this.suggestedNames != null && this.suggestedNames.length > 0) {
                    this.suggestedNames = (String[])new Array((Object[])this.suggestedNames).reverse().array();
                }
                if (this.insertNames != null && this.insertNames.length > 0) {
                    this.insertNames = (String[])new Array((Object[])this.insertNames).reverse().array();
                }
                this.action = 16;
                this.makeResult().undo();
            }
            catch (Exception exception) {
            }
            finally {
                this.suggestedNames = origSuggestedNames;
                this.insertNames = origInsertNames;
                this.action = origAction;
            }
            throw e;
        }
        this.remove();
        return this.makeResult();
    }

    public void init() {
        this.sourceValues = this.mark.getValues();
        this.suggestedNames = this.mark.getNames();
        this.sourceCount = this.sourceValues.length;
        this.origin = (BWsAnnotation)this.getParameter("origin", (BObject)null);
        this.sourceParent = this.getSourceParent();
        this.sameParent = this.isSameParent();
        this.sameSpace = this.isSameSpace();
        this.exact = this.getParameter("exact", this.isMove());
        this.exactConfig = this.getParameter("exactConfig", false);
        this.copySource = this.getParameter("copySource", true);
        this.keepAllLinks = this.getParameter("keepAllLinks", false);
        this.keepAllRelations = this.getParameter("keepAllRelations", false);
        if (this.context == null) {
            this.context = new BasicContext();
        }
        if (CompToComp.isDebugOn()) {
            this.dump();
        }
    }

    private BComponent getSourceParent() {
        for (int i = 0; i < this.sourceValues.length; ++i) {
            BObject source = this.sourceValues[i];
            if (!source.isComponent()) continue;
            return (BComponent)source.asComponent().getParent();
        }
        return null;
    }

    private boolean isSameParent() {
        for (int i = 0; i < this.sourceValues.length; ++i) {
            BObject source = this.sourceValues[i];
            if (!source.isComponent() || source.asComponent().getParent() != this.target) continue;
            return true;
        }
        return false;
    }

    private boolean isSameSpace() {
        if (this.sourceParent != null && this.target.isComponent()) {
            return this.sourceParent.getSpace() == this.target.asComponent().getSpace();
        }
        return false;
    }

    protected void load() throws Exception {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("load");
        }
        this.insertValues = new BValue[this.sourceCount];
        System.arraycopy(this.sourceValues, 0, this.insertValues, 0, this.sourceCount);
        if (this.copySource) {
            TransferListenerCopyHints hints = new TransferListenerCopyHints();
            hints.defaultOnClone = !this.exact && !this.exactConfig;
            hints.defaultStatus = this.exactConfig;
            hints.swizzleHandles = true;
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  newCopy: " + hints);
            }
            this.insertValues = BValue.newCopy(this.insertValues, hints);
        }
    }

    protected void name() throws Exception {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("name");
        }
        this.insertNames = (String[])this.suggestedNames.clone();
        this.insertDisplayNames = new BFormat[this.sourceCount];
        HashMap<String, String> dups = new HashMap<String, String>();
        BComponent target = this.target.asComponent();
        BComponentSpace targetSpace = target.getComponentSpace();
        TargetNameContainer nameContainer = new TargetNameContainer(target, dups);
        for (int i = 0; i < this.insertNames.length; ++i) {
            BNameMap map;
            BComplex c;
            BComplex parent;
            String n = this.insertNames[i];
            n = (String)targetSpace.fw(111, n, nameContainer, null, null);
            dups.put(n, n);
            this.insertNames[i] = n;
            if (!this.sourceValues[i].isComplex() || (parent = (c = (BComplex)this.sourceValues[i]).getParent()) == null || (map = (BNameMap)parent.get("displayNames")) == null) continue;
            this.insertDisplayNames[i] = map.get(c.getName());
        }
    }

    public static String getUniqueName(BComponent c, String name) {
        HashMap<String, String> map = new HashMap<String, String>();
        return ObjectUtil.generateUniqueSlotName(name, new TargetNameContainer(c, map));
    }

    protected void annotate() throws Exception {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("annotate");
        }
        if (this.origin != null) {
            this.moveToOrigin();
        } else if (this.sameParent) {
            for (int i = 0; i < this.sourceCount; ++i) {
                this.stagger(this.insertValues[i], 1);
            }
        }
    }

    protected void moveToOrigin() {
        BWsAnnotation original = CompToComp.computeOrigin(this.sourceValues, this.sourceCount);
        int pTrans = this.origin.p - original.p;
        int qTrans = this.origin.q - original.q;
        int auto = 0;
        for (int i = 0; i < this.insertValues.length; ++i) {
            BWsAnnotation anno;
            BComponent iv = (BComponent)this.insertValues[i];
            Property prop = iv.getProperty("wsAnnotation");
            if (prop != null) {
                anno = (BWsAnnotation)iv.get(prop);
                iv.set(prop, (BValue)anno.translate(pTrans, qTrans));
                continue;
            }
            anno = BWsAnnotation.make(this.origin.p + auto, this.origin.q + auto, 8);
            auto += 4;
            iv.add("wsAnnotation", anno);
        }
    }

    public static BWsAnnotation computeOrigin(BObject[] values, int count) {
        int pOrig = Integer.MAX_VALUE;
        int qOrig = Integer.MAX_VALUE;
        for (int i = 0; i < count; ++i) {
            BWsAnnotation anno = (BWsAnnotation)values[i].asComplex().get("wsAnnotation");
            if (anno == null) continue;
            pOrig = Math.min(pOrig, anno.p);
            qOrig = Math.min(qOrig, anno.q);
        }
        if (pOrig == Integer.MAX_VALUE) {
            pOrig = 0;
        }
        if (qOrig == Integer.MAX_VALUE) {
            qOrig = 0;
        }
        return BWsAnnotation.make(pOrig, qOrig);
    }

    protected void stagger(BObject object, int delta) {
        BComplex complex = (BComplex)object;
        Property prop = complex.getProperty("wsAnnotation");
        if (prop != null) {
            BWsAnnotation anno = (BWsAnnotation)complex.get(prop);
            complex.set(prop, (BValue)anno.translate(delta, delta));
        }
    }

    protected void remapHandles() {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("remapHandles");
        }
        ReplacingContext replacingContext = this.context instanceof ReplacingContext && !((ReplacingContext)this.context).handlesEmpty() ? (ReplacingContext)this.context : null;
        ArrayList<Pair<BComponent, BOrd>> list = new ArrayList<Pair<BComponent, BOrd>>();
        for (int i = 0; i < this.insertValues.length; ++i) {
            BValue insertValue = this.insertValues[i];
            if (!insertValue.isComponent()) continue;
            this.listComponents(list, insertValue.asComponent(), replacingContext != null && this.insertNames.length > i ? this.insertNames[i] : null);
        }
        int newHandleCount = 0;
        for (Pair pair : list) {
            if (replacingContext != null && replacingContext.hasHandle((BOrd)pair.getSecond())) continue;
            ++newHandleCount;
        }
        BComponentSpace space = this.getTargetSpace();
        Object[] objectArray = (Object[])space.fw(103, newHandleCount, null, null, null);
        int nextNewHandleIndex = 0;
        this.handleMap = new HashMap<Object, Object>();
        for (Pair pair : list) {
            Object newHandle;
            BComponent component = (BComponent)pair.getFirst();
            BOrd targetOrd = (BOrd)pair.getSecond();
            Object oldHandle = component.getHandle();
            Object object = newHandle = replacingContext == null ? null : replacingContext.removeHandle(targetOrd);
            if (newHandle == null) {
                newHandle = objectArray[nextNewHandleIndex++];
            }
            ((ComponentSlotMap)component.fw(1)).setHandle(newHandle);
            if (oldHandle == null) continue;
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  " + oldHandle + " -> " + newHandle);
            }
            this.handleMap.put(oldHandle, newHandle);
        }
    }

    private void listComponents(List<Pair<BComponent, BOrd>> list, BComponent component, String relativePath) {
        boolean validRelativePath = this.target.isComponent() && relativePath != null && !relativePath.endsWith("?");
        BOrd targetOrd = null;
        if (validRelativePath) {
            targetOrd = BOrd.make(this.target.asComponent().getSlotPath().merge(new SlotPath(relativePath)));
        }
        list.add((Pair<BComponent, BOrd>)new Pair((Object)component, targetOrd));
        SlotCursor<Property> cursor = component.getProperties();
        while (cursor.nextComponent()) {
            this.listComponents(list, cursor.get().asComponent(), validRelativePath ? relativePath + '/' + cursor.property().getName() : null);
        }
    }

    protected BComponentSpace getTargetSpace() {
        return this.target.asComponent().getComponentSpace();
    }

    protected void relink() throws Exception {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("relink");
        }
        for (int i = 0; i < this.sourceCount; ++i) {
            if (!(this.insertValues[i] instanceof BComplex)) continue;
            this.relink((BComplex)this.insertValues[i]);
            if (this.listener == null) continue;
            this.updateStatus("Updating links \"" + CompToComp.toString(this.sourceValues[i]) + "\"...");
        }
    }

    private void relink(BComplex obj) {
        BComplex c = obj;
        Property[] props = c.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            if (prop.getTypeAccess() != 7) continue;
            BValue kid = c.get(prop);
            if (kid instanceof BLink) {
                this.relink((BLink)kid);
                continue;
            }
            if (kid instanceof BRelation) {
                this.relink((BRelation)kid);
                continue;
            }
            if (kid instanceof BOrd) {
                BOrd newOrd = this.relink((BOrd)kid);
                if (newOrd == null) continue;
                c.set(prop, (BValue)newOrd);
                continue;
            }
            if (!(kid instanceof BComplex)) continue;
            this.relink((BComplex)kid);
        }
    }

    private BOrd relink(BOrd ord) {
        BOrd newOrd;
        String ordStr = ord.toString();
        if (!ordStr.startsWith("h:")) {
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  ord not handle: " + ord);
            }
            return null;
        }
        String oldHandle = ordStr.substring(2).trim();
        Object newHandle = this.handleMap.get(oldHandle);
        if (newHandle == null) {
            newOrd = BOrd.make("h:" + ComponentSlotMap.unswizzle(oldHandle));
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  ord unswizzle: " + ord + " -> " + newOrd);
            }
        } else {
            newOrd = BOrd.make("h:" + newHandle);
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  ord remap: " + ord + " -> " + newOrd);
            }
        }
        return newOrd;
    }

    private void relink(BLink link) {
        String ord = link.getSourceOrd().toString();
        if (!ord.startsWith("h:")) {
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  link not handle: " + ord);
            }
            return;
        }
        String oldHandle = ord.substring(2).trim();
        Object newHandle = this.handleMap.get(oldHandle);
        if (newHandle == null) {
            if (this.sameSpace && (this.exact || this.keepAllLinks)) {
                BOrd newOrd = BOrd.make("h:" + ComponentSlotMap.unswizzle(oldHandle));
                if (CompToComp.isDebugOn()) {
                    CompToComp.debug("  link unsizzle: " + ord + " -> " + newOrd);
                }
                link.setSourceOrd(newOrd);
            } else {
                if (CompToComp.isDebugOn()) {
                    CompToComp.debug("  link remove: " + ord);
                }
                BComponent parent = (BComponent)link.getParent();
                parent.remove(link.getPropertyInParent());
                String targetSlotName = link.getTargetSlotName();
                Slot targetSlot = parent.getSlot(targetSlotName);
                if (targetSlot instanceof Property) {
                    Property targetProp = (Property)targetSlot;
                    parent.set(targetProp, targetProp.getDefaultValue().newCopy());
                }
            }
        } else {
            BOrd newOrd = BOrd.make("h:" + newHandle);
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  link remap: " + ord + " -> " + newOrd);
            }
            link.setSourceOrd(newOrd);
        }
    }

    private void relink(BRelation relation) {
        String ord = relation.getSourceOrd().toString();
        if (!ord.startsWith("h:")) {
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  relation not handle: " + ord);
            }
            return;
        }
        String oldHandle = ord.substring(2).trim();
        Object newHandle = this.handleMap.get(oldHandle);
        if (newHandle == null) {
            if (this.sameSpace && (this.exact || this.keepAllRelations)) {
                BOrd newOrd = BOrd.make("h:" + ComponentSlotMap.unswizzle(oldHandle));
                if (CompToComp.isDebugOn()) {
                    CompToComp.debug("  link unsizzle: " + ord + " -> " + newOrd);
                }
                relation.setSourceOrd(newOrd);
            } else {
                if (CompToComp.isDebugOn()) {
                    CompToComp.debug("  relation remove: " + ord);
                }
                BComponent parent = (BComponent)relation.getParent();
                parent.remove(relation.getPropertyInParent());
            }
        } else {
            BOrd newOrd = BOrd.make("h:" + newHandle);
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  relation remap: " + ord + " -> " + newOrd);
            }
            relation.setSourceOrd(newOrd);
        }
    }

    protected void insert() throws Exception {
        BValue displayNames;
        BComponent target;
        Context tx;
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("insert");
        }
        if ((tx = Transaction.start(target = this.target.asComponent(), this.context)) instanceof SyncBuffer) {
            ((SyncBuffer)((Object)tx)).fw(this.listener);
        }
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("  tx: " + tx.getClass().getName());
        }
        this.originalTargetDisplayNames = (displayNames = target.get("displayNames")) instanceof BNameMap ? (BNameMap)displayNames : BNameMap.NULL;
        for (int i = 0; i < this.insertValues.length; ++i) {
            if (this.insertDisplayNames[i] != null) {
                BNameMap nameMap = (BNameMap)target.get("displayNames");
                if (nameMap == null) {
                    nameMap = BNameMap.make(BNameMap.NULL, this.insertNames[i], this.insertDisplayNames[i]);
                    target.add("displayNames", nameMap);
                } else {
                    nameMap = BNameMap.make(nameMap, this.insertNames[i], this.insertDisplayNames[i]);
                    target.set("displayNames", (BValue)nameMap);
                }
            }
            target.add(this.insertNames[i], this.insertValues[i], tx);
            if (this.listener == null) continue;
            this.updateStatus("Inserting \"" + CompToComp.toString(this.sourceValues[i]) + "\"...");
        }
        Transaction.end(target, tx);
    }

    protected void remove() throws Exception {
        if (!this.isMove()) {
            return;
        }
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("remove");
        }
        for (int i = 0; i < this.sourceValues.length; ++i) {
            BComplex child = (BComplex)this.sourceValues[i];
            BComplex parent = child.getParent();
            if (parent == null) continue;
            parent.asComponent().remove(child.getPropertyInParent(), this.context);
        }
    }

    protected TransferResult makeResult() throws Exception {
        return new CompTransferResult(this.action, this.sourceParent, this.suggestedNames, (BComponent)this.target, this.insertNames, this.originalTargetDisplayNames, this.context);
    }

    @Override
    public void dumpExtra() {
        CompToComp.debug("  o source[" + this.sourceCount + "]:");
        for (int i = 0; i < this.sourceCount; ++i) {
            CompToComp.debug("      " + this.suggestedNames[i] + ": " + this.sourceValues[i].toDebugString());
        }
        CompToComp.debug("  o sourceParent: " + this.sourceParent);
        CompToComp.debug("  o sameParent:   " + this.sameParent);
        CompToComp.debug("  o exact:        " + this.exact);
        CompToComp.debug("  o copySource:   " + this.copySource);
        CompToComp.debug("  o origin:       " + this.origin);
        CompToComp.debug("  o exact:        " + this.exact);
    }

    class TransferListenerCopyHints
    extends CopyHints
    implements TransferListener {
        TransferListenerCopyHints() {
        }

        @Override
        public void updateStatus(String msg) {
            CompToComp.this.updateStatus(msg);
        }
    }

    public static class TargetNameContainer
    implements ObjectUtil.NameContainer {
        BComponent target;
        Map<String, String> dups;

        public TargetNameContainer(BComponent target, Map<String, String> dups) {
            this.target = target;
            this.dups = dups;
        }

        @Override
        public boolean contains(String name) {
            return this.target.asComponent().getSlot(name) != null || this.dups.get(name) != null;
        }
    }
}

