/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.test;

import com.tridium.sys.Nre;
import com.tridium.sys.registry.NRegistry;
import com.tridium.util.CommandLineArguments;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;

public class TestWatcher {
    private static TestWatcher INSTANCE;
    private static final ModulesDirtyMonitor dirtyMonitor;
    private ThreadPoolExecutor testRunExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardOldestPolicy());
    private ITestRunner testRunner = new DefaultTestRunner();
    private DirectoryWatcher watcher;
    private CommandLineArguments testArgs;

    private TestWatcher() {
    }

    public static TestWatcher getInstance() {
        return INSTANCE == null ? (INSTANCE = new TestWatcher()) : INSTANCE;
    }

    public void setTestArgs(CommandLineArguments args) {
        this.testArgs = args;
        if (this.testArgs != null) {
            System.out.println("Tests will be run with the following arguments:");
            for (String parameter : this.testArgs.parameters) {
                System.out.print(parameter + " ");
            }
            for (int i = 0; i < this.testArgs.options.length; ++i) {
                System.out.print("-" + this.testArgs.options[i]);
                if (this.testArgs.optionValues[i] != null) {
                    System.out.print(":" + this.testArgs.optionValues[i]);
                }
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    public void setTestArgs(String ... testArgs) {
        if (testArgs != null) {
            this.setTestArgs(new CommandLineArguments(testArgs));
        }
    }

    public void runTests() {
        if (this.testArgs != null) {
            this.runTests(this.testArgs);
        }
    }

    public void runTests(String ... args) {
        CommandLineArguments commandLineArguments = args.length == 0 ? this.testArgs : new CommandLineArguments(args);
        this.runTests(commandLineArguments);
    }

    public void start() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
        this.watcher = new DirectoryWatcher();
        this.watcher.addModifyHandler(p -> {
            dirtyMonitor.setDirty(true);
            this.testRunExecutor.execute(() -> {
                if (!dirtyMonitor.isDirty()) {
                    return;
                }
                System.out.println("modified: " + p + ", running tests");
                while (dirtyMonitor.isDirty()) {
                    dirtyMonitor.setDirty(false);
                    ((NRegistry)Sys.getRegistry()).syncModules();
                }
                this.runTests();
            });
        });
        this.watcher.start();
    }

    CommandLineArguments getTestArgs() {
        return this.testArgs;
    }

    void setTestRunner(ITestRunner testRunner) {
        this.testRunner = testRunner;
    }

    private void runTests(CommandLineArguments args) {
        long start = new Date().getTime();
        try {
            this.testRunner.runTests(args);
            System.out.println("Test run completed in " + (new Date().getTime() - start) + "ms.");
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e);
        }
    }

    static {
        dirtyMonitor = new ModulesDirtyMonitor();
    }

    private static class DefaultTestRunner
    implements ITestRunner {
        private DefaultTestRunner() {
        }

        @Override
        public void runTests(CommandLineArguments args) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            Method run = DefaultTestRunner.getTestRunnerClass().getDeclaredMethod("runTests", CommandLineArguments.class, Boolean.TYPE);
            run.invoke(DefaultTestRunner.getTestRunnerClass(), args, true);
        }

        private static Class<?> getTestRunnerClass() throws ClassNotFoundException {
            return Sys.loadModule("test").loadClass("javax.baja.test.TestRunner");
        }
    }

    private static class ModulesDirtyMonitor {
        private boolean dirty;

        private ModulesDirtyMonitor() {
        }

        synchronized boolean isDirty() {
            return this.dirty;
        }

        synchronized void setDirty(boolean dirty) {
            this.dirty = dirty;
        }
    }

    private static class DirectoryWatcher {
        private WatchService watcher;
        private Map<WatchKey, Path> keys;
        private boolean recursive;
        private List<FileModifyHandler> handlers = new ArrayList<FileModifyHandler>();

        private DirectoryWatcher() {
        }

        public void addModifyHandler(FileModifyHandler handler) {
            this.handlers.add(handler);
        }

        private void start() {
            this.start(Paths.get(Nre.niagaraHome + "/modules", new String[0]), false);
        }

        private void start(Path dir, boolean recursive) {
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
                this.keys = new HashMap<WatchKey, Path>();
                this.recursive = recursive;
                if (recursive) {
                    this.registerAll(dir);
                } else {
                    this.register(dir);
                }
                this.processEvents();
            }
            catch (IOException e) {
                throw new BajaRuntimeException(e);
            }
        }

        static <T> WatchEvent<T> cast(WatchEvent<?> event) {
            return event;
        }

        private void processEvents() {
            new Thread("TestWatcher.DirectoryWatcher"){

                @Override
                public void run() {
                    while (true) {
                        WatchKey key;
                        try {
                            key = watcher.take();
                        }
                        catch (InterruptedException | ClosedWatchServiceException e) {
                            return;
                        }
                        Path dir = (Path)keys.get(key);
                        if (dir == null) {
                            System.err.println("WatchKey not recognized!!");
                            continue;
                        }
                        for (WatchEvent<?> event : key.pollEvents()) {
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                            WatchEvent ev = DirectoryWatcher.cast(event);
                            Path name = (Path)ev.context();
                            Path child = dir.resolve(name);
                            handlers.stream().forEach(h -> CompletableFuture.runAsync(() -> h.onModified(child)));
                            if (!recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                            try {
                                if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                                this.registerAll(child);
                            }
                            catch (IOException iOException) {}
                        }
                        boolean valid = key.reset();
                        if (valid) continue;
                        keys.remove(key);
                        if (keys.isEmpty()) break;
                    }
                }
            }.start();
        }

        private void stop() {
            try {
                if (this.watcher != null) {
                    this.watcher.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void registerAll(Path start) throws IOException {
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.register(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private void register(Path dir) throws IOException {
            WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.keys.put(key, dir);
        }

        private static interface FileModifyHandler {
            public void onModified(Path var1);
        }
    }

    public static interface ITestRunner {
        public void runTests(CommandLineArguments var1) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException;
    }
}

