/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;

public class SystemPropertiesSpy
extends Spy {
    @Override
    public void write(SpyWriter out) throws IOException {
        AccessController.doPrivileged(() -> {
            ArrayList<Pair> pairs = new ArrayList<Pair>();
            Set<String> keySet = System.getProperties().stringPropertyNames();
            for (String strKey : keySet) {
                Pair pair = new Pair();
                pair.key = strKey;
                pair.value = AccessController.doPrivileged(() -> System.getProperty(strKey));
                pairs.add(pair);
            }
            Collections.sort(pairs);
            out.startProps("System Properties");
            for (Pair pairValue : pairs) {
                out.prop((Object)pairValue.key, pairValue.value);
            }
            out.endProps();
            return null;
        });
    }

    static class Pair
    implements Comparable<Pair> {
        String key;
        String value;

        Pair() {
        }

        @Override
        public int compareTo(Pair o) {
            return this.key.compareTo(o.key);
        }
    }
}

