/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public abstract class CacheSpy
extends SpyDir {
    private final String displayName;
    private final String path;
    private static final Logger LOGGER = Logger.getLogger("niagara.spy");

    protected CacheSpy(String displayName, String path) {
        this.add("clearCache", new ClearCacheSpy());
        this.displayName = displayName;
        this.path = path;
    }

    protected abstract void clearCache() throws Exception;

    @Override
    public Spy find(String name) {
        if (SpyWriter.verifyNameAndCsrfToken(name, "clearCache")) {
            return super.find("clearCache");
        }
        return super.find(name);
    }

    @Override
    public void write(SpyWriter out) throws Exception {
        out.w("<b>").mutatorButton(this.path + '/' + "clearCache", "Clear Cache").w("</b><br/><br/>");
    }

    class ClearCacheSpy
    extends SpyDir {
        ClearCacheSpy() {
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            try {
                CacheSpy.this.clearCache();
                out.w("<b>").safe(CacheSpy.this.displayName).w(" Clear Cache Complete</b>");
                out.w("<br/>");
            }
            catch (Exception e) {
                out.w("<b>").safe(CacheSpy.this.displayName).w(" Clear Cache Failed</b>");
                out.w("<br/>");
                out.w("<p>").safe(e.getMessage()).w("</p>");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.WARNING, CacheSpy.this.displayName + " Cache Clear failed", e);
                }
                LOGGER.log(Level.WARNING, CacheSpy.this.displayName + " Cache Clear failed");
            }
            out.w("<br/>");
            out.w("<b><a ").attr("href", CacheSpy.this.path).w("'>return to ").safe(CacheSpy.this.displayName).w("</a></b>");
        }
    }
}

