/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.service;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.sys.station.Station;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySourceService;
import javax.baja.job.BIJobService;
import javax.baja.job.BJob;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BServiceContainer;

public class ServiceManager {
    public static int jobMaxCountPerType = 3;
    public static long jobMinAgeToKeep = 600000L;
    static final Logger log = Logger.getLogger("sys.service");
    private final Map<String, BComponent[]> byKey = new ConcurrentHashMap<String, BComponent[]>();
    private final Map<BComponent, BComponent> byComp = new ConcurrentHashMap<BComponent, BComponent>();
    private boolean servicesRunning;
    private BComponentSpace dataRecoverySpace = null;
    private BIDataRecoveryService dataRecoveryService = null;
    private BDataRecoveryComponentRecorder dataRecoveryRecorder = null;
    private boolean dataRecoveryRunning;
    private boolean dataRecoverySourcesInitialized = false;
    private volatile boolean migratingServiceContainer = false;
    private volatile BComponent illegalService = null;
    private final List<ServiceListener> listeners = new ArrayList<ServiceListener>();
    private final Map<BComponent, CompletableFuture<Void>> startedByComp = new HashMap<BComponent, CompletableFuture<Void>>();
    private final Map<BComponent, CompletableFuture<Void>> stoppedByComp = new HashMap<BComponent, CompletableFuture<Void>>();

    public BComponent[] getAllServices() {
        return this.byComp.values().toArray(new BComponent[0]);
    }

    public <S extends BComponent> S getService(String typeSpec) throws ServiceNotFoundException {
        BComponent[] match = this.byKey.get(typeSpec);
        if (match == null) {
            throw new ServiceNotFoundException(typeSpec);
        }
        BComponent comp = match[0];
        return (S)comp;
    }

    public Optional<BIService> findService(String typeSpec) {
        BComponent[] match = this.byKey.get(typeSpec);
        if (match == null) {
            return Optional.empty();
        }
        return Optional.of((BIService)((Object)match[0]));
    }

    public BComponent[] getServices(String typeSpec) throws ServiceNotFoundException {
        BComponent[] match = this.byKey.get(typeSpec);
        if (match == null) {
            throw new ServiceNotFoundException(typeSpec);
        }
        BComponent[] copy = new BComponent[match.length];
        System.arraycopy(match, 0, copy, 0, match.length);
        return copy;
    }

    public synchronized void clearAllServices() {
        this.byKey.clear();
        this.byComp.clear();
        this.startedByComp.clear();
        this.stoppedByComp.clear();
        this.servicesRunning = false;
    }

    public synchronized <S extends BComponent> void register(S service) {
        if (service.getComponentSpace() != Station.space) {
            return;
        }
        Type[] types = ((BIService)((Object)service)).getServiceTypes();
        if (types == null) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            BComponent[] array;
            Type type = types[i];
            String typeSpec = type.toString();
            if (!type.getTypeClass().isInstance(service)) {
                log.severe("Component " + service.getType() + " not instanceof " + typeSpec);
                continue;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Register: " + service + " {" + typeSpec + "}");
            }
            if ((array = this.byKey.get(typeSpec)) == null) {
                array = new BComponent[]{service};
            } else {
                BComponent[] temp = new BComponent[array.length + 1];
                System.arraycopy(array, 0, temp, 0, array.length);
                temp[array.length] = service;
                array = temp;
            }
            this.byKey.put(typeSpec, array);
            this.byComp.put(service, service);
            this.startedByComp.put(service, new CompletableFuture());
            this.stoppedByComp.put(service, new CompletableFuture());
        }
        if (this.dataRecoverySourcesInitialized && service instanceof BIDataRecoverySourceService) {
            try {
                BIDataRecoveryService cds = (BIDataRecoveryService)this.getService("baja:IDataRecoveryService");
                if (cds != null && cds.isEnabled()) {
                    ((BIDataRecoverySourceService)((Object)service)).initDataRecoverySource(cds);
                }
            }
            catch (ServiceNotFoundException cds) {
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error during initialization of data recovery source for service " + service, t);
            }
        }
        if (this.servicesRunning && (!this.migratingServiceContainer || Station.stationStarted)) {
            this.startService(service);
        }
    }

    public synchronized <S extends BComponent> void unregister(S service) {
        Type[] types;
        if (service.getComponentSpace() != Station.space) {
            return;
        }
        if (this.servicesRunning && (!this.migratingServiceContainer || Station.stationStarted)) {
            this.stopService(service);
        }
        if ((types = ((BIService)((Object)service)).getServiceTypes()) == null) {
            return;
        }
        block0: for (int i = 0; i < types.length; ++i) {
            String typeSpec = types[i].toString();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unregister: " + service + " {" + typeSpec + "}");
            }
            this.byComp.remove(service);
            this.startedByComp.remove(service);
            this.stoppedByComp.remove(service);
            BComponent[] old = this.byKey.get(typeSpec);
            if (old == null) {
                return;
            }
            int len = old.length;
            if (len == 1 && service == old[0]) {
                this.byKey.remove(typeSpec);
                continue;
            }
            for (int j = 0; j < len; ++j) {
                if (service != old[j]) continue;
                BComponent[] replace = new BComponent[len - 1];
                System.arraycopy(old, 0, replace, 0, j);
                System.arraycopy(old, j + 1, replace, j, len - j - 1);
                this.byKey.put(typeSpec, replace);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <S extends BComponent> void startAllServices() {
        this.servicesRunning = true;
        if (!this.dataRecoveryRunning) {
            this.startDataRecoveryService();
        }
        ArrayList<BComponent> startedServices = new ArrayList<BComponent>();
        if (this.dataRecoveryService != null) {
            startedServices.add((BComponent)((Object)this.dataRecoveryService));
        }
        try {
            BComponent[] serviceContainers;
            for (BComponent serviceContainer : serviceContainers = this.getServices("baja:ServiceContainer")) {
                try {
                    ((BServiceContainer)serviceContainer).checkParentForRestrictedComponent(serviceContainer.getParent().asComponent(), null);
                }
                catch (Throwable t) {
                    try {
                        startedServices.add(serviceContainer);
                        this.migratingServiceContainer = true;
                        BComponent svcContainerTemp = serviceContainer;
                        this.startService(svcContainerTemp);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.migratingServiceContainer = false;
                    }
                }
            }
        }
        catch (ServiceNotFoundException serviceContainers) {
            // empty catch block
        }
        BComponent[] services = this.getAllServices();
        for (int i = 0; i < services.length; ++i) {
            if (startedServices.contains(services[i])) continue;
            BComponent svcTemp = services[i];
            this.startService(svcTemp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends BComponent> void stopAllServices() {
        BComponent[] services;
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            this.servicesRunning = false;
            services = this.getAllServices();
        }
        for (int i = 0; i < services.length; ++i) {
            if (services[i] == this.dataRecoveryService) continue;
            BComponent service = services[i];
            this.stopService(service);
        }
        this.stopDataRecoveryService();
    }

    public synchronized <S extends BComponent> BIDataRecoveryService startDataRecoveryService() {
        this.dataRecoveryRunning = true;
        try {
            S service = this.getService("baja:IDataRecoveryService");
            if (!((BIDataRecoveryService)service).isEnabled()) {
                this.dataRecoveryService = null;
                return this.dataRecoveryService;
            }
            this.startService(service);
            this.dataRecoveryService = (BIDataRecoveryService)service;
            return this.dataRecoveryService;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return null;
        }
    }

    public synchronized <S extends BComponent> void stopDataRecoveryService() {
        this.dataRecoveryRunning = false;
        if (this.dataRecoveryService != null) {
            BComponent service = (BComponent)((Object)this.dataRecoveryService);
            this.stopService(service);
            this.dataRecoveryService = null;
            this.dataRecoverySpace = null;
            this.dataRecoveryRecorder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends BComponent> void startService(S service) {
        if (!service.getType().is(BServiceContainer.TYPE) && service.getType().is(BIRestrictedComponent.TYPE)) {
            try {
                ((BIRestrictedComponent)((Object)service)).checkParentForRestrictedComponent(service.getParent().asComponent(), null);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Unable to start duplicate restricted service: " + service.toDisplayPathString(null) + ". This service will be removed.", t);
                this.illegalService = service;
                try {
                    service.getParent().asComponent().remove(service);
                }
                finally {
                    this.illegalService = null;
                }
                return;
            }
        }
        String str = "???";
        try {
            str = service.toString();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Start Service: " + str);
            }
            service.fw(15, null, null, null, null);
            ((BIService)((Object)service)).serviceStarted();
            if (this.servicesRunning && service instanceof BIDataRecoveryService && this.dataRecoveryService == null && ((BIDataRecoveryService)((Object)service)).isEnabled()) {
                this.initDataRecoveryComponentRecorder((BIDataRecoveryService)((Object)service));
            }
            if (!((BIService)((Object)service)).completesStarted()) {
                ((BIService)((Object)service)).whenServiceStarted().complete(null);
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Service start failed: " + str, e);
            if (!((BIService)((Object)service)).completesStarted()) {
                ((BIService)((Object)service)).whenServiceStarted().completeExceptionally(e);
            }
        }
        finally {
            try {
                if (this.servicesRunning) {
                    this.fireServiceEvent(new BServiceEvent(0, (BIService)((Object)service)));
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Could not notify ServiceListeners of serviceAdded event for service " + service, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends BComponent> void stopService(S service) {
        if (service == this.illegalService) {
            return;
        }
        String str = "???";
        try {
            str = service.toString();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Stop Service: " + str);
            }
            service.fw(16, null, null, null, null);
            ((BIService)((Object)service)).serviceStopped();
            if (service == this.dataRecoveryService) {
                this.dataRecoveryService = null;
                this.dataRecoverySpace = null;
                this.dataRecoveryRecorder = null;
            }
            if (!((BIService)((Object)service)).completesStopped()) {
                ((BIService)((Object)service)).whenServiceStopped().complete(null);
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Service stop failed: " + str, e);
            if (!((BIService)((Object)service)).completesStopped()) {
                ((BIService)((Object)service)).whenServiceStopped().completeExceptionally(e);
            }
        }
        finally {
            try {
                if (this.servicesRunning) {
                    this.fireServiceEvent(new BServiceEvent(1, (BIService)((Object)service)));
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Could not notify ServiceListeners of serviceRemoved event for service " + service, t);
            }
        }
    }

    public void initDataRecoverySourceServices(BIDataRecoveryService cds) {
        this.dataRecoverySourcesInitialized = true;
        try {
            BComponent[] services = this.getAllServices();
            int len = services != null ? services.length : 0;
            for (int i = 0; i < len; ++i) {
                try {
                    if (!(services[i] instanceof BIDataRecoverySourceService)) continue;
                    ((BIDataRecoverySourceService)((Object)services[i])).initDataRecoverySource(cds);
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Error during initialization of data recovery source for service " + services[i], e);
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public static void houseKeeping(BIJobService service) {
        BComponent container = (BComponent)((Object)service);
        BJob[] jobs = service.getJobs();
        HashMap<String, Array> byType = new HashMap<String, Array>();
        for (int i = 0; i < jobs.length; ++i) {
            BJob job = jobs[i];
            String key = job.getType().toString();
            Array bucket = (Array)byType.get(key);
            if (bucket == null) {
                bucket = new Array(BJob.class);
                byType.put(key, bucket);
            }
            bucket.add((Object)job);
        }
        for (Array bucket : byType.values()) {
            ServiceManager.cleanupJobs(container, (Array<BJob>)bucket);
        }
    }

    static void cleanupJobs(BComponent container, Array<BJob> bucket) {
        while (bucket.size() > jobMaxCountPerType) {
            BJob oldest = null;
            for (int i = 0; i < bucket.size(); ++i) {
                long age;
                BJob job = (BJob)bucket.get(i);
                BAbsTime end = job.getEndTime();
                if (!job.getJobState().isComplete() || end.isNull() || (age = Clock.millis() - end.getMillis()) < jobMinAgeToKeep || oldest != null && !end.isBefore(oldest.getEndTime())) continue;
                oldest = job;
            }
            if (oldest == null) {
                return;
            }
            container.remove(oldest);
            bucket.remove(oldest);
        }
    }

    private void initDataRecoveryComponentRecorder(BIDataRecoveryService service) {
        this.dataRecoveryService = service;
        BDataRecoveryComponentRecorder recorder = (BDataRecoveryComponentRecorder)((BObject)((Object)service)).getAgents().filter(AgentFilter.is(BDataRecoveryComponentRecorder.TYPE)).getDefault().getInstance();
        recorder.setDataRecoveryService(service);
        this.addDataRecoveryComponentRecorder(service, recorder);
    }

    public void addDataRecoveryComponentRecorder(BIDataRecoveryService service, BDataRecoveryComponentRecorder recorder) {
        if (service == this.dataRecoveryService) {
            this.dataRecoverySpace = ((BComponent)((Object)service)).getComponentSpace();
            this.dataRecoveryRecorder = recorder;
        }
    }

    public BDataRecoveryComponentRecorder getDataRecoveryComponentRecorder(BComponentSpace space) {
        if (space == this.dataRecoverySpace) {
            return this.dataRecoveryRecorder;
        }
        return null;
    }

    public BIDataRecoveryService getActiveDataRecoveryService() {
        return this.dataRecoveryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceListener[] getServiceListeners() {
        ServiceListener[] r = null;
        List<ServiceListener> list = this.listeners;
        synchronized (list) {
            r = this.listeners.toArray(new ServiceListener[0]);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener) {
        List<ServiceListener> list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != listener) continue;
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        List<ServiceListener> list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != listener) continue;
                this.listeners.remove(i);
                break;
            }
        }
    }

    public void fireServiceEvent(BServiceEvent event) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Firing service event " + event);
        }
        ServiceListener[] x = this.getServiceListeners();
        for (int i = 0; i < x.length; ++i) {
            try {
                x[i].serviceEvent(event);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Error notifying ServiceListener '" + x[i] + "' of service event " + event, e);
            }
        }
    }

    public CompletableFuture<Void> defaultWhenServiceStarted(BIService service) {
        if (service instanceof BComponent && this.startedByComp.containsKey(service)) {
            return this.startedByComp.get(service);
        }
        throw new ServiceNotFoundException();
    }

    public CompletableFuture<Void> defaultWhenServiceStopped(BIService service) {
        if (service instanceof BComponent && this.stoppedByComp.containsKey(service)) {
            return this.stoppedByComp.get(service);
        }
        throw new ServiceNotFoundException();
    }

    public void postInit() {
        Nre.spySysManagers.add("serviceManager", new Page());
    }

    public class Page
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            if (ServiceManager.this.byComp.size() == 0) {
                out.write("No services registered");
                return;
            }
            out.startTable(true);
            out.trTitle("Registered Services", 2);
            for (Map.Entry entry : ServiceManager.this.byKey.entrySet()) {
                BComponent[] services = (BComponent[])entry.getValue();
                out.w("<tr>").th(entry.getKey()).td(services[0].toPathString()).w("</tr>\n");
                for (int i = 1; i < services.length; ++i) {
                    out.w("<tr>").td("&nbsp;").td(services[i].toPathString()).w("</tr>\n");
                }
            }
            out.endTable();
        }
    }
}

