/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.EnumIntrospector;
import com.tridium.sys.schema.EnumType;
import com.tridium.sys.schema.SyntheticEnumType;
import com.tridium.util.jar.ModuleEntry;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class SyntheticEnumIntrospector
extends EnumIntrospector {
    public SyntheticEnumIntrospector(int id, Class<?> cls) {
        super(id, cls);
    }

    @Override
    Type introspect() throws Exception {
        int mods = this.cls.getModifiers();
        if (!Modifier.isFinal(mods) && !Modifier.isAbstract(mods)) {
            throw this.err("BFrozenEnum subclasses must be declared final or abstract");
        }
        this.mapEnums();
        int[] ords = new int[this.count];
        System.arraycopy(this.ordinals, 0, ords, 0, this.count);
        return new SyntheticEnumType(this, this.def, ords, this.byOrdinal, this.byTag, this.cls);
    }

    @Override
    protected void mapEnums() throws Exception {
        NModule nmodule = AccessController.doPrivileged(() -> Nre.getModuleManager()).getModuleForClass(this.cls);
        if (nmodule.moduleFile != null) {
            ModuleEntry entry = nmodule.moduleFile.getJarEntry("META-INF/module.xml");
            if (entry == null) {
                entry = nmodule.moduleFile.getJarEntry("meta-inf/module.xml");
            }
            if (entry == null) {
                throw new ModuleException("Module missing META-INF/module.xml: " + nmodule.moduleFile.getFile());
            }
            XElem manifest = XParser.make((InputStream)new BufferedInputStream(entry.getInputStream())).parse();
            if (manifest.elem("types") != null) {
                XElem[] types = manifest.elem("types").elems("type");
                for (int i = 0; i < types.length; ++i) {
                    XElem entriessElem;
                    if (!types[i].get("name").equals(this.typeName) || (entriessElem = types[i].elem("entries")) == null) continue;
                    XElem[] entryXElem = entriessElem.elems("entry");
                    for (int j = 0; j < entryXElem.length; ++j) {
                        BFrozenEnum value;
                        String name = entryXElem[j].get("name");
                        int ordinal = entryXElem[j].geti("ordinal");
                        this.ordinals[this.count++] = ordinal;
                        if (this.byOrdinal.get(ordinal) != null) {
                            throw this.err("Duplicate ordinal " + ordinal);
                        }
                        try {
                            Constructor cntr = this.cls.getConstructor(Integer.TYPE);
                            value = (BFrozenEnum)cntr.newInstance(ordinal);
                        }
                        catch (NoSuchMethodException nsme) {
                            throw new BajaRuntimeException("Missing enumeration constructor.", nsme);
                        }
                        catch (InvocationTargetException ite) {
                            throw new BajaRuntimeException("Unable to create enumeration instance.", ite);
                        }
                        catch (IllegalAccessException iae) {
                            throw new BajaRuntimeException("Unable to create enumeration instance.", iae);
                        }
                        catch (InstantiationException ie) {
                            throw new BajaRuntimeException("Unable to create enumeration instance.", ie);
                        }
                        if (this.def == null) {
                            this.def = value;
                        }
                        EnumType.Entry entry2 = new EnumType.Entry(ordinal, name, value);
                        this.byOrdinal.put(ordinal, (Object)entry2);
                        this.byTag.put(name, entry2);
                    }
                    break;
                }
            }
        }
    }
}

