/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.Introspector;
import com.tridium.sys.schema.SimpleType;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BSimple;
import javax.baja.sys.Type;

class SimpleIntrospector
extends Introspector {
    static Map<String, Character> dataTypes = new HashMap<String, Character>();

    SimpleIntrospector(int id, Class<?> cls) {
        super(id, cls);
    }

    @Override
    Type introspect() throws Exception {
        if (!this.isAbstract && !Modifier.isFinal(this.cls.getModifiers())) {
            throw this.err("Concrete BSimples must be declared final");
        }
        if (BIDataValue.class.isAssignableFrom(this.cls) && !this.isAbstract && !dataTypes.containsKey(this.cls.getName())) {
            throw this.err(this.cls.getName() + " does not fulfill BIDataValue contract");
        }
        return new SimpleType(this, (BSimple)this.getConstantFieldObject("DEFAULT"), SimpleIntrospector.getDataTypeSymbol(this.cls));
    }

    static char getDataTypeSymbol(Class<?> cls) {
        Character symbol = dataTypes.get(cls.getName());
        if (symbol == null) {
            return '\u0000';
        }
        return symbol.charValue();
    }

    static {
        dataTypes.put("javax.baja.sys.BBoolean", Character.valueOf('b'));
        dataTypes.put("javax.baja.sys.BInteger", Character.valueOf('i'));
        dataTypes.put("javax.baja.sys.BLong", Character.valueOf('l'));
        dataTypes.put("javax.baja.sys.BFloat", Character.valueOf('f'));
        dataTypes.put("javax.baja.sys.BDouble", Character.valueOf('d'));
        dataTypes.put("javax.baja.sys.BString", Character.valueOf('s'));
        dataTypes.put("javax.baja.sys.BDynamicEnum", Character.valueOf('e'));
        dataTypes.put("javax.baja.sys.BEnumRange", Character.valueOf('E'));
        dataTypes.put("javax.baja.sys.BAbsTime", Character.valueOf('a'));
        dataTypes.put("javax.baja.sys.BRelTime", Character.valueOf('r'));
        dataTypes.put("javax.baja.timezone.BTimeZone", Character.valueOf('z'));
        dataTypes.put("javax.baja.units.BUnit", Character.valueOf('u'));
        dataTypes.put("javax.baja.naming.BOrd", Character.valueOf('o'));
        dataTypes.put("javax.baja.sys.BMarker", Character.valueOf('m'));
    }
}

