/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.Utils;
import java.lang.reflect.Modifier;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class NProperty
extends NSlot
implements Property {
    public static final int TYPE_FINAL = 1;
    public BValue value;
    Class<?> typeClass;
    Type type;
    int typeAccess = -1;
    int propertyFlags;

    public NProperty(int flags, BValue value, BFacets facets) {
        super(null, flags, facets, true);
        this.value = value;
    }

    public NProperty(String name, int flags, BValue value, BFacets facets) {
        this(name, flags, value, facets, false);
    }

    public NProperty(String name, int flags, BValue value, BFacets facets, boolean frozen) {
        super(name, flags, facets, frozen);
        this.value = value;
        this.type = value.getType();
        this.typeClass = value.getClass();
        this.typeAccess = Utils.getTypeAccess(this.typeClass);
        this.init();
    }

    void init() {
        if (Modifier.isFinal(this.typeClass.getModifiers())) {
            this.propertyFlags |= 1;
        }
    }

    @Override
    public final boolean isProperty() {
        return true;
    }

    @Override
    public boolean isAction() {
        return false;
    }

    @Override
    public boolean isTopic() {
        return false;
    }

    @Override
    public final Property asProperty() {
        return this;
    }

    @Override
    public Action asAction() {
        throw new ClassCastException();
    }

    @Override
    public Topic asTopic() {
        throw new ClassCastException();
    }

    @Override
    public final int getTypeAccess() {
        return this.typeAccess;
    }

    @Override
    public final BValue getDefaultValue() {
        return this.value.newCopy(true);
    }

    @Override
    public final boolean isEquivalentToDefaultValue(BValue obj) {
        return this.value.equivalent(obj);
    }

    @Override
    public final Type getType() {
        if (this.type == null) {
            this.type = Sys.getType(this.typeClass);
        }
        return this.type;
    }

    public final Type getType(BObject target) {
        return this.getType();
    }

    @Override
    public final boolean isTypeFinal() {
        return (this.propertyFlags & 1) != 0;
    }

    boolean equivalent(NProperty prop) {
        if (!super.equivalent(prop)) {
            return false;
        }
        return this.value.equivalent(prop.value);
    }

    @Override
    void copyFrom(NSlot slot) {
        super.copyFrom(slot);
        NProperty prop = (NProperty)slot;
        this.type = prop.type;
        this.typeClass = prop.typeClass;
        this.typeAccess = prop.typeAccess;
        this.propertyFlags = prop.propertyFlags;
    }

    public String toString() {
        return this.name + ": " + this.getType();
    }
}

