/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.resource;

import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceManager;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.Sys;

public class ResourceReport
implements Cloneable {
    int[] cpu;
    int[] mem;
    private int totalMem;
    private final HashMap<String, String> props = new HashMap();
    private int numComps;
    private String platStationFault;

    public int[] cpu() {
        return this.cpu;
    }

    public int[] mem() {
        return this.mem;
    }

    public int totalMem() {
        return this.totalMem;
    }

    public String platStationFault() {
        return this.platStationFault;
    }

    public String[] props() {
        return this.props.keySet().toArray(new String[0]);
    }

    public String prop(String key) {
        return this.props.get(key);
    }

    public final void put(String key, String value) {
        this.props.put(key, value);
    }

    void generate(ResourceManager mgr) {
        BIPlatform platform = Nre.getPlatform();
        this.totalMem = platform.getTotalMemory();
        this.put("mem.used", ResourceReport.memstr(platform.getMemoryUsage()));
        this.put("mem.total", ResourceReport.memstr(this.totalMem));
        long heapTotal = Runtime.getRuntime().totalMemory() / 1024L;
        long heapFree = Runtime.getRuntime().freeMemory() / 1024L;
        long heapMax = Runtime.getRuntime().maxMemory() / 1024L;
        this.put("heap.total", ResourceReport.memstr(heapTotal));
        this.put("heap.free", ResourceReport.memstr(heapFree));
        this.put("heap.max", ResourceReport.memstr(heapMax));
        this.put("component.count", "" + Sys.getStation().getComponentSpace().getComponentCount());
        AccessController.doPrivileged(() -> {
            this.put("version.niagara", "" + Sys.getBajaVersion());
            this.put("version.java", System.getProperty("java.vm.name") + ' ' + System.getProperty("java.vm.version"));
            this.put("version.os", System.getProperty("os.arch") + ' ' + System.getProperty("os.name") + ' ' + System.getProperty("os.version"));
            return null;
        });
        if (Metrics.isUsingCapacityLicensing()) {
            Metrics.writeToResourceReport(this);
        }
        this.platStationFault = platform.checkForStationFault();
        platform.queryResources(this);
    }

    public static String memstr(long kb) {
        if (kb < 1024L) {
            return kb + " KB";
        }
        return kb / 1024L + " MB";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    public byte[] encode() throws Exception {
        ByteBuffer buf = new ByteBuffer(1024);
        int numReadings = this.cpu.length;
        buf.writeUTF("startReport");
        buf.writeInt(1);
        buf.writeUTF("");
        buf.writeInt(this.totalMem);
        buf.writeInt(0);
        buf.writeInt(0);
        buf.writeInt(0);
        buf.writeInt(0);
        buf.writeInt(numReadings);
        for (int i = 0; i < numReadings; ++i) {
            buf.writeByte(this.cpu[i]);
            buf.writeInt(this.mem[i]);
        }
        String[] props = this.props();
        buf.writeInt(props.length);
        for (String prop : props) {
            buf.writeUTF(prop);
            buf.writeUTF(this.prop(prop));
        }
        buf.writeUTF("endReport");
        return buf.toByteArray();
    }

    public static ResourceReport decode(byte[] bytes) throws Exception {
        ByteBuffer buf = new ByteBuffer(bytes);
        ResourceReport r = new ResourceReport();
        if (!buf.readUTF().equals("startReport")) {
            throw new IOException();
        }
        int version = buf.readInt();
        if (version != 1) {
            throw new IOException();
        }
        buf.readUTF();
        r.totalMem = buf.readInt();
        buf.readInt();
        buf.readInt();
        buf.readInt();
        int numCats = buf.readInt();
        for (int i = 0; i < numCats; ++i) {
            buf.readUTF();
            buf.readInt();
        }
        int numReadings = buf.readInt();
        r.cpu = new int[numReadings];
        r.mem = new int[numReadings];
        for (int i = 0; i < numReadings; ++i) {
            r.cpu[i] = buf.readByte();
            r.mem[i] = buf.readInt();
        }
        int numProps = buf.readInt();
        for (int i = 0; i < numProps; ++i) {
            String key = buf.readUTF();
            String val = buf.readUTF();
            r.props.put(key, val);
        }
        if (!buf.readUTF().equals("endReport")) {
            throw new IOException();
        }
        return r;
    }

    static class Category {
        String key;
        int usage;

        Category(String key) {
            this.key = key;
        }

        Category(String key, int usage) {
            this.key = key;
            this.usage = usage;
        }
    }
}

