/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BModuleNavNode
extends BNavContainer {
    @Generated
    public static final Type TYPE = Sys.loadType(BModuleNavNode.class);
    private static final BIcon ERROR_ICON = BIcon.make(BIcon.std("module.png"), BIcon.std("badges/error.png"));
    public final String moduleName;
    public final BOrd ord;
    private BModule module;
    private boolean loadFailed = false;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BModuleNavNode(String moduleName) {
        super(moduleName);
        this.moduleName = moduleName;
        this.ord = BOrd.make("local:|module://" + moduleName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public boolean hasNavChildren() {
        return this.load() != null;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        if (this.load() != null) {
            return this.module.getNavChild(navName);
        }
        return null;
    }

    @Override
    public BINavNode[] getNavChildren() {
        if (this.load() != null) {
            return this.module.getNavChildren();
        }
        return new BINavNode[0];
    }

    @Override
    public BOrd getNavOrd() {
        return this.ord;
    }

    public BModule load() {
        if (this.module == null && !this.loadFailed) {
            try {
                this.module = Sys.loadModule(this.moduleName);
            }
            catch (Exception e) {
                this.loadFailed = true;
            }
        }
        return this.module;
    }

    @Override
    public BIcon getIcon() {
        if (this.load() != null) {
            return this.module.getIcon();
        }
        return ERROR_ICON;
    }
}

