/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.metrics;

import com.tridium.sys.metrics.BISubLicenseable;
import com.tridium.sys.metrics.GlobalGroup;
import com.tridium.sys.metrics.Group;
import com.tridium.sys.metrics.IMetricResource;
import com.tridium.sys.metrics.SubGroup;
import com.tridium.sys.resource.ResourceReport;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.baja.collection.BITable;
import javax.baja.data.DataTypes;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNotification;
import javax.baja.util.BTypeSpec;

public final class Metrics {
    private static final DecimalFormat DF = new DecimalFormat("###,###,###");
    private static final Object lock = new Object();
    private static Type scheduleType;
    private static String recountLastRun;
    private static String recountLastFail;
    private static String recountLastFailReason;
    private static final GlobalGroup global;
    private static final Set<SubGroup> subGroups;
    private static final Map<String, Group> moduleGroups;
    private static int historyExtCount;
    public static final String HISTORY_FAULT_CAUSE = "Exceeded Global Capacity history limit.";
    private static final Set<String> excludedHistories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String incrementNetwork(BComplex comp) {
        Object object = lock;
        synchronized (object) {
            return Metrics.incrementNetwork(comp, global, moduleGroups);
        }
    }

    private static String incrementNetwork(BComplex comp, GlobalGroup globalGroup, Map<String, Group> moduleGroupsMap) {
        boolean excluded = false;
        if (globalGroup.excludedNetworks.contains((Object)comp.getType().getModule().getModuleName())) {
            excluded = true;
        } else {
            ++globalGroup.networks.used;
        }
        Group sub = Metrics.findSubGroup(comp, moduleGroupsMap);
        if (sub == null) {
            return !excluded && globalGroup.networks.used > globalGroup.networks.limit ? globalGroup.featureName : null;
        }
        ++sub.networks.used;
        if (globalGroup.networks.used > globalGroup.networks.limit) {
            return sub.networks.used > sub.networks.limit ? globalGroup.featureName + ',' + sub.featureName : globalGroup.featureName;
        }
        return sub.networks.used > sub.networks.limit ? sub.featureName : null;
    }

    public static int getGlobalNetworksLimit() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.networks.limit;
        }
        return -1;
    }

    public static int getGlobalNetworksUsed() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.networks.used;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String incrementDevice(BComplex comp) {
        Object object = lock;
        synchronized (object) {
            return Metrics.incrementDevice(comp, global, moduleGroups);
        }
    }

    private static String incrementDevice(BComplex comp, GlobalGroup globalGroup, Map<String, Group> moduleGroupsMap) {
        boolean excluded = false;
        if (globalGroup.excludedDevices.contains((Object)comp.getType().getModule().getModuleName())) {
            excluded = true;
        } else {
            ++globalGroup.devices.used;
        }
        Group sub = Metrics.findSubGroup(comp, moduleGroupsMap);
        if (sub == null) {
            return !excluded && globalGroup.devices.used > globalGroup.devices.limit ? globalGroup.featureName : null;
        }
        ++sub.devices.used;
        if (globalGroup.devices.used > globalGroup.devices.limit) {
            return sub.devices.used > sub.devices.limit ? globalGroup.featureName + ',' + sub.featureName : globalGroup.featureName;
        }
        return sub.devices.used > sub.devices.limit ? sub.featureName : null;
    }

    public static int getGlobalDevicesLimit() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.devices.limit;
        }
        return -1;
    }

    public static int getGlobalDevicesUsed() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.devices.used;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String incrementPoint(BComplex comp) {
        Object object = lock;
        synchronized (object) {
            return Metrics.incrementPoint(comp, global, moduleGroups);
        }
    }

    private static String incrementPoint(BComplex comp, GlobalGroup globalGroup, Map<String, Group> moduleGroupsMap) {
        boolean excluded = false;
        if (globalGroup.excludedPoints.contains((Object)comp.getType().getModule().getModuleName())) {
            excluded = true;
        } else {
            ++globalGroup.points.used;
        }
        Group sub = Metrics.findSubGroup(comp, moduleGroupsMap);
        if (sub == null) {
            return !excluded && globalGroup.points.used > globalGroup.points.limit ? globalGroup.featureName : null;
        }
        ++sub.points.used;
        if (globalGroup.points.used > globalGroup.points.limit) {
            return sub.points.used > sub.points.limit ? globalGroup.featureName + ',' + sub.featureName : globalGroup.featureName;
        }
        return sub.points.used > sub.points.limit ? sub.featureName : null;
    }

    public static int getGlobalPointsLimit() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.points.limit;
        }
        return -1;
    }

    public static int getGlobalPointsUsed() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.points.used;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean incrementLink() {
        Object object = lock;
        synchronized (object) {
            ++Metrics.global.links.used;
            if (Metrics.global.links.used == Metrics.global.links.limit + 1 && Sys.getStation() != null) {
                try {
                    BNotification notify = new BNotification();
                    notify.add("title", BString.make("Capacity Licensing"));
                    notify.add("message", BString.make("Exceeded Link Limit"));
                    notify.raise(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return Metrics.global.links.used <= Metrics.global.links.limit;
        }
    }

    public static int getGlobalLinksLimit() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.links.limit;
        }
        return -1;
    }

    public static int getGlobalLinksUsed() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.links.used;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean incrementHistory(String deviceName, String historyName) {
        Object object = lock;
        synchronized (object) {
            if (deviceName != null && historyName != null) {
                if (Sys.getStation() == null) {
                    return true;
                }
                if (deviceName.equals(Sys.getStation().getStationName()) && excludedHistories.contains(historyName)) {
                    return true;
                }
            }
            ++Metrics.global.histories.used;
            return Metrics.global.histories.used <= Metrics.global.histories.limit;
        }
    }

    public static int getGlobalHistoriesLimit() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.histories.limit;
        }
        return -1;
    }

    public static int getGlobalHistoriesUsed() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.histories.used;
        }
        return -1;
    }

    public static boolean incrementSchedule(BComplex schedule) {
        return Metrics.incrementSchedule(schedule, global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean incrementSchedule(BComplex schedule, GlobalGroup globalGroup) {
        Property parentProp = schedule.getPropertyInParent();
        Metrics.ensureScheduleTypeLoaded();
        if (!(schedule instanceof IMetricResource)) {
            return true;
        }
        if (schedule.getParent() != null && schedule.getParent().getType().is(scheduleType) && parentProp.isFrozen()) {
            return true;
        }
        Object object = lock;
        synchronized (object) {
            ++globalGroup.schedules.used;
            return globalGroup.schedules.used <= globalGroup.schedules.limit;
        }
    }

    private static void ensureScheduleTypeLoaded() {
        if (scheduleType == null) {
            try {
                scheduleType = BTypeSpec.make("schedule", "CompositeSchedule").getResolvedType();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getGlobalSchedulesLimit() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.schedules.limit;
        }
        return -1;
    }

    public static int getGlobalSchedulesUsed() {
        if (Metrics.global.isGlobalEnabled) {
            return Metrics.global.schedules.used;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUsingCapacityLicensing() {
        Object object = lock;
        synchronized (object) {
            return Metrics.global.isGlobalEnabled || !moduleGroups.isEmpty();
        }
    }

    public static void writeToResourceReport(ResourceReport report) {
        boolean capacityUsed = false;
        if (Metrics.global.isGlobalEnabled) {
            capacityUsed = true;
            report.put("globalCapacity.networks", String.format("%s (Limit: %s)", Metrics.getDisplayUsed(Metrics.global.networks), Metrics.getDisplayLimit(Metrics.global.networks)));
            report.put("globalCapacity.devices", String.format("%s (Limit: %s)", Metrics.getDisplayUsed(Metrics.global.devices), Metrics.getDisplayLimit(Metrics.global.devices)));
            report.put("globalCapacity.points", String.format("%s (Limit: %s)", Metrics.getDisplayUsed(Metrics.global.points), Metrics.getDisplayLimit(Metrics.global.points)));
            report.put("globalCapacity.links", String.format("%s (Limit: %s)", Metrics.getDisplayUsed(Metrics.global.links), Metrics.getDisplayLimit(Metrics.global.links)));
            if (Metrics.global.histories.used > historyExtCount) {
                report.put("globalCapacity.histories", "" + Metrics.getDisplayUsed(Metrics.global.histories) + " (Limit: " + Metrics.getDisplayLimit(Metrics.global.histories) + ")");
            } else {
                report.put("globalCapacity.histories", "" + DF.format(historyExtCount) + " (Limit: " + Metrics.getDisplayLimit(Metrics.global.histories) + ")");
            }
            report.put("globalCapacity.schedules", String.format("%s (Limit: %s)", Metrics.getDisplayUsed(Metrics.global.schedules), Metrics.getDisplayLimit(Metrics.global.schedules)));
        }
        if (!moduleGroups.isEmpty()) {
            capacityUsed = true;
            for (SubGroup group : subGroups) {
                report.put(String.format("%s.networks", group.featureName), String.format("%s (Limit: %s)", Metrics.getDisplayUsed(group.networks), Metrics.getDisplayLimit(group.networks)));
                report.put(String.format("%s.devices", group.featureName), String.format("%s (Limit: %s)", Metrics.getDisplayUsed(group.devices), Metrics.getDisplayLimit(group.devices)));
                report.put(String.format("%s.points", group.featureName), String.format("%s (Limit: %s)", Metrics.getDisplayUsed(group.points), Metrics.getDisplayLimit(group.points)));
            }
        }
        if (capacityUsed) {
            report.put("capacityLicensing.recountLastRun", recountLastRun);
            report.put("capacityLicensing.recountLastFail", recountLastFail);
            report.put("capacityLicensing.recountLastFailReason", recountLastFailReason);
        }
    }

    private static Group findSubGroup(BComplex comp, Map<String, Group> moduleGroupsMap) {
        return moduleGroupsMap.get(BISubLicenseable.getLicenseKey(comp, null));
    }

    private static String getDisplayUsed(Group.Count count) {
        return DF.format(count.used);
    }

    private static String getDisplayLimit(Group.Count count) {
        return count.limit == Integer.MAX_VALUE ? "none" : DF.format(count.limit);
    }

    private static void loadSubGroups(Set<SubGroup> subGroup, Map<String, Group> moduleGroup) {
        Feature[] farr;
        for (Feature f : farr = Sys.getLicenseManager().getFeatures()) {
            if (!f.getVendorName().toLowerCase().equals("tridium") || !f.getFeatureName().toLowerCase().startsWith("driverCapacity".toLowerCase())) continue;
            SubGroup s = new SubGroup(f);
            subGroup.add(s);
            for (int j = 0; j < s.modules.length; ++j) {
                moduleGroup.put(s.modules[j], s);
            }
        }
    }

    public static String getLastRecountRun() {
        if (Metrics.global.isGlobalEnabled) {
            return recountLastRun;
        }
        return "never";
    }

    public static String getLastRecountFail() {
        if (Metrics.global.isGlobalEnabled) {
            return recountLastFail;
        }
        return "never";
    }

    static {
        recountLastRun = "never";
        recountLastFail = "never";
        recountLastFailReason = "";
        global = new GlobalGroup();
        subGroups = new TreeSet<SubGroup>();
        moduleGroups = new HashMap<String, Group>();
        excludedHistories = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("LogHistory", "AuditHistory")));
        Metrics.loadSubGroups(subGroups, moduleGroups);
    }

    public static final class Recount
    extends Thread {
        private static final int INTERVAL = 300000;
        private static Type networkType;
        private static Type deviceType;
        private static Type pointType;
        private SlotCursor<Property> current;
        private BComplex root;
        private boolean componentOnly;
        private Stack<SlotCursor<Property>> nodeStack;
        private GlobalGroup globalBucket;
        private static final Set<SubGroup> subGroupsBucket;
        private static final Map<String, Group> moduleGroupsBucket;

        public Recount() {
            super("Nre:Metrics.Recount");
            this.setDaemon(true);
            this.setPriority(this.getPriority() - 1);
        }

        @Override
        public void run() {
            if (Metrics.isUsingCapacityLicensing()) {
                try {
                    deviceType = BTypeSpec.make("driver", "Device").getResolvedType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    networkType = BTypeSpec.make("driver", "DeviceNetwork").getResolvedType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    pointType = BTypeSpec.make("driver", "ProxyExt").getResolvedType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Metrics.ensureScheduleTypeLoaded();
                this.globalBucket = new GlobalGroup();
                Metrics.loadSubGroups(Recount.subGroupsBucket, Recount.moduleGroupsBucket);
                this.componentOnly = this.globalBucket.links.limit == Integer.MAX_VALUE;
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(300000L);
                            this.root = Sys.getStation();
                            this.current = null;
                            this.globalBucket.networks.used = 0;
                            this.globalBucket.devices.used = 0;
                            this.globalBucket.points.used = 0;
                            this.globalBucket.histories.used = 0;
                            this.globalBucket.links.used = 0;
                            this.globalBucket.schedules.used = 0;
                            for (SubGroup group : subGroupsBucket) {
                                group.networks.used = 0;
                                group.devices.used = 0;
                                group.points.used = 0;
                            }
                            this.count();
                            recountLastRun = BAbsTime.make().toString();
                        }
                    }
                    catch (Exception e) {
                        recountLastFail = BAbsTime.make().toString();
                        recountLastFailReason = e.toString();
                        continue;
                    }
                    break;
                }
            }
        }

        private static int extractCount(BITable table) {
            try (IterableCursor cursor = table.cursor();){
                if (!cursor.next()) {
                    int n = 0;
                    return n;
                }
                int n = DataTypes.otoi(cursor.cell(table.getColumns().get(0)));
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void count() {
            while (this.nextImpl()) {
                BObject o = this.get();
                if (o instanceof BPassword || o instanceof BICredentials) continue;
                this.checkMatch(o);
            }
            BOrd hisOrd = BOrd.make("history:|bql:select count(*) from sys.histories");
            int result1 = Recount.extractCount(hisOrd.get().as(BITable.class));
            BOrd hisExtOrd = BOrd.make(String.format("station:|slot:/|bql:select count(*) from history:HistoryExt where status.isFault AND faultCause like '%%%s%%'", Metrics.HISTORY_FAULT_CAUSE));
            int result2 = Recount.extractCount(hisExtOrd.get().as(BITable.class));
            BOrd hisImportOrd = BOrd.make(String.format("station:|slot:/|bql:select count(*) from driver:HistoryImport where status.isFault and faultCause like '%%%s%%'", Metrics.HISTORY_FAULT_CAUSE));
            int result3 = Recount.extractCount(hisImportOrd.get().as(BITable.class));
            this.globalBucket.histories.used = result1;
            historyExtCount = result1 + result2 + result3;
            Object object = lock;
            synchronized (object) {
                global.networks.used = this.globalBucket.networks.used;
                global.devices.used = this.globalBucket.devices.used;
                global.points.used = this.globalBucket.points.used;
                if (!this.componentOnly) {
                    global.links.used = this.globalBucket.links.used;
                }
                global.schedules.used = this.globalBucket.schedules.used;
                global.histories.used = this.globalBucket.histories.used;
                for (SubGroup subGroupBucket : subGroupsBucket) {
                    Group subToChange = (Group)moduleGroups.get(subGroupBucket.modules[0]);
                    subToChange.networks.used = subGroupBucket.networks.used;
                    subToChange.devices.used = subGroupBucket.devices.used;
                    subToChange.points.used = subGroupBucket.points.used;
                }
            }
        }

        private void checkMatch(BObject o) {
            if (o.getType().is(networkType)) {
                Metrics.incrementNetwork((BComplex)o, this.globalBucket, Recount.moduleGroupsBucket);
            } else if (o.getType().is(deviceType)) {
                Metrics.incrementDevice((BComplex)o, this.globalBucket, Recount.moduleGroupsBucket);
            } else if (o.getType().is(pointType)) {
                Metrics.incrementPoint((BComplex)o, this.globalBucket, Recount.moduleGroupsBucket);
            } else if (o.getType().is(scheduleType)) {
                Metrics.incrementSchedule((BComplex)o, this.globalBucket);
            } else if (o instanceof BLink) {
                ++this.globalBucket.links.used;
            }
        }

        private boolean nextImpl() {
            if (this.current == null) {
                if (!this.root.isComplex()) {
                    return false;
                }
                this.current = this.root.asComplex().getProperties();
                if (this.componentOnly) {
                    return this.current.nextComponent();
                }
                return this.current.next();
            }
            SlotCursor<Property> newRootProps = null;
            boolean hasProps = false;
            if (this.componentOnly ? this.current.get().isComponent() : this.current.get().isComplex()) {
                BComplex newRoot = (BComplex)this.current.get();
                newRootProps = newRoot.getProperties();
                if (this.componentOnly) {
                    if (newRootProps.nextComponent()) {
                        hasProps = true;
                    }
                } else if (newRootProps.next()) {
                    hasProps = true;
                }
            }
            if (hasProps) {
                if (this.nodeStack == null) {
                    this.nodeStack = new Stack();
                }
                this.nodeStack.push(this.current);
                this.current = newRootProps;
                return true;
            }
            while (!(!this.componentOnly ? this.current.next() : this.current.nextComponent())) {
                if (this.nodeStack == null || this.nodeStack.empty()) {
                    return false;
                }
                this.current = this.nodeStack.pop();
            }
            return true;
        }

        private BObject get() {
            return this.current.get();
        }

        static {
            subGroupsBucket = new TreeSet<SubGroup>();
            moduleGroupsBucket = new HashMap<String, Group>();
        }
    }

    public static class MetricSpy
    extends Spy {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(SpyWriter out) {
            Object object = lock;
            synchronized (object) {
                MetricSpy.writeRecountTable(out);
                MetricSpy.writeGroup(out, global);
                for (SubGroup subGroup : subGroups) {
                    MetricSpy.writeGroup(out, subGroup);
                }
            }
        }

        private static void writeRecountTable(SpyWriter out) {
            out.startTable(true);
            out.trTitle("Recount", 3);
            out.w("<tr>");
            out.w("<td>recountLastRun</td>");
            out.w("<td>").safe(recountLastRun).w("</td>");
            out.w("</tr>\n");
            out.w("<tr>");
            out.w("<td>recountLastFail</td>");
            out.w("<td>").safe(recountLastFail).w("</td>");
            out.w("</tr>\n");
            out.w("<tr>");
            out.w("<td>recountLastFailReason</td>");
            out.w("<td>").safe(recountLastFailReason).w("</td>");
            out.w("</tr>\n");
            out.endTable();
            out.w("<p/><p/>");
        }

        private static void writeGroup(SpyWriter out, Group group) {
            out.startTable(true);
            if (group.isGlobal()) {
                out.trTitle("Global Capacity", 3);
                if (!((GlobalGroup)group).excludedNetworks.isEmpty()) {
                    out.trTitle("Excluded Networks: " + ((GlobalGroup)group).excludedNetworks.toString(), 3);
                }
                if (!((GlobalGroup)group).excludedDevices.isEmpty()) {
                    out.trTitle("Excluded Devices: " + ((GlobalGroup)group).excludedDevices.toString(), 3);
                }
                if (!((GlobalGroup)group).excludedPoints.isEmpty()) {
                    out.trTitle("Excluded Points: " + ((GlobalGroup)group).excludedPoints.toString(), 3);
                }
            } else {
                String suffix = group.featureName.substring("driverCapacity".length());
                out.trTitle("Driver Capacity: " + suffix, 3);
                SubGroup sg = (SubGroup)group;
                String modules = Arrays.asList(sg.modules).toString();
                modules = modules.substring(1, modules.length() - 1);
                out.trTitle("Modules: " + modules, 3);
            }
            out.w("<tr>");
            out.w("<th>Type</th>");
            out.w("<th>Limit</th>");
            out.w("<th>Used</th>");
            out.w("</tr>\n");
            MetricSpy.writeRow(out, "Networks", group.networks);
            MetricSpy.writeRow(out, "Devices", group.devices);
            MetricSpy.writeRow(out, "Points", group.points);
            if (group.isGlobal()) {
                MetricSpy.writeRow(out, "Links", ((GlobalGroup)group).links);
                if (global.histories.used > historyExtCount) {
                    MetricSpy.writeRow(out, "Histories", ((GlobalGroup)group).histories);
                } else {
                    MetricSpy.writeRow(out, "Histories", Metrics.getDisplayLimit(((GlobalGroup)group).histories), DF.format(historyExtCount));
                }
                MetricSpy.writeRow(out, "Schedules", ((GlobalGroup)group).schedules);
            }
            out.endTable();
            out.w("<p/><p/>");
        }

        private static void writeRow(SpyWriter out, String name, Group.Count count) {
            String limit = Metrics.getDisplayLimit(count);
            MetricSpy.writeRow(out, name, limit, Metrics.getDisplayUsed(count));
        }

        private static void writeRow(SpyWriter out, String name, String limit, String count) {
            out.w("<tr>");
            out.w("<td align='left' nowrap='true'>").w(name).w("</td>");
            out.w("<td align='right' nowrap='true'>").w(limit).w("</td>");
            out.w("<td align='right' nowrap='true'>").w(count).w("</td>");
            out.w("</tr>\n");
        }
    }
}

