/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.nre.util.LicenseMode;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import com.tridium.sys.license.CertificateFile;
import com.tridium.sys.license.LicenseFile;
import com.tridium.sys.license.LicenseNotFoundException;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.NFeature;
import com.tridium.sys.license.NodeLockedLicenseManager;
import com.tridium.sys.license.subscription.SubscriptionLicenseManager;
import com.tridium.sys.module.NModule;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.license.LicenseManager;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.util.Version;

public abstract class NLicenseManager
implements LicenseManager {
    final String TRIDIUM_BRAND_KEY = LicenseUtil.toKey("tridium", "brand");
    protected static final Logger LOG = Logger.getLogger("sys.license");
    private Map<String, NFeature> features;
    private CertificateFile[] certificates;
    private LicenseFile[] licenses;
    private String fatalLicenseFault = null;

    protected NLicenseManager() {
    }

    public static NLicenseManager make() {
        if (SubscriptionLicenseUtil.getLicenseMode() == LicenseMode.SUBSCRIPTION) {
            return new SubscriptionLicenseManager();
        }
        return new NodeLockedLicenseManager();
    }

    @Override
    public Feature getFeature(String vendor, String feature) throws FeatureNotLicensedException, LicenseDatabaseException {
        if (this.fatalLicenseFault != null) {
            throw new LicenseDatabaseException(this.fatalLicenseFault);
        }
        String key = LicenseUtil.toKey(vendor, feature);
        Feature f = this.features.get(key);
        if (f == null) {
            throw new FeatureNotLicensedException(key);
        }
        return f;
    }

    @Override
    public Feature checkFeature(String vendor, String feature) throws FeatureNotLicensedException, LicenseDatabaseException {
        if (this.fatalLicenseFault != null) {
            throw new LicenseDatabaseException(this.fatalLicenseFault);
        }
        String key = LicenseUtil.toKey(vendor, feature);
        Feature f = this.features.get(key);
        if (f == null) {
            throw new FeatureNotLicensedException(key);
        }
        f.check();
        return f;
    }

    @Override
    public Feature[] getFeatures() throws LicenseDatabaseException {
        if (this.fatalLicenseFault != null) {
            throw new LicenseDatabaseException(this.fatalLicenseFault);
        }
        Object[] temp = this.features.values().toArray(new NFeature[0]);
        Object[] keys = new String[temp.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = ((NFeature)temp[i]).key;
        }
        SortUtil.sort((Object[])keys, (Object[])temp, (boolean)true);
        return temp;
    }

    public final CertificateFile getCertificate(String vendor) throws LicenseDatabaseException {
        for (CertificateFile cert : this.certificates) {
            if (!vendor.equals(cert.vendor)) continue;
            if (!cert.isValid()) {
                throw new LicenseDatabaseException("Invalid certificate for vendor: " + vendor);
            }
            return cert;
        }
        throw new LicenseDatabaseException("No certificate for vendor: " + vendor);
    }

    protected final void setFatalLicenseFault(String cause) {
        this.fatalLicenseFault = cause;
    }

    protected final boolean isFatalLicenseFault() {
        return this.fatalLicenseFault != null;
    }

    protected final CertificateFile[] getCertificates() {
        return this.certificates;
    }

    protected final void setCertificates(CertificateFile[] certificates) {
        this.certificates = certificates;
    }

    protected final LicenseFile[] getLicenses() {
        return this.licenses;
    }

    protected final void setLicenses(LicenseFile[] licenses) {
        this.licenses = licenses;
    }

    public final void checkModuleReleaseDate(NModule module) {
        Objects.requireNonNull(module);
        for (LicenseFile licenseFile : this.licenses) {
            if (!licenseFile.isValid() || !licenseFile.vendor.equalsIgnoreCase(module.getVendor())) continue;
            if (module.getReleaseDate().isPresent()) {
                if (licenseFile.maintenanceExpiration.isPresent() && module.getReleaseDate().get() > licenseFile.maintenanceExpiration.get()) {
                    throw new LicenseDatabaseException(String.format("Module %s not under active maintenance", module.getModulePartName()));
                }
            } else if (module.getVendor().equalsIgnoreCase("tridium") && (!licenseFile.unreleasedSwAccessExpiration.isPresent() || licenseFile.unreleasedSwAccessExpiration.get() < System.currentTimeMillis())) {
                throw new LicenseDatabaseException(String.format("Unreleased module '%s' not loaded", module.getModulePartName()));
            }
            return;
        }
    }

    public Optional<Long> getLicenseMaintenanceExpiration(String vendor) {
        return this.getLicenseByVendor((String)vendor).maintenanceExpiration;
    }

    public Optional<Long> getLicenseUnreleasedSwAccessExpiration(String vendor) {
        return this.getLicenseByVendor((String)vendor).unreleasedSwAccessExpiration;
    }

    public long getLicenseExpiration(String vendor) {
        return this.getLicenseByVendor((String)vendor).expiration;
    }

    public long getLicenseGeneratedTime(String vendor) {
        return this.getLicenseByVendor((String)vendor).generated;
    }

    public Version getLicenseVersion(String vendor) {
        return this.getLicenseByVendor((String)vendor).licenseVersion;
    }

    public String getLicenseHostId(String vendor) {
        return this.getLicenseByVendor((String)vendor).hostId;
    }

    private LicenseFile getLicenseByVendor(String vendor) {
        if (vendor != null) {
            for (LicenseFile licenseFile : this.licenses) {
                if (!licenseFile.vendor.equalsIgnoreCase(vendor)) continue;
                if (licenseFile.isValid()) {
                    return licenseFile;
                }
                throw new LicenseNotFoundException("License file invalid for vendor '" + vendor + '\'');
            }
        }
        throw new LicenseNotFoundException("No license file for vendor '" + vendor + '\'');
    }

    public void reload() {
        this.load();
    }

    protected final void load() {
        this.features = new HashMap<String, NFeature>();
        this.setCertificates(this.loadCertificates());
        this.setLicenses(this.loadLicenses());
    }

    protected File getLicensingDirectory() {
        return new File(NiagaraFiles.getPerpetualLicensePath().getParent());
    }

    protected CertificateFile[] loadCertificates() {
        ArrayList<CertificateFile> v = new ArrayList<CertificateFile>();
        File srcDir = new File(this.getLicensingDirectory(), "certificates");
        File[] list = srcDir.listFiles();
        for (int i = 0; list != null && i < list.length; ++i) {
            if (!list[i].getName().toLowerCase().endsWith(".certificate")) continue;
            CertificateFile cert = new CertificateFile(list[i]);
            cert.load(this);
            v.add(cert);
        }
        return v.toArray(new CertificateFile[0]);
    }

    protected abstract LicenseFile[] loadLicenses();

    protected void addFeature(NFeature feature) throws LicenseDatabaseException {
        String key = feature.key;
        NFeature orig = this.features.get(key);
        if (orig != null) {
            if (this.TRIDIUM_BRAND_KEY.equals(key)) {
                this.fatalLicenseFault = "Cannot have multiple branded licenses";
                throw new LicenseDatabaseException(this.fatalLicenseFault);
            }
            orig.merge(feature);
        } else {
            this.features.put(feature.key, feature);
        }
    }

    public void dump() {
        PrintWriter out = new PrintWriter(System.out);
        this.dump(out);
        out.flush();
    }

    public void dump(PrintWriter out) {
        out.println("");
        out.println("Niagara Licensing");
        out.println("HostId=" + Nre.getHostId());
        out.println("");
        out.println("Certificates");
        if (this.certificates.length == 0) {
            out.println("  none");
        }
        for (CertificateFile cert : this.certificates) {
            out.println("  " + cert);
        }
        out.println("");
        out.print("Licenses ");
        out.println(this instanceof NodeLockedLicenseManager ? "(perpetual)" : "(subscription)");
        if (this.licenses.length == 0) {
            out.println("  none");
        }
        for (LicenseFile license : this.licenses) {
            out.println("  " + license);
        }
        if (this.fatalLicenseFault != null) {
            return;
        }
        out.println("");
        out.println("Features");
        Feature[] features = this.getFeatures();
        if (features.length == 0) {
            out.println("  none");
        }
        for (Feature f : features) {
            out.println("  " + f);
            for (String k : f.list()) {
                out.println("    " + k + "=" + f.get(k));
            }
        }
        try {
            out.println("");
            out.println("Brand");
            out.println("  brandId            = " + Brand.getBrandId());
            out.println("  accept.station.in  = " + Brand.getAcceptStationInString());
            out.println("  accept.station.out = " + Brand.getAcceptStationOutString());
            out.println("  accept.wb.in       = " + Brand.getAcceptWbInString());
            out.println("  accept.wb.out      = " + Brand.getAcceptWbOutString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void postInit() {
        this.load();
        if (Nre.spySysManagers.find("licenseManager") != null) {
            Nre.spySysManagers.remove("licenseManager");
        }
        Nre.spySysManagers.add("licenseManager", new Page());
    }

    public void shutdown() {
    }

    public boolean isOldTridiumLicense() {
        if (this.licenses != null && this.licenses.length > 0) {
            for (LicenseFile license : this.licenses) {
                if (!license.isOldTridiumLicense()) continue;
                return true;
            }
        }
        return false;
    }

    public class Page
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            out.print("<pre>");
            NLicenseManager.this.dump(out);
            out.print("</pre>");
        }
    }
}

