/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.engine.NKnob;
import com.tridium.sys.schema.NSlot;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;

public final class SlotKnobs {
    private static final NKnob[] noKnobs = new NKnob[0];
    public final BComponent sourceComponent;
    public final NSlot sourceSlot;
    public NKnob[] knobs;
    public int size;

    public SlotKnobs(BComponent sourceComponent, NSlot sourceSlot, NKnob knob) {
        this(sourceComponent, sourceSlot);
        this.knobs = new NKnob[]{knob};
        this.size = 1;
    }

    public SlotKnobs(BComponent sourceComponent, NSlot sourceSlot) {
        this.sourceComponent = sourceComponent;
        this.sourceSlot = sourceSlot;
        this.knobs = noKnobs;
    }

    public final void propagate(BValue arg) {
        for (int i = 0; i < this.size; ++i) {
            BLink link = null;
            try {
                link = this.knobs[i].getLink();
                if (link == null || !link.isEnabled()) continue;
                link.propagate(arg);
                continue;
            }
            catch (ActionInvokeException e) {
                EngineManager.log.log(Level.SEVERE, "Link propogate: " + link, e.getCause());
                continue;
            }
            catch (Throwable e) {
                EngineManager.log.log(Level.SEVERE, "Link propogate: " + link, e);
            }
        }
    }

    public final NKnob get(int id) {
        for (int i = 0; i < this.size; ++i) {
            if (this.knobs[i].id != id) continue;
            return this.knobs[i];
        }
        return null;
    }

    public final NKnob[] list() {
        NKnob[] copy = new NKnob[this.size];
        System.arraycopy(this.knobs, 0, copy, 0, this.size);
        return copy;
    }

    public void appendTo(List<NKnob> list) {
        list.addAll(Arrays.asList(this.knobs).subList(0, this.size));
    }

    public final void add(NKnob knob) {
        if (this.size >= this.knobs.length) {
            NKnob[] temp = new NKnob[Math.max(this.size * 2, 4)];
            System.arraycopy(this.knobs, 0, temp, 0, this.knobs.length);
            this.knobs = temp;
        }
        this.knobs[this.size++] = knob;
    }

    public final void remove(NKnob knob) {
        for (int i = 0; i < this.size; ++i) {
            if (this.knobs[i] != knob) continue;
            if (i < this.knobs.length) {
                System.arraycopy(this.knobs, i + 1, this.knobs, i, this.knobs.length - i - 1);
            }
            this.knobs[this.size - 1] = null;
            --this.size;
            return;
        }
    }
}

