/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Set;

public final class SystemPropertyPermissionGroup
extends BasePermissionGroup {
    static final SystemPropertyPermissionGroup DUMMY = new SystemPropertyPermissionGroup();
    public static final String TYPE = "SYSTEM_PROPERTIES";
    private static final String PROPS_XML = "properties";
    private static final String ACTIONS_XML = "actions";
    private static final String PROPS_KEY = "permissions.systemProperty.properties";
    private static final String ACTIONS_KEY = "permissions.systemProperty.actions";
    private static final String RISK_KEY = "permissions.systemProperty.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions;

    private SystemPropertyPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MILD, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    SystemPropertyPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.MILD, flags, purposeKey, parameters, RISK_KEY);
        String propertiesString = parameters.get(PROPS_XML);
        if (propertiesString == null) {
            throw new ParsingException("Missing parameter <properties> for <SYSTEM_PROPERTIES> permission group");
        }
        String[] properties = propertiesString.split(",");
        String actions = parameters.get(ACTIONS_XML);
        if (actions == null) {
            throw new ParsingException("Missing parameter <actions> for <SYSTEM_PROPERTIES> permission group");
        }
        this.permissions = new HashSet<Permission>();
        for (String property : properties) {
            this.permissions.add(new PropertyPermission(property.trim(), actions));
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new SystemPropertyPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(PROPS_XML, PROPS_KEY, "Properties"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(ACTIONS_XML, ACTIONS_KEY, "Actions"));
    }
}

