/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.UserLoginHistoryStore;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;

public final class StationUserLoginHistoryStoreFactory {
    private static final String STATION_USER_LOGIN_HISTORY_KEY_NAME_FORMAT_STRING = "user.login.history.%s";
    private static final File PROTECTED_STATION_HOME_USER_DIRECTORY = new File(Sys.getProtectedStationHome(), "user");
    private static final File STATION_USER_LOGIN_HISTORY_FILE = new File(PROTECTED_STATION_HOME_USER_DIRECTORY, "stationlogin.edat");

    private StationUserLoginHistoryStoreFactory() {
    }

    public static UserLoginHistoryStore getInstance(String stationName) {
        if (stationName == null || stationName.isEmpty()) {
            throw new IllegalArgumentException("stationName must not be null or empty");
        }
        try {
            AccessController.doPrivileged(() -> {
                if (!PROTECTED_STATION_HOME_USER_DIRECTORY.exists() && !PROTECTED_STATION_HOME_USER_DIRECTORY.mkdir()) {
                    throw new IOException("Unable to create directory: ^^user");
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e instanceof PrivilegedActionException ? e.getCause() : e);
        }
        String stationSpecificKeyRingKeyName = String.format(STATION_USER_LOGIN_HISTORY_KEY_NAME_FORMAT_STRING, stationName);
        return AccessController.doPrivileged(() -> UserLoginHistoryStore.getInstance((File)STATION_USER_LOGIN_HISTORY_FILE, (String)stationSpecificKeyRingKeyName, (int)20, (int)20));
    }
}

