/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermission;
import java.io.File;
import java.io.FilePermission;
import java.security.Permission;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.sys.Sys;

public final class NModuleDevFilePermission
extends NiagaraPermission {
    private final Logger log = Logger.getLogger("security.niagaraPolicy.permissions");
    private static final Set<Class<? extends Permission>> classSet = Collections.singleton(FilePermission.class);
    private static Permission filePermission = null;

    public NModuleDevFilePermission(String name, String action) {
        super("moduleDev", "read");
    }

    public Set<Class<? extends Permission>> getSupportedClasses() {
        return classSet;
    }

    public boolean implies(Permission permission) {
        if (filePermission == null && Sys.getNiagaraDevHome() == null) {
            return false;
        }
        if (filePermission == null) {
            filePermission = new FilePermission(Sys.getNiagaraDevHome().getPath() + File.separator + "-", "read");
        }
        if (filePermission.implies(permission)) {
            try {
                Feature feature = Sys.getLicenseManager().checkFeature("tridium", "developer");
                boolean hasModuleDev = feature.getb("moduleDev", false);
                if (!hasModuleDev) {
                    this.log.fine("NModuleDevFilePermission: missing attribute \"moduleDev\" on \"developer\" feature.");
                    return false;
                }
                return true;
            }
            catch (FeatureNotLicensedException e) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("NModuleDevFilePermission: missing license feature: " + e.getMessage());
                }
                return false;
            }
        }
        return false;
    }
}

