/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.security.BasePermissionGroup;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HsmSigningPermissionGroup
extends BasePermissionGroup {
    public static final String TYPE = "HSM_SIGNING";
    private static final String RISK_KEY = "permissions.hsmSigning.riskDescription";
    private static final String ID_XML = "id";
    private static final String ID_KEY = "permissions.hsmSigning.id";
    protected static final HsmSigningPermissionGroup DUMMY = new HsmSigningPermissionGroup();
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions = new HashSet<Permission>();

    private HsmSigningPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
    }

    protected HsmSigningPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, parameters, RISK_KEY);
        String idString = parameters.get(ID_XML);
        Permission perm = this.createHsmSigningPermission(idString);
        if (perm != null) {
            this.permissions.add(perm);
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        return new HsmSigningPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
    }

    public boolean requiresSignature() {
        return true;
    }

    private Permission createHsmSigningPermission(String idString) {
        try {
            Class<?> hsmSigningPermissionClass = Class.forName("com.tridium.hsm.provider.HsmSigningPermission");
            Constructor<?> constructor = hsmSigningPermissionClass.getConstructor(String.class);
            return (Permission)constructor.newInstance(idString);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(ID_XML, ID_KEY, "Id"));
    }
}

