/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rpc;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryService;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCategoryRpcUtil
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BCategoryRpcUtil.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public static List<String> getCategoryPermissionsForUser(Context cx) {
        BCategoryService categoryService = (BCategoryService)Sys.getService(BCategoryService.TYPE);
        BPermissionsMap userPermissions = cx.getUser().getPermissions();
        return Arrays.stream(categoryService.getChildren(BCategory.class)).filter(category -> userPermissions.getPermissions(category.getIndex()).hasOperatorRead()).map(category -> category.toString(cx) + "|" + userPermissions.getPermissions(category.getIndex()).encodeToString()).collect(Collectors.toList());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public static String getUserPermissions(Context cx) {
        return cx.getUser().getPermissions().encodeToString();
    }
}

