/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.firewall;

import com.tridium.nre.firewall.FirewallRule;
import com.tridium.nre.firewall.InputRule;
import com.tridium.nre.firewall.NoOpRule;
import com.tridium.nre.firewall.RedirectRule;
import javax.baja.firewall.BServerPort;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.xml.XWriter;

public class FirewallRulesPage
extends SpyDir {
    @Override
    public void write(SpyWriter out) throws Exception {
        try {
            out.w("<b>").safe(BServerPort.getFirewallName()).w("</b><br><br>").nl();
            out.w("<p>").safe(BServerPort.getFirewallDescription()).w("</p><br>").nl();
            out.println("<i>NOTE: Only shows rules added by the station BServerPort objects, may be an incomplete list</i><br><br>");
            FirewallRule[] rules = BServerPort.getRuleList();
            if (rules.length == 0) {
                out.println("<i>no rules currently defined</i><br>");
            } else {
                out.w("<b>Rules</b><br><br>").nl();
                out.startTable(true);
                out.w("<tr>").nl();
                out.thTitle("rule type").nl();
                out.thTitle("publicServerPort").nl();
                out.thTitle("localServerPort").nl();
                out.thTitle("ipProtocol").nl();
                out.thTitle("adapter").nl();
                out.thTitle("hint").nl();
                out.w("</tr>").nl();
                block7: for (FirewallRule rule : rules) {
                    switch (rule.getRuleType()) {
                        case REDIRECT_RULE: {
                            RedirectRule rdrRule = (RedirectRule)rule;
                            String rdrProtocolStr = XWriter.safeToString((String)rdrRule.getIpProtocol().toString(), (boolean)false);
                            String rdrAdapterStr = XWriter.safeToString((String)rdrRule.getAdapter(), (boolean)false);
                            out.tr(rdrRule.getRuleType(), rdrRule.getPublicServerPort(), rdrRule.getLocalServerPort(), rdrProtocolStr, rdrAdapterStr);
                            continue block7;
                        }
                        case INPUT_RULE: {
                            InputRule inputRule = (InputRule)rule;
                            String inProtocolStr = XWriter.safeToString((String)inputRule.getIpProtocol().toString(), (boolean)false);
                            String inAdapterStr = XWriter.safeToString((String)inputRule.getAdapter(), (boolean)false);
                            String inHintStr = XWriter.safeToString((String)inputRule.getRuleHint(), (boolean)false);
                            out.tr(inputRule.getRuleType(), inputRule.getPublicServerPort(), inputRule.getLocalServerPort(), inProtocolStr, inAdapterStr, inHintStr);
                            continue block7;
                        }
                        case NOOP_RULE: {
                            NoOpRule noopRule = (NoOpRule)rule;
                            String noopProtocolStr = XWriter.safeToString((String)noopRule.getIpProtocol().toString(), (boolean)false);
                            String noopAdapterStr = XWriter.safeToString((String)noopRule.getAdapter(), (boolean)false);
                            String noopHintStr = XWriter.safeToString((String)noopRule.getRuleHint(), (boolean)false);
                            out.tr(noopRule.getRuleType(), noopRule.getPublicServerPort(), noopRule.getLocalServerPort(), noopProtocolStr, noopAdapterStr, noopHintStr);
                            continue block7;
                        }
                    }
                }
                out.endTable();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

