/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.firewall;

import com.tridium.nre.firewall.FirewallProcessor;
import com.tridium.nre.firewall.FirewallRule;
import com.tridium.nre.firewall.InvalidRuleException;
import com.tridium.nre.firewall.NullFirewallProcessor;
import java.util.Timer;
import java.util.TimerTask;

public class ConcurrentFirewallProcessor
extends FirewallProcessor {
    private final FirewallProcessor fw;
    private ProcessTimerTask activeTimerTask = new ProcessTimerTask();
    private Timer timer;

    public ConcurrentFirewallProcessor(FirewallProcessor fw) {
        this.fw = fw;
        if (!(fw instanceof NullFirewallProcessor)) {
            this.timer = new Timer("tFirewallProcessor", true);
        }
    }

    public FirewallRule addRule(FirewallRule rule) throws InvalidRuleException {
        rule = this.validateRule(rule);
        this.fw.addRule(rule);
        this.resetTimerTask();
        return rule;
    }

    public void removeRule(FirewallRule rule) {
        this.fw.removeRule(rule);
        this.resetTimerTask();
    }

    public FirewallRule validateRule(FirewallRule rule) throws InvalidRuleException {
        return this.fw.validateRule(rule);
    }

    private synchronized void resetTimerTask() {
        if (!(this.fw instanceof NullFirewallProcessor)) {
            this.logger.fine("resetting firewall timer task");
            this.activeTimerTask.cancel();
            this.activeTimerTask = new ProcessTimerTask();
            this.timer.schedule((TimerTask)this.activeTimerTask, 5000L);
        }
    }

    public FirewallRule[] getRulesList() {
        return this.fw.getRulesList();
    }

    public String getFirewallName() {
        return this.fw.getFirewallName();
    }

    public String getDescription() {
        return this.fw.getDescription();
    }

    public void processRules() {
        this.resetTimerTask();
    }

    public void processRule(FirewallRule rule) {
    }

    public class ProcessTimerTask
    extends TimerTask {
        @Override
        public void run() {
            ConcurrentFirewallProcessor.this.logger.fine("executing firewall timer task");
            ConcurrentFirewallProcessor.this.fw.processRules();
        }
    }
}

