/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.data;

import com.tridium.data.DataColumnList;
import javax.baja.collection.AbstractRow;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BToDataTable<T extends BIObject>
extends BObject
implements BIDataTable<T> {
    @Generated
    public static final Type TYPE = Sys.loadType(BToDataTable.class);
    private final BITable<T> innerTable;
    private final DataColumnList columns;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static <R extends BIObject> BIDataTable<R> toDataTable(BITable<R> table) {
        if (table instanceof BIDataTable) {
            return (BIDataTable)table;
        }
        return new BToDataTable<R>(table);
    }

    public BToDataTable(BITable<T> inner) {
        this.innerTable = inner;
        ColumnList innerColumns = this.innerTable.getColumns();
        int colCount = innerColumns.size();
        this.columns = new DataColumnList();
        for (int i = 0; i < colCount; ++i) {
            this.columns.addColumn(new TranslatedColumn(innerColumns.get(i)));
        }
    }

    @Override
    public TableCursor<T> cursor() {
        return new ToDataCursor(this, this.innerTable.cursor());
    }

    @Override
    public BFacets getTableFacets() {
        return this.innerTable.getTableFacets();
    }

    @Override
    public ColumnList getColumns() {
        return this.columns;
    }

    static class ToDataCursor<R extends BIObject>
    extends AbstractTableCursor<R> {
        final TableCursor<R> innerCursor;

        public ToDataCursor(BITable<R> table, TableCursor<R> innerCursor) {
            super(table);
            this.innerCursor = innerCursor;
        }

        @Override
        public Context getContext() {
            return this.innerCursor.getContext();
        }

        @Override
        public boolean advanceCursor() {
            return this.innerCursor.next();
        }

        @Override
        public void closeCursor() {
            this.innerCursor.close();
        }

        @Override
        public Row<R> row() {
            return new AbstractRow<R>(this.getTable(), (BIObject)this.innerCursor.get()){

                @Override
                public BIObject cell(Column column) {
                    return innerCursor.cell(((TranslatedColumn)column).innerColumn);
                }

                @Override
                public int getCellFlags(Column column) {
                    return innerCursor.row().getCellFlags(((TranslatedColumn)column).innerColumn);
                }

                @Override
                public BFacets getCellFacets(Column column) {
                    return innerCursor.row().getCellFacets(((TranslatedColumn)column).innerColumn);
                }

                @Override
                public Row<R> safeCopy() {
                    return this;
                }
            };
        }
    }

    static class TranslatedColumn
    implements Column {
        final Column innerColumn;
        final Type translatedType;
        final BFacets facets;

        public TranslatedColumn(Column innerColumn) {
            this.innerColumn = innerColumn;
            Type innerType = innerColumn.getType();
            if (innerType.isDataType()) {
                this.translatedType = innerType;
                this.facets = innerColumn.getFacets();
            } else {
                this.translatedType = !innerType.isAbstract() && !innerType.isInterface() && innerType.is(BValue.TYPE) ? innerType.getInstance().toDataValue().getType() : BString.TYPE;
                if (!innerType.equals(this.translatedType)) {
                    BString innerSpec = BString.make(innerType.getTypeSpec().toString());
                    this.facets = BFacets.make(innerColumn.getFacets(), "origType", innerSpec);
                } else {
                    this.facets = innerColumn.getFacets();
                }
            }
        }

        @Override
        public String getName() {
            return this.innerColumn.getName();
        }

        @Override
        public String getDisplayName(Context cx) {
            return this.innerColumn.getDisplayName(cx);
        }

        @Override
        public Type getType() {
            return this.translatedType;
        }

        @Override
        public int getFlags() {
            return this.innerColumn.getFlags();
        }

        @Override
        public BFacets getFacets() {
            return this.facets;
        }
    }
}

