/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.collection;

import com.tridium.collection.GenericColumn;
import com.tridium.util.ClassUtil;
import java.util.HashMap;
import java.util.Map;
import javax.baja.collection.ColumnList;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class GenericColumnList
implements ColumnList {
    private static final GenericColumn[] GENERIC_COLUMNS = new GenericColumn[0];
    private final GenericColumn[] columns;
    private final Map<String, GenericColumn> getHash = new HashMap<String, GenericColumn>();
    private final Map<String, Integer> idxHash = new HashMap<String, Integer>();

    public GenericColumnList(GenericColumn[] columns) {
        this.columns = columns;
        for (int i = 0; i < columns.length; ++i) {
            String name = columns[i].getName();
            this.getHash.put(name, columns[i]);
            this.idxHash.put(name, i);
        }
    }

    public GenericColumnList(BComponent[] components) {
        this((BComplex[])components);
    }

    public GenericColumnList(BComplex complex) {
        this(new BComplex[]{complex});
    }

    public GenericColumnList(BComplex[] complexes) {
        if (complexes.length > 0 && !ClassUtil.sameClass(complexes)) {
            throw new IllegalArgumentException();
        }
        if (complexes.length == 0) {
            this.columns = GENERIC_COLUMNS;
        } else {
            int i;
            BComplex c = complexes[0];
            Property[] p = c.getPropertiesArray();
            int len = p.length;
            String[] names = new String[len];
            String[] disps = new String[len];
            for (int i2 = 0; i2 < len; ++i2) {
                names[i2] = p[i2].getName();
                disps[i2] = c.getDisplayName(p[i2], null);
            }
            Type[] types = new Type[len];
            for (i = 0; i < len; ++i) {
                types[i] = p[i].getType();
            }
            this.columns = new GenericColumn[len];
            for (i = 0; i < len; ++i) {
                this.columns[i] = new GenericColumn(names[i], disps[i], types[i]);
                this.getHash.put(names[i], this.columns[i]);
                this.idxHash.put(names[i], i);
            }
        }
    }

    @Override
    public int size() {
        return this.columns.length;
    }

    @Override
    public GenericColumn get(int index) {
        return this.columns[index];
    }

    @Override
    public GenericColumn get(String name) {
        return this.getHash.get(name);
    }

    @Override
    public int indexOf(String name) {
        Integer n = this.idxHash.get(name);
        return n == null ? -1 : n;
    }

    public GenericColumn[] list() {
        return this.columns;
    }
}

