/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.nre.auth.ScramServer;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.security.BAes256Pbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public class UserKeyFactory
implements ScramServer.IUserKeyFactory {
    private final Type schemeType;

    public UserKeyFactory(Type schemeType) {
        this.schemeType = schemeType;
    }

    public String getUserKey(String username) {
        BUserService service = (BUserService)Sys.getService(BUserService.TYPE);
        BUser user = service.getUser(username);
        boolean canLogin = true;
        if (user == null) {
            canLogin = false;
        } else {
            BAuthenticationScheme scheme = user.getAuthenticationScheme();
            if (scheme == null || !scheme.getType().is(this.schemeType)) {
                canLogin = false;
            }
        }
        try {
            BAes256Pbkdf2HmacSha256PasswordEncoder encoder;
            if (!canLogin) {
                encoder = BAes256Pbkdf2HmacSha256PasswordEncoder.makeFake(username);
                return CryptographicAlgorithmBundle.extractData((String)encoder.getValue());
            }
            BAes256Pbkdf2HmacSha256PasswordEncoder.makeFake(username);
            encoder = (BAes256Pbkdf2HmacSha256PasswordEncoder)((BPasswordCache)user.getAuthenticator()).getPasswordEncoder();
            return CryptographicAlgorithmBundle.extractData((String)encoder.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not generate user key", e);
        }
    }
}

