/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.authn.NiagaraLoginModule;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public abstract class AbstractNiagaraLoginModule
extends NiagaraLoginModule {
    @Override
    public boolean login() throws LoginException {
        FailedLoginException e;
        boolean success = this.doLogin();
        if (this.user != null && this.getUserService().canLogin(this.user)) {
            return success;
        }
        if (this.user != null) {
            e = new NiagaraFailedLoginException(this.user.getName(), "Login failed: Invalid username or password.");
            this.user = null;
        } else {
            e = new FailedLoginException("Login failed: Invalid username or password.");
        }
        throw e;
    }

    protected abstract boolean doLogin() throws LoginException;
}

