/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import javax.baja.nre.util.TextUtil;

public enum EthernetFilter {
    BACNET,
    PROFINET;

    private static final int ETHERTYPE_FIRST = 12;
    private static final int ETHERTYPE_SECOND = 13;
    private static final int ETHERTYPE_FIRST_VLAN = 16;
    private static final int ETHERTYPE_SECOND_VLAN = 17;
    private static final String PROFINET_BPF = "(ether[12]==0x88 and ether[13]==0x92) or ((ether[12]==0x81 and ether[13]==0x00) and (ether[16]==0x88 and ether[17]==0x92))";
    private static final int BACNET_DSAP = 14;
    private static final int BACNET_SSAP = 15;
    private static final String BACNET_BPF = "ether[14]==0x82 and ether[15]==0x82";
    private static final int MIN_ETHERNET_FRAME_SIZE = 60;
    private static final int MAX_ETHERNET_FRAME_SIZE = 1514;
    private static final int VLAN_TAG_LENGTH = 4;

    protected final String getBPF(byte[] localMacAddress, boolean filterLocal) {
        String bpf;
        switch (this) {
            case BACNET: {
                bpf = BACNET_BPF;
                break;
            }
            case PROFINET: {
                bpf = PROFINET_BPF;
                break;
            }
            default: {
                throw new IllegalArgumentException("filter is missing!");
            }
        }
        StringBuilder sb = new StringBuilder(bpf);
        if (filterLocal) {
            sb.append(" and !(ether src ");
            for (byte macAddressByte : localMacAddress) {
                sb.append(TextUtil.byteToHexString((int)macAddressByte)).append(":");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        return sb.toString();
    }

    protected final void prepareFrame(byte[] packet) {
        if (packet == null || packet.length > 1514 || packet.length < 60) {
            throw new IllegalArgumentException("Ethernet Frame must be at least: 60 and less than: 1514");
        }
        switch (this) {
            case BACNET: {
                packet[14] = -126;
                packet[15] = -126;
                break;
            }
            case PROFINET: {
                if (packet[12] == -127 && packet[13] == 0) {
                    packet[16] = -120;
                    packet[17] = -110;
                    break;
                }
                packet[12] = -120;
                packet[13] = -110;
                break;
            }
            default: {
                throw new IllegalArgumentException("filter is missing prepareFrame logic!");
            }
        }
    }
}

