/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import com.tridium.platBacnet.EthernetFilter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="bacnet", ordinal=0), @Range(value="profinet", ordinal=1)})
public final class BEthernetFrameType
extends BFrozenEnum {
    @Generated
    public static final int BACNET = 0;
    @Generated
    public static final int PROFINET = 1;
    @Generated
    public static final BEthernetFrameType bacnet = new BEthernetFrameType(0);
    @Generated
    public static final BEthernetFrameType profinet = new BEthernetFrameType(1);
    @Generated
    public static final BEthernetFrameType DEFAULT = bacnet;
    @Generated
    public static final Type TYPE = Sys.loadType(BEthernetFrameType.class);

    @Generated
    public static BEthernetFrameType make(int ordinal) {
        return (BEthernetFrameType)bacnet.getRange().get(ordinal, false);
    }

    @Generated
    public static BEthernetFrameType make(String tag) {
        return (BEthernetFrameType)bacnet.getRange().get(tag);
    }

    @Generated
    private BEthernetFrameType(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final EthernetFilter toEthernetFilter() {
        EthernetFilter ethernetFilter;
        switch (this.getOrdinal()) {
            case 0: {
                ethernetFilter = EthernetFilter.BACNET;
                break;
            }
            case 1: {
                ethernetFilter = EthernetFilter.PROFINET;
                break;
            }
            default: {
                throw new IllegalArgumentException("frame type is missing!");
            }
        }
        return ethernetFilter;
    }

    public static BEthernetFrameType fromEthernetFilter(EthernetFilter ethernetFilter) {
        BEthernetFrameType frameType;
        switch (ethernetFilter) {
            case BACNET: {
                frameType = bacnet;
                break;
            }
            case PROFINET: {
                frameType = profinet;
                break;
            }
            default: {
                throw new IllegalArgumentException("frame type is missing!");
            }
        }
        return frameType;
    }
}

