/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.util;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.sys.Nre;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.baja.nre.util.TextUtil;

public class UsbInfoQnx {
    private static final String FRONT_PANEL_USB_INFO_COMMAND = "/proc/boot/usb -b0 -d3";
    private static final String U_MAP_FILE_PATH = "/tmp/u_map";
    private static final String U_MAP_ERROR_FILE_PATH = "/tmp/u_map_error";
    public static final int NUM_U_MAP_SPACE_DELIMITED_FIELDS = 10;
    public static final String SERIAL_PORT_PREFIX = "COM";
    public static final String LON_PORT_PREFIX = "LON";
    private final ArrayList<ArrayList<HashMap<String, String>>> buses = UsbInfoQnx.makeBuses();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<ArrayList<HashMap<String, String>>> makeBuses() {
        HashMap<String, String> currentDevice;
        BufferedReader bufferedReader = UsbInfoQnx.accessFile(U_MAP_FILE_PATH, false);
        if (bufferedReader == null) {
            return null;
        }
        ArrayList<ArrayList<HashMap<String, String>>> buses = new ArrayList<ArrayList<HashMap<String, String>>>();
        ArrayList onboardBusArrayList = new ArrayList();
        ArrayList expansionBusArrayList = new ArrayList();
        buses.add(onboardBusArrayList);
        buses.add(expansionBusArrayList);
        String oldPosition = "-1";
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                if (BHardwareScanService.LOG.isLoggable(Level.FINE)) {
                    BHardwareScanService.LOG.fine("Parsing map line: '" + line + "'");
                }
                int vendorParenStart = line.indexOf(" (");
                String vendorStr = UsbInfoQnx.extractFromParens(vendorParenStart, line).trim();
                int vendorStrEnd = line.indexOf(vendorStr) + vendorStr.length() + 2;
                String productStr = UsbInfoQnx.extractFromParens(vendorStrEnd, line).trim();
                String infoLine = line.substring(0, vendorParenStart);
                StringTokenizer st = new StringTokenizer(infoLine);
                if (st.countTokens() != 10) {
                    BHardwareScanService.LOG.severe("Unexpected option card code format, cannot enumerate devices");
                    ArrayList<ArrayList<HashMap<String, String>>> arrayList = null;
                    return arrayList;
                }
                String name = st.nextToken();
                String osName = st.nextToken();
                int busNum = Integer.parseInt(st.nextToken());
                st.nextToken();
                String position = st.nextToken();
                if (position.equals(oldPosition)) continue;
                oldPosition = position;
                String vendorId = st.nextToken();
                String productId = st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                currentDevice = new HashMap();
                currentDevice.put("Vendor", vendorId);
                currentDevice.put("Product", productId);
                currentDevice.put("Position", position);
                currentDevice.put("Name", name);
                currentDevice.put("OsName", osName);
                currentDevice.put("VendorStr", vendorStr);
                currentDevice.put("ProductStr", productStr);
                if (busNum == 0) {
                    onboardBusArrayList.add(currentDevice);
                    continue;
                }
                if (busNum != 1) continue;
                expansionBusArrayList.add(currentDevice);
            }
        }
        catch (IOException vendorParenStart) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        if (expansionBusArrayList.isEmpty()) {
            BufferedReader errorFile = UsbInfoQnx.accessFile(U_MAP_ERROR_FILE_PATH, false);
            if (errorFile == null) {
                return buses;
            }
            try {
                String errorString;
                try {
                    errorString = errorFile.readLine();
                }
                catch (IOException ioException) {
                    BHardwareScanService.LOG.severe("Cannot read USB error log");
                    errorString = "unknown error";
                }
                for (int i = 0; i < 4; ++i) {
                    currentDevice = new HashMap<String, String>();
                    currentDevice.put("Vendor", "XX");
                    currentDevice.put("Product", "XX");
                    currentDevice.put("Position", "" + (i + 1));
                    currentDevice.put("Name", "ERROR");
                    currentDevice.put("OsName", "none");
                    currentDevice.put("VendorStr", "none");
                    currentDevice.put("ProductStr", errorString);
                    expansionBusArrayList.add(currentDevice);
                }
            }
            finally {
                try {
                    errorFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buses;
    }

    public String toOptionCardCodes() {
        StringBuilder codes = new StringBuilder(Nre.getHostModel().toUpperCase(Locale.ENGLISH));
        ArrayList<HashMap<String, String>> bus = this.buses.get(1);
        for (HashMap<String, String> device : bus) {
            String vendor = device.get("Vendor");
            String product = device.get("Product");
            vendor = vendor.replace("0x", "").toUpperCase(Locale.ENGLISH);
            product = product.replace("0x", "").toUpperCase(Locale.ENGLISH);
            codes.append(" ").append(vendor).append(" ").append(product);
        }
        return codes.toString();
    }

    public static boolean isFrontPanelUSBOccupied() {
        String deviceStr = UsbInfoQnx.readFrontPanelUSB();
        return !deviceStr.equals("none");
    }

    public static String getUsbConfigError() {
        String usbConfigError;
        BufferedReader bufferedReader = UsbInfoQnx.accessFile(U_MAP_ERROR_FILE_PATH, false);
        if (bufferedReader == null) {
            return "none";
        }
        try {
            usbConfigError = bufferedReader.readLine();
        }
        catch (IOException ioException) {
            usbConfigError = "unable to read USB error file";
            BHardwareScanService.LOG.warning("Unable to read USB error file");
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return usbConfigError;
    }

    private static String readFrontPanelUSB() {
        String productString = "none";
        try {
            Process proc = AccessController.doPrivileged(() -> {
                try {
                    return new ProcessBuilder(TextUtil.split((String)FRONT_PANEL_USB_INFO_COMMAND, (char)' ')).start();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            });
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    if (!line.startsWith("Product    ")) continue;
                    String[] strings = line.split(":");
                    productString = strings[1];
                    break;
                }
            }
        }
        catch (IOException ioException) {
            BHardwareScanService.LOG.warning("Could not determine device attached to USB port");
        }
        return productString;
    }

    private static String extractFromParens(int startNdx, String line) {
        Objects.requireNonNull(line, "line argument cannot be null");
        StringCharacterIterator characterIterator = new StringCharacterIterator(line, startNdx, line.length(), startNdx);
        char c = characterIterator.first();
        int leftParenCount = 0;
        boolean reading = false;
        StringBuilder sb = new StringBuilder();
        while (c != '\uffff') {
            if (c == '(') {
                if (++leftParenCount == 1) {
                    reading = true;
                    c = characterIterator.next();
                    continue;
                }
            } else if (c == ')' && leftParenCount > 0 && --leftParenCount == 0) break;
            if (reading) {
                sb.append(c);
            }
            c = characterIterator.next();
        }
        return sb.toString();
    }

    private static BufferedReader accessFile(String fileName, boolean reportError) {
        BufferedReader bufferedReader;
        block3: {
            bufferedReader = null;
            try {
                if (BHardwareScanService.LOG.isLoggable(Level.FINE)) {
                    BHardwareScanService.LOG.fine("Accessing file '" + fileName + "'...");
                }
                bufferedReader = AccessController.doPrivileged(() -> new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8)));
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!reportError) break block3;
                BHardwareScanService.LOG.log(Level.SEVERE, "Cannot access file '" + fileName + "'", privilegedActionException);
            }
        }
        return bufferedReader;
    }
}

