/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ports;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.enums.BWifiModeEnum;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.sys.Nre;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperty(name="Mode", type="BWifiModeEnum", defaultValue="BWifiModeEnum.DEFAULT", flags=1)
public class BWifiPort
extends BEthernetPort {
    @Generated
    public static final Property Mode = BWifiPort.newProperty((int)1, (BValue)BWifiModeEnum.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiPort.class);
    private static final int OFF = 0;
    private static final int STATION = 1;
    private static final int ACCESS_POINT = 2;
    private static final int ACCESS_POINT_CONTROLLED = 3;
    private static final int UNKNOWN = -1;

    @Generated
    public BWifiModeEnum getMode() {
        return (BWifiModeEnum)this.get(Mode);
    }

    @Generated
    public void setMode(BWifiModeEnum v) {
        this.set(Mode, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiPort() {
        this.setPortType(BPortTypeEnum.wifi);
    }

    @Override
    public void initStatus() {
        if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
            this.setStatus(BHwScanStatusEnum.disabled);
            this.setMode(BWifiModeEnum.disabled);
            this.setAdapterId("");
        } else if ("ATLAS".equals(Nre.getHostModel().toUpperCase(Locale.ENGLISH))) {
            BDaemonSession session;
            BHwScanStatusEnum wifiStatus = BHwScanStatusEnum.noPort;
            BWifiModeEnum wifiMode = BWifiModeEnum.disabled;
            String wifiAdapterId = "";
            if (AccessController.doPrivileged(LocalSessionUtil::localDaemonIsAvailable).booleanValue() && (session = AccessController.doPrivileged(LocalSessionUtil::getLocalSession)).getHostProperties().supportsServlet("wifi")) {
                try {
                    XElem wifiSettingsElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new XmlResponseMessage(){

                        public String getMessageString() {
                            return "wifi?sendSettings=true";
                        }
                    })).parse();
                    int wifiSwitchPosition = wifiSettingsElem.geti("wifiSwitch", -1);
                    if (wifiSwitchPosition == 0) {
                        wifiStatus = BHwScanStatusEnum.disabled;
                        wifiMode = BWifiModeEnum.disabled;
                    } else if (wifiSwitchPosition == 1) {
                        wifiStatus = BHwScanStatusEnum.available;
                        wifiMode = BWifiModeEnum.client;
                        XElem stationSettingsElem = wifiSettingsElem.elem("stationSettings");
                        wifiAdapterId = stationSettingsElem.get("staAdapter", "");
                    } else if (wifiSwitchPosition == 2 || wifiSwitchPosition == 3) {
                        wifiStatus = BHwScanStatusEnum.available;
                        wifiMode = wifiSwitchPosition == 2 ? BWifiModeEnum.ap : BWifiModeEnum.accessPointControlled;
                        XElem accessPointSettingsElem = wifiSettingsElem.elem("accessPointSettings");
                        wifiAdapterId = accessPointSettingsElem.get("sapAdapter", "");
                    } else {
                        wifiStatus = BHwScanStatusEnum.unknown;
                        wifiMode = BWifiModeEnum.disabled;
                    }
                }
                catch (Exception exception) {
                    BHardwareScanService.LOG.log(Level.WARNING, "Failed to obtain local Wi-Fi configuration", exception);
                }
            }
            this.setStatus(wifiStatus);
            this.setMode(wifiMode);
            this.setAdapterId(wifiAdapterId);
        } else {
            this.setStatus(BHwScanStatusEnum.noPort);
            this.setMode(BWifiModeEnum.disabled);
            this.setAdapterId("");
        }
    }
}

