/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.pciCards;

import com.tridium.platHwScan.BHardwareScanService;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="description", type="String", defaultValue="", flags=1), @NiagaraProperty(name="locator", type="String", defaultValue="", flags=1), @NiagaraProperty(name="sideViewImage", type="String", defaultValue="", flags=1), @NiagaraProperty(name="topViewImage", type="String", defaultValue="", flags=1)})
public class BPciCard
extends BComponent {
    @Generated
    public static final Property description = BPciCard.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property locator = BPciCard.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property sideViewImage = BPciCard.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property topViewImage = BPciCard.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPciCard.class);
    private static ConcurrentHashMap<String, BPciCard> cardCatalog = null;
    private static final String[] CARD_FILES = new String[]{"module://platHwScan/rc/platHwScanPciCards.xml"};

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public String getLocator() {
        return this.getString(locator);
    }

    @Generated
    public void setLocator(String v) {
        this.setString(locator, v, null);
    }

    @Generated
    public String getSideViewImage() {
        return this.getString(sideViewImage);
    }

    @Generated
    public void setSideViewImage(String v) {
        this.setString(sideViewImage, v, null);
    }

    @Generated
    public String getTopViewImage() {
        return this.getString(topViewImage);
    }

    @Generated
    public void setTopViewImage(String v) {
        this.setString(topViewImage, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPciCard() {
    }

    public BPciCard(String description) {
        this.setDescription(description);
    }

    public BPciCard(String description, String locator) {
        this.setDescription(description);
        this.setLocator(locator);
    }

    public static String[] getCardFiles() {
        return CARD_FILES;
    }

    protected String getCardKey() {
        return this.getLocator();
    }

    public static void addPciCardReference(BPciCard pciCard) {
        if (!pciCard.getLocator().isEmpty()) {
            cardCatalog.put(pciCard.getLocator(), pciCard);
        }
    }

    private static void buildCardCatalog() {
        cardCatalog = new ConcurrentHashMap();
        for (String cardFile : CARD_FILES) {
            try {
                ConcurrentHashMap<String, BPciCard> pciCardByLocator = BPciCard.parseCardFile(cardFile);
                if (pciCardByLocator == null) continue;
                Enumeration<String> keys = pciCardByLocator.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (cardCatalog.get(key) != null) {
                        BHardwareScanService.LOG.warning(BHardwareScanService.LEX.getText("PciCard.duplicateLocator", new Object[]{key}));
                    }
                    cardCatalog.put(key, pciCardByLocator.get(key));
                }
            }
            catch (Exception exception) {
                BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("parsingError", new Object[]{exception.getClass().getName(), cardFile}), exception);
            }
        }
    }

    public static ConcurrentHashMap<String, BPciCard> getCardCatalog() {
        if (cardCatalog == null) {
            BPciCard.buildCardCatalog();
        }
        return cardCatalog;
    }

    protected static ConcurrentHashMap<String, BPciCard> parseCardFile(String filePath) throws Exception {
        XElem[] elements;
        XElem root;
        if (BHardwareScanService.LOG.isLoggable(Level.FINE)) {
            BHardwareScanService.LOG.fine(BHardwareScanService.LEX.getText("parsingNotification", new Object[]{filePath}));
        }
        try {
            BOrd fileOrd = BOrd.make((String)filePath);
            BIFile file = (BIFile)fileOrd.get();
            root = XParser.make((InputStream)file.getInputStream()).parse();
        }
        catch (Exception exception) {
            if (exception instanceof UnresolvedException) {
                if (BHardwareScanService.LOG.isLoggable(Level.FINE)) {
                    BHardwareScanService.LOG.fine(BHardwareScanService.LEX.getText("fileDoesNotExist", new Object[]{filePath}));
                }
                return null;
            }
            if (exception instanceof EOFException) {
                BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("unexpectedEof", new Object[]{filePath}), exception);
                return null;
            }
            throw exception;
        }
        if (!root.name().equalsIgnoreCase("pciCards")) {
            BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("fileFormatError", new Object[]{filePath, root.name(), "pciCards"}));
            return null;
        }
        ConcurrentHashMap<String, BPciCard> pciCardByLocator = new ConcurrentHashMap<String, BPciCard>();
        for (XElem nextElement : elements = root.elems()) {
            String name = nextElement.name();
            if (!name.equalsIgnoreCase("pciCard")) continue;
            try {
                BPciCard pciCard = new BPciCard();
                pciCard.setDescription(BHardwareScanService.LEX.getText(nextElement.get("description")));
                pciCard.setLocator(nextElement.get("locator"));
                pciCard.setSideViewImage(nextElement.get("sideViewImage", ""));
                pciCard.setTopViewImage(nextElement.get("topViewImage", ""));
                pciCardByLocator.put(pciCard.getLocator(), pciCard);
            }
            catch (Exception exception) {
                BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("parsingError", new Object[]{exception.getClass().getName(), nextElement.toString()}), exception);
            }
        }
        return pciCardByLocator;
    }
}

